/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueTestUtil;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hadoop.hbase.regionserver.CellArrayImmutableSegment;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.RegionServicesForStores;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.TestDefaultMemStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestCompactingMemStore
extends TestDefaultMemStore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCompactingMemStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCompactingMemStore.class);
    protected static ChunkCreator chunkCreator;
    protected HRegion region;
    protected RegionServicesForStores regionServicesForStores;
    protected HStore store;

    protected static byte[] makeQualifier(int i1, int i2) {
        return Bytes.toBytes((String)(Integer.toString(i1) + ";" + Integer.toString(i2)));
    }

    @After
    public void tearDown() throws Exception {
        chunkCreator.clearChunksInPool();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.compactingSetUp();
        this.memstore = new MyCompactingMemStore(HBaseConfiguration.create(), CellComparator.getInstance(), this.store, this.regionServicesForStores, MemoryCompactionPolicy.EAGER);
        ((CompactingMemStore)this.memstore).setIndexType(CompactingMemStore.IndexType.ARRAY_MAP);
    }

    protected void compactingSetUp() throws Exception {
        super.internalSetUp();
        Configuration conf = new Configuration();
        conf.setBoolean("hbase.hregion.memstore.mslab.enabled", true);
        conf.setFloat("hbase.hregion.memstore.chunkpool.maxsize", 0.2f);
        conf.setInt("hbase.regionserver.optionalcacheflushinterval", 1000);
        HBaseTestingUtility hbaseUtility = HBaseTestingUtility.createLocalHTU(conf);
        HColumnDescriptor hcd = new HColumnDescriptor(FAMILY);
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)"foobar"));
        htd.addFamily(hcd);
        HRegionInfo info = new HRegionInfo(TableName.valueOf((String)"foobar"), null, null, false);
        WAL wal = HBaseTestingUtility.createWal(conf, hbaseUtility.getDataTestDir(), (RegionInfo)info);
        this.region = HRegion.createHRegion((RegionInfo)info, (Path)hbaseUtility.getDataTestDir(), (Configuration)conf, (TableDescriptor)htd, (WAL)wal, (boolean)true);
        this.regionServicesForStores = (RegionServicesForStores)Mockito.spy((Object)this.region.getRegionServicesForStores());
        ThreadPoolExecutor pool = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        Mockito.when((Object)this.regionServicesForStores.getInMemoryCompactionPool()).thenReturn((Object)pool);
        this.store = new HStore(this.region, (ColumnFamilyDescriptor)hcd, conf, false);
        long globalMemStoreLimit = (long)((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * MemorySizeUtil.getGlobalMemStoreHeapPercent((Configuration)conf, (boolean)false));
        chunkCreator = ChunkCreator.initialize((int)0x200000, (boolean)false, (long)globalMemStoreLimit, (float)0.4f, (float)0.0f, null, (float)0.1f);
        Assert.assertNotNull((Object)chunkCreator);
    }

    @Test
    public void testTimeOfOldestEdit() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memstore.timeOfOldestEdit());
        byte[] r = Bytes.toBytes((String)"r");
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((String)"v");
        KeyValue kv = new KeyValue(r, f, q, v);
        this.memstore.add((Cell)kv, null);
        long timeOfOldestEdit = this.memstore.timeOfOldestEdit();
        Assert.assertNotEquals((long)Long.MAX_VALUE, (long)timeOfOldestEdit);
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)timeOfOldestEdit, (long)this.memstore.timeOfOldestEdit());
        this.memstore.add((Cell)kv, null);
        Assert.assertEquals((long)timeOfOldestEdit, (long)this.memstore.timeOfOldestEdit());
        this.memstore.snapshot();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.memstore.timeOfOldestEdit());
    }

    @Override
    @Test
    public void testScanAcrossSnapshot2() throws IOException, CloneNotSupportedException {
        byte[] one = Bytes.toBytes((int)1);
        byte[] two = Bytes.toBytes((int)2);
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] v = Bytes.toBytes((int)3);
        KeyValue kv1 = new KeyValue(one, f, q, 10L, v);
        KeyValue kv2 = new KeyValue(two, f, q, 10L, v);
        this.memstore.add((Cell)kv1.clone(), null);
        this.memstore.add((Cell)kv2.clone(), null);
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore.snapshot();
        this.verifyScanAcrossSnapshot2(kv1, kv2);
        this.memstore = new CompactingMemStore(HBaseConfiguration.create(), CellComparator.getInstance(), this.store, this.regionServicesForStores, MemoryCompactionPolicy.EAGER);
        this.memstore.add((Cell)kv1.clone(), null);
        this.memstore.snapshot();
        this.memstore.add((Cell)kv2.clone(), null);
        this.verifyScanAcrossSnapshot2(kv1, kv2);
    }

    @Override
    @Test
    public void testSnapshotting() throws IOException {
        int snapshotCount = 5;
        for (int i = 0; i < 5; ++i) {
            this.addRows(this.memstore);
            this.runSnapshot(this.memstore, true);
            Assert.assertEquals((String)"History not being cleared", (long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        }
    }

    @Override
    @Test
    public void testGetNextRow() throws Exception {
        this.addRows(this.memstore);
        Thread.sleep(1L);
        this.addRows(this.memstore);
        Cell closestToEmpty = ((CompactingMemStore)this.memstore).getNextRow((Cell)KeyValue.LOWESTKEY);
        Assert.assertTrue((CellComparator.getInstance().compareRows(closestToEmpty, (Cell)new KeyValue(Bytes.toBytes((int)0), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            Cell nr = ((CompactingMemStore)this.memstore).getNextRow((Cell)new KeyValue(Bytes.toBytes((int)i), System.currentTimeMillis()));
            if (i + 1 == 10) {
                Assert.assertNull((Object)nr);
                continue;
            }
            Assert.assertTrue((CellComparator.getInstance().compareRows(nr, (Cell)new KeyValue(Bytes.toBytes((int)(i + 1)), System.currentTimeMillis())) == 0 ? 1 : 0) != 0);
        }
        Configuration conf = HBaseConfiguration.create();
        for (int startRowId = 0; startRowId < 10; ++startRowId) {
            ScanInfo scanInfo = new ScanInfo(conf, FAMILY, 0, 1, Integer.MAX_VALUE, KeepDeletedCells.FALSE, 65536L, 0L, this.memstore.getComparator(), false);
            try (StoreScanner scanner = new StoreScanner(new Scan().withStartRow(Bytes.toBytes((int)startRowId)), scanInfo, null, this.memstore.getScanners(0L));){
                ArrayList results = new ArrayList();
                int i = 0;
                while (scanner.next(results)) {
                    int rowId = startRowId + i;
                    Cell left = (Cell)results.get(0);
                    byte[] row1 = Bytes.toBytes((int)rowId);
                    Assert.assertTrue((String)"Row name", (CellComparator.getInstance().compareRows(left, row1, 0, row1.length) == 0 ? 1 : 0) != 0);
                    Assert.assertEquals((String)"Count of columns", (long)10L, (long)results.size());
                    ArrayList<Cell> row = new ArrayList<Cell>();
                    for (Cell kv : results) {
                        row.add(kv);
                    }
                    this.isExpectedRowWithoutTimestamps(rowId, row);
                    results.clear();
                    ++i;
                }
                continue;
            }
        }
    }

    @Override
    @Test
    public void testGet_memstoreAndSnapShot() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        this.memstore.snapshot();
        Assert.assertEquals((long)3L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
    }

    @Override
    @Test
    public void testUpsertMemstoreSize() throws Exception {
        MemStoreSize oldSize = this.memstore.size();
        ArrayList<KeyValue> l = new ArrayList<KeyValue>();
        KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
        KeyValue kv2 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)101L, (String)"v");
        KeyValue kv3 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)102L, (String)"v");
        kv1.setSequenceId(1L);
        kv2.setSequenceId(1L);
        kv3.setSequenceId(1L);
        l.add(kv1);
        l.add(kv2);
        l.add(kv3);
        this.memstore.upsert(l, 2L, null);
        MemStoreSize newSize = this.memstore.size();
        assert (newSize.getDataSize() > oldSize.getDataSize());
        assert (this.memstore.getActive().getCellsCount() == 2);
        KeyValue kv4 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)104L, (String)"v");
        kv4.setSequenceId(1L);
        l.clear();
        l.add(kv4);
        this.memstore.upsert(l, 3L, null);
        Assert.assertEquals((Object)newSize, (Object)this.memstore.size());
        assert (this.memstore.getActive().getCellsCount() == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testUpdateToTimeOfOldestEdit() throws Exception {
        try {
            EnvironmentEdgeForMemstoreTest edge = new EnvironmentEdgeForMemstoreTest();
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)edge);
            long t = this.memstore.timeOfOldestEdit();
            Assert.assertEquals((long)Long.MAX_VALUE, (long)t);
            this.memstore.add((Cell)KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v"), null);
            t = this.memstore.timeOfOldestEdit();
            Assert.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot(this.memstore, true);
            this.memstore.add((Cell)KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (KeyValue.Type)KeyValue.Type.Delete, (String)"v"), null);
            t = this.memstore.timeOfOldestEdit();
            Assert.assertTrue((t == 1234L ? 1 : 0) != 0);
            t = this.runSnapshot(this.memstore, true);
            ArrayList<KeyValue> l = new ArrayList<KeyValue>();
            KeyValue kv1 = KeyValueTestUtil.create((String)"r", (String)"f", (String)"q", (long)100L, (String)"v");
            kv1.setSequenceId(100L);
            l.add(kv1);
            this.memstore.upsert(l, 1000L, null);
            t = this.memstore.timeOfOldestEdit();
            Assert.assertTrue((t == 1234L ? 1 : 0) != 0);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    private long runSnapshot(AbstractMemStore hmc, boolean useForce) throws IOException {
        long oldHistorySize = hmc.getSnapshot().getDataSize();
        long prevTimeStamp = hmc.timeOfOldestEdit();
        hmc.snapshot();
        MemStoreSnapshot snapshot = hmc.snapshot();
        if (useForce) {
            Assert.assertTrue((String)"History size has not increased", (oldHistorySize < snapshot.getDataSize() ? 1 : 0) != 0);
            long t = hmc.timeOfOldestEdit();
            Assert.assertTrue((String)"Time of oldest edit is not Long.MAX_VALUE", (t == Long.MAX_VALUE ? 1 : 0) != 0);
            hmc.clearSnapshot(snapshot.getId());
        } else {
            long t = hmc.timeOfOldestEdit();
            Assert.assertTrue((String)"Time of oldest edit didn't remain the same", (t == prevTimeStamp ? 1 : 0) != 0);
        }
        return prevTimeStamp;
    }

    private void isExpectedRowWithoutTimestamps(int rowIndex, List<Cell> kvs) {
        int i = 0;
        for (Cell kv : kvs) {
            byte[] expectedColname = TestCompactingMemStore.makeQualifier(rowIndex, i++);
            Assert.assertTrue((String)"Column name", (boolean)CellUtil.matchingQualifier((Cell)kv, (byte[])expectedColname));
            Assert.assertTrue((String)"Content", (boolean)CellUtil.matchingValue((Cell)kv, (byte[])expectedColname));
        }
    }

    @Test
    public void testPuttingBackChunksAfterFlushing() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        Assert.assertEquals((long)3L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        int chunkCount = chunkCreator.getPoolSize();
        Assert.assertTrue((chunkCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPuttingBackChunksWithOpeningScanner() throws IOException {
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] qf4 = Bytes.toBytes((String)"testqualifier4");
        byte[] qf5 = Bytes.toBytes((String)"testqualifier5");
        byte[] qf6 = Bytes.toBytes((String)"testqualifier6");
        byte[] qf7 = Bytes.toBytes((String)"testqualifier7");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, val), null);
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        Assert.assertEquals((long)3L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf4, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf5, val), null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        List scanners = this.memstore.getScanners(0L);
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() == 0 ? 1 : 0) != 0);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
        chunkCreator.clearChunksInPool();
        snapshot = this.memstore.snapshot();
        this.memstore.add((Cell)new KeyValue(row, fam, qf6, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf7, val), null);
        scanners = this.memstore.getScanners(0L);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPuttingBackChunksWithOpeningPipelineScanner() throws IOException {
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.EAGER;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        byte[] row = Bytes.toBytes((String)"testrow");
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf1 = Bytes.toBytes((String)"testqualifier1");
        byte[] qf2 = Bytes.toBytes((String)"testqualifier2");
        byte[] qf3 = Bytes.toBytes((String)"testqualifier3");
        byte[] val = Bytes.toBytes((String)"testval");
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, 1L, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, 1L, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, 1L, val), null);
        ((MyCompactingMemStore)this.memstore).disableCompaction();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, 2L, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, 2L, val), null);
        Assert.assertEquals((long)2L, (long)this.memstore.getActive().getCellsCount());
        ((CompactingMemStore)this.memstore).flushInMemory();
        List scanners = this.memstore.getScanners(0L);
        ((MyCompactingMemStore)this.memstore).enableCompaction();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getActive().getCellsCount());
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, 3L, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, 3L, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf1, 3L, val), null);
        Assert.assertEquals((long)3L, (long)this.memstore.getActive().getCellsCount());
        Assert.assertTrue((chunkCreator.getPoolSize() == 0 ? 1 : 0) != 0);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
        chunkCreator.clearChunksInPool();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        snapshot = this.memstore.snapshot();
        this.memstore.add((Cell)new KeyValue(row, fam, qf2, 4L, val), null);
        this.memstore.add((Cell)new KeyValue(row, fam, qf3, 4L, val), null);
        scanners = this.memstore.getScanners(0L);
        for (KeyValueScanner scanner : scanners) {
            scanner.close();
        }
        for (KeyValueScanner scanner : snapshot.getScanners()) {
            scanner.close();
        }
        this.memstore.clearSnapshot(snapshot.getId());
        Assert.assertTrue((chunkCreator.getPoolSize() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompaction1Bucket() throws IOException {
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        String[] keys1 = new String[]{"A", "A", "B", "C"};
        int totalCellsLen = this.addRowsByKeys(this.memstore, keys1);
        int oneCellOnCSLMHeapSize = 120;
        int oneCellOnCAHeapSize = 88;
        long totalHeapSize = MutableSegment.DEEP_OVERHEAD + (long)(4 * oneCellOnCSLMHeapSize);
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellArrayImmutableSegment.DEEP_OVERHEAD_CAM + (long)(4 * oneCellOnCAHeapSize);
        Assert.assertEquals((long)totalCellsLen, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        MemStoreSize mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss);
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)4L, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Test
    public void testCompaction2Buckets() throws IOException {
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.BASIC;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        this.memstore.getConfiguration().set("hbase.hregion.compacting.pipeline.segments.limit", String.valueOf(1));
        ((MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        String[] keys1 = new String[]{"A", "A", "B", "C"};
        String[] keys2 = new String[]{"A", "B", "D"};
        int totalCellsLen1 = this.addRowsByKeys(this.memstore, keys1);
        int oneCellOnCSLMHeapSize = 120;
        int oneCellOnCAHeapSize = 88;
        long totalHeapSize = MutableSegment.DEEP_OVERHEAD + (long)(4 * oneCellOnCSLMHeapSize);
        Assert.assertEquals((long)totalCellsLen1, (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        int counter = 0;
        for (Segment s : this.memstore.getSegments()) {
            counter += s.getCellsCount();
        }
        Assert.assertEquals((long)4L, (long)counter);
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)totalCellsLen1, (long)this.regionServicesForStores.getMemStoreSize());
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellArrayImmutableSegment.DEEP_OVERHEAD_CAM + (long)(4 * oneCellOnCAHeapSize);
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        int totalCellsLen2 = this.addRowsByKeys(this.memstore, keys2);
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)(totalHeapSize += (long)(3 * oneCellOnCSLMHeapSize)), (long)((CompactingMemStore)this.memstore).heapSize());
        MemStoreSize mss = this.memstore.getFlushableSize();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2), (long)this.regionServicesForStores.getMemStoreSize());
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellArrayImmutableSegment.DEEP_OVERHEAD_CAM + (long)(7 * oneCellOnCAHeapSize);
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)7L, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Test
    public void testCompaction3Buckets() throws IOException {
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.EAGER;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        ((MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        String[] keys1 = new String[]{"A", "A", "B", "C"};
        String[] keys2 = new String[]{"A", "B", "D"};
        String[] keys3 = new String[]{"D", "B", "B"};
        int totalCellsLen1 = this.addRowsByKeys(this.memstore, keys1);
        int oneCellOnCSLMHeapSize = 120;
        int oneCellOnCAHeapSize = 88;
        Assert.assertEquals((long)totalCellsLen1, (long)this.region.getMemStoreDataSize());
        long totalHeapSize = MutableSegment.DEEP_OVERHEAD + (long)(4 * oneCellOnCSLMHeapSize);
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        totalCellsLen1 = totalCellsLen1 * 3 / 4;
        Assert.assertEquals((long)totalCellsLen1, (long)this.regionServicesForStores.getMemStoreSize());
        totalHeapSize = MutableSegment.DEEP_OVERHEAD + CellArrayImmutableSegment.DEEP_OVERHEAD_CAM + (long)(3 * oneCellOnCAHeapSize);
        Assert.assertEquals((long)totalHeapSize, (long)((CompactingMemStore)this.memstore).heapSize());
        int totalCellsLen2 = this.addRowsByKeys(this.memstore, keys2);
        long totalHeapSize2 = totalHeapSize + (long)(3 * oneCellOnCSLMHeapSize);
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)totalHeapSize2, (long)((CompactingMemStore)this.memstore).heapSize());
        ((MyCompactingMemStore)this.memstore).disableCompaction();
        MemStoreSize mss = this.memstore.getFlushableSize();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)(totalHeapSize2 + CellArrayImmutableSegment.DEEP_OVERHEAD_CAM), (long)((CompactingMemStore)this.memstore).heapSize());
        int totalCellsLen3 = this.addRowsByKeys(this.memstore, keys3);
        Assert.assertEquals((long)(totalCellsLen1 + totalCellsLen2 + totalCellsLen3), (long)this.regionServicesForStores.getMemStoreSize());
        long totalHeapSize3 = totalHeapSize2 + CellArrayImmutableSegment.DEEP_OVERHEAD_CAM + (long)(3 * oneCellOnCSLMHeapSize);
        Assert.assertEquals((long)totalHeapSize3, (long)((CompactingMemStore)this.memstore).heapSize());
        ((MyCompactingMemStore)this.memstore).enableCompaction();
        mss = this.memstore.getFlushableSize();
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        totalCellsLen3 = 0;
        Assert.assertEquals((long)(totalCellsLen1 + (totalCellsLen2 /= 3) + totalCellsLen3), (long)this.regionServicesForStores.getMemStoreSize());
        Assert.assertEquals((long)((long)(4 * oneCellOnCAHeapSize) + MutableSegment.DEEP_OVERHEAD + CellArrayImmutableSegment.DEEP_OVERHEAD_CAM), (long)((CompactingMemStore)this.memstore).heapSize());
        mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize(), mss.getCellsCount());
        ImmutableSegment s = this.memstore.getSnapshot();
        Assert.assertEquals((long)4L, (long)s.getCellsCount());
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    @Test
    public void testMagicCompaction3Buckets() throws IOException {
        MemoryCompactionPolicy compactionType = MemoryCompactionPolicy.ADAPTIVE;
        this.memstore.getConfiguration().set("hbase.hregion.compacting.memstore.type", String.valueOf(compactionType));
        this.memstore.getConfiguration().setDouble("hbase.hregion.compacting.memstore.adaptive.compaction.threshold", 0.45);
        this.memstore.getConfiguration().setInt("hbase.hregion.compacting.pipeline.segments.limit", 2);
        this.memstore.getConfiguration().setInt("hbase.memstore.inmemoryflush.threshold.factor", 1);
        ((MyCompactingMemStore)this.memstore).initiateType(compactionType, this.memstore.getConfiguration());
        String[] keys1 = new String[]{"A", "B", "D"};
        String[] keys2 = new String[]{"A"};
        String[] keys3 = new String[]{"A", "A", "B", "C"};
        String[] keys4 = new String[]{"D", "B", "B"};
        int totalCellsLen1 = this.addRowsByKeys(this.memstore, keys1);
        int oneCellOnCSLMHeapSize = 120;
        Assert.assertEquals((long)totalCellsLen1, (long)this.region.getMemStoreDataSize());
        long totalHeapSize = MutableSegment.DEEP_OVERHEAD + (long)(3 * oneCellOnCSLMHeapSize);
        Assert.assertEquals((long)totalHeapSize, (long)this.memstore.heapSize());
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)3L, (long)((CompactingMemStore)this.memstore).getImmutableSegments().getNumOfCells());
        Assert.assertEquals((double)1.0, (double)((CompactingMemStore)this.memstore).getImmutableSegments().getEstimatedUniquesFrac(), (double)0.0);
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        this.addRowsByKeys(this.memstore, keys2);
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)4L, (long)((CompactingMemStore)this.memstore).getImmutableSegments().getNumOfCells());
        Assert.assertEquals((double)1.0, (double)((CompactingMemStore)this.memstore).getImmutableSegments().getEstimatedUniquesFrac(), (double)0.0);
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        this.addRowsByKeys(this.memstore, keys3);
        ((CompactingMemStore)this.memstore).flushInMemory();
        Assert.assertEquals((long)8L, (long)((CompactingMemStore)this.memstore).getImmutableSegments().getNumOfCells());
        Assert.assertEquals((double)0.5, (double)((CompactingMemStore)this.memstore).getImmutableSegments().getEstimatedUniquesFrac(), (double)0.0);
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        this.addRowsByKeys(this.memstore, keys4);
        ((CompactingMemStore)this.memstore).flushInMemory();
        int numCells = ((CompactingMemStore)this.memstore).getImmutableSegments().getNumOfCells();
        Assert.assertTrue((4 == numCells || 11 == numCells ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.memstore.getSnapshot().getCellsCount());
        MemStoreSize mss = this.memstore.getFlushableSize();
        MemStoreSnapshot snapshot = this.memstore.snapshot();
        this.region.decrMemStoreSize(mss);
        ImmutableSegment s = this.memstore.getSnapshot();
        numCells = s.getCellsCount();
        Assert.assertTrue((4 == numCells || 11 == numCells ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.regionServicesForStores.getMemStoreSize());
        this.memstore.clearSnapshot(snapshot.getId());
    }

    protected int addRowsByKeys(AbstractMemStore hmc, String[] keys) {
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf = Bytes.toBytes((String)"testqualifier");
        long size = hmc.getActive().getDataSize();
        long heapOverhead = hmc.getActive().getHeapSize();
        int cellsCount = hmc.getActive().getCellsCount();
        int totalLen = 0;
        for (int i = 0; i < keys.length; ++i) {
            long timestamp = System.currentTimeMillis();
            Threads.sleep((long)1L);
            byte[] row = Bytes.toBytes((String)keys[i]);
            byte[] val = Bytes.toBytes((String)(keys[i] + i));
            KeyValue kv = new KeyValue(row, fam, qf, timestamp, val);
            totalLen += Segment.getCellLength((Cell)kv);
            hmc.add((Cell)kv, null);
            LOG.debug("added kv: " + kv.getKeyString() + ", timestamp:" + kv.getTimestamp());
        }
        this.regionServicesForStores.addMemStoreSize(hmc.getActive().getDataSize() - size, hmc.getActive().getHeapSize() - heapOverhead, 0L, hmc.getActive().getCellsCount() - cellsCount);
        return totalLen;
    }

    protected int addRowsByKeys(AbstractMemStore hmc, String[] keys, byte[] val) {
        byte[] fam = Bytes.toBytes((String)"testfamily");
        byte[] qf = Bytes.toBytes((String)"testqualifier");
        long size = hmc.getActive().getDataSize();
        long heapOverhead = hmc.getActive().getHeapSize();
        int cellsCount = hmc.getActive().getCellsCount();
        int totalLen = 0;
        for (int i = 0; i < keys.length; ++i) {
            long timestamp = System.currentTimeMillis();
            Threads.sleep((long)1L);
            byte[] row = Bytes.toBytes((String)keys[i]);
            KeyValue kv = new KeyValue(row, fam, qf, timestamp, val);
            totalLen += Segment.getCellLength((Cell)kv);
            hmc.add((Cell)kv, null);
            LOG.debug("added kv: " + kv.getKeyString() + ", timestamp:" + kv.getTimestamp());
        }
        this.regionServicesForStores.addMemStoreSize(hmc.getActive().getDataSize() - size, hmc.getActive().getHeapSize() - heapOverhead, 0L, cellsCount);
        return totalLen;
    }

    protected static class MyCompactingMemStore
    extends CompactingMemStore {
        public MyCompactingMemStore(Configuration conf, CellComparator c, HStore store, RegionServicesForStores regionServices, MemoryCompactionPolicy compactionPolicy) throws IOException {
            super(conf, c, store, regionServices, compactionPolicy);
        }

        void disableCompaction() {
            this.allowCompaction.set(false);
        }

        void enableCompaction() {
            this.allowCompaction.set(true);
        }

        void initiateType(MemoryCompactionPolicy compactionType, Configuration conf) throws IllegalArgumentIOException {
            this.compactor.initiateCompactionStrategy(compactionType, conf, "CF_TEST");
        }
    }

    private class EnvironmentEdgeForMemstoreTest
    implements EnvironmentEdge {
        long t = 1234L;

        private EnvironmentEdgeForMemstoreTest() {
        }

        public long currentTime() {
            return this.t;
        }

        public void setCurrentTimeMillis(long t) {
            this.t = t;
        }
    }
}

