/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.CachedMobFile;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SmallTests.class})
public class TestCachedMobFile {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCachedMobFile.class);
    static final Logger LOG = LoggerFactory.getLogger(TestCachedMobFile.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf = TEST_UTIL.getConfiguration();
    private CacheConfig cacheConf = new CacheConfig(this.conf);
    private static final String FAMILY1 = "familyName1";
    private static final String FAMILY2 = "familyName2";
    private static final long EXPECTED_REFERENCE_ZERO = 0L;
    private static final long EXPECTED_REFERENCE_ONE = 1L;
    private static final long EXPECTED_REFERENCE_TWO = 2L;
    @Rule
    public TestName testName = new TestName();

    @Test
    public void testOpenClose() throws Exception {
        String caseName = this.testName.getMethodName();
        Path testDir = TEST_UTIL.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, fs).withOutputDir(testDir).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer, caseName);
        CachedMobFile cachedMobFile = CachedMobFile.create((FileSystem)fs, (Path)writer.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        Assert.assertEquals((long)0L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.open();
        Assert.assertEquals((long)1L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.open();
        Assert.assertEquals((long)2L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.close();
        Assert.assertEquals((long)1L, (long)cachedMobFile.getReferenceCount());
        cachedMobFile.close();
        Assert.assertEquals((long)0L, (long)cachedMobFile.getReferenceCount());
    }

    @Test
    public void testCompare() throws Exception {
        String caseName = this.testName.getMethodName();
        Path testDir = TEST_UTIL.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.conf);
        Path outputDir1 = new Path(testDir, FAMILY1);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer1 = new StoreFileWriter.Builder(this.conf, this.cacheConf, fs).withOutputDir(outputDir1).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer1, caseName);
        CachedMobFile cachedMobFile1 = CachedMobFile.create((FileSystem)fs, (Path)writer1.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        Path outputDir2 = new Path(testDir, FAMILY2);
        StoreFileWriter writer2 = new StoreFileWriter.Builder(this.conf, this.cacheConf, fs).withOutputDir(outputDir2).withFileContext(meta).build();
        MobTestUtil.writeStoreFile(writer2, caseName);
        CachedMobFile cachedMobFile2 = CachedMobFile.create((FileSystem)fs, (Path)writer2.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        cachedMobFile1.access(1L);
        cachedMobFile2.access(2L);
        Assert.assertEquals((long)1L, (long)cachedMobFile1.compareTo(cachedMobFile2));
        Assert.assertEquals((long)-1L, (long)cachedMobFile2.compareTo(cachedMobFile1));
        Assert.assertEquals((long)0L, (long)cachedMobFile1.compareTo(cachedMobFile1));
    }

    @Test
    public void testReadKeyValue() throws Exception {
        Path testDir = TEST_UTIL.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, fs).withOutputDir(testDir).withFileContext(meta).build();
        String caseName = this.testName.getMethodName();
        MobTestUtil.writeStoreFile(writer, caseName);
        CachedMobFile cachedMobFile = CachedMobFile.create((FileSystem)fs, (Path)writer.getPath(), (Configuration)this.conf, (CacheConfig)this.cacheConf);
        byte[] family = Bytes.toBytes((String)caseName);
        byte[] qualify = Bytes.toBytes((String)caseName);
        byte[] startKey = Bytes.toBytes((String)"aa");
        KeyValue expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        KeyValue seekKey = expectedKey.createKeyOnly(false);
        Cell cell = cachedMobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] endKey = Bytes.toBytes((String)"zz");
        expectedKey = new KeyValue(endKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, endKey);
        seekKey = expectedKey.createKeyOnly(false);
        cell = cachedMobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] randomKey = Bytes.toBytes((String)MobTestUtil.generateRandomString(2));
        expectedKey = new KeyValue(randomKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, randomKey);
        seekKey = expectedKey.createKeyOnly(false);
        cell = cachedMobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] lowerKey = Bytes.toBytes((String)"a1");
        expectedKey = new KeyValue(startKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, startKey);
        seekKey = new KeyValue(lowerKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, lowerKey);
        cell = cachedMobFile.readCell((Cell)seekKey, false).getCell();
        MobTestUtil.assertCellEquals((Cell)expectedKey, cell);
        byte[] upperKey = Bytes.toBytes((String)"z{");
        seekKey = new KeyValue(upperKey, family, qualify, Long.MAX_VALUE, KeyValue.Type.Put, upperKey);
        Assert.assertNull((Object)cachedMobFile.readCell((Cell)seekKey, false));
    }
}

