/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.normalizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerWorkQueue;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionNormalizerWorkQueue {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionNormalizerWorkQueue.class);
    @Rule
    public TestName testName = new TestName();

    @Test
    public void testElementUniquenessAndFIFO() throws Exception {
        RegionNormalizerWorkQueue queue = new RegionNormalizerWorkQueue();
        LinkedList<Object> content = new LinkedList<Object>();
        IntStream.of(4, 3, 2, 1, 4, 3, 2, 1).boxed().forEach(arg_0 -> ((RegionNormalizerWorkQueue)queue).put(arg_0));
        Assert.assertEquals((long)4L, (long)queue.size());
        while (queue.size() > 0) {
            content.add(queue.take());
        }
        MatcherAssert.assertThat(content, (Matcher)Matchers.contains((Object[])new Integer[]{4, 3, 2, 1}));
        queue.clear();
        queue.putAll(Arrays.asList(4, 3, 2, 1));
        queue.putAll(Arrays.asList(4, 5));
        Assert.assertEquals((long)5L, (long)queue.size());
        content.clear();
        while (queue.size() > 0) {
            content.add(queue.take());
        }
        MatcherAssert.assertThat(content, (Matcher)Matchers.contains((Object[])new Integer[]{4, 3, 2, 1, 5}));
    }

    @Test
    public void testPriorityAndFIFO() throws Exception {
        RegionNormalizerWorkQueue queue = new RegionNormalizerWorkQueue();
        LinkedList content = new LinkedList();
        queue.putAll(Arrays.asList(4, 3, 2, 1));
        Assert.assertEquals((long)4L, (long)queue.size());
        queue.putFirst((Object)0);
        Assert.assertEquals((long)5L, (long)queue.size());
        TestRegionNormalizerWorkQueue.drainTo(queue, content);
        MatcherAssert.assertThat((String)"putFirst items should jump the queue, preserving existing order", content, (Matcher)Matchers.contains((Object[])new Integer[]{0, 4, 3, 2, 1}));
        queue.clear();
        content.clear();
        queue.putAll(Arrays.asList(4, 3, 2, 1));
        queue.putFirst((Object)1);
        Assert.assertEquals((long)4L, (long)queue.size());
        TestRegionNormalizerWorkQueue.drainTo(queue, content);
        MatcherAssert.assertThat((String)"existing items re-added with putFirst should jump the queue", content, (Matcher)Matchers.contains((Object[])new Integer[]{1, 4, 3, 2}));
        queue.clear();
        content.clear();
        queue.putAll(Arrays.asList(4, 3, 2, 1));
        queue.putAllFirst(Arrays.asList(2, 3));
        Assert.assertEquals((long)4L, (long)queue.size());
        TestRegionNormalizerWorkQueue.drainTo(queue, content);
        MatcherAssert.assertThat((String)"existing items re-added with putAllFirst jump the queue AND honor changes in priority", content, (Matcher)Matchers.contains((Object[])new Integer[]{2, 3, 4, 1}));
    }

    @Test
    public void testConcurrentPut() throws Exception {
        RegionNormalizerWorkQueue queue = new RegionNormalizerWorkQueue();
        int maxValue = 100;
        Runnable producer = () -> {
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            block6: for (int i = 0; i < 1000; ++i) {
                Action action = Action.values()[((Random)rand).nextInt(Action.values().length)];
                switch (action) {
                    case PUT: {
                        int val = ((Random)rand).nextInt(100);
                        queue.put((Object)val);
                        continue block6;
                    }
                    case PUT_FIRST: {
                        int val = ((Random)rand).nextInt(100);
                        queue.putFirst((Object)val);
                        continue block6;
                    }
                    case PUT_ALL: {
                        List vals = ((Random)rand).ints(5L, 0, 100).boxed().collect(Collectors.toList());
                        queue.putAll(vals);
                        continue block6;
                    }
                    case PUT_ALL_FIRST: {
                        List vals = ((Random)rand).ints(5L, 0, 100).boxed().collect(Collectors.toList());
                        queue.putAllFirst(vals);
                        continue block6;
                    }
                    default: {
                        Assert.fail((String)("Unrecognized action " + (Object)((Object)action)));
                    }
                }
            }
        };
        int numThreads = 5;
        CompletableFuture[] futures = (CompletableFuture[])IntStream.range(0, 5).mapToObj(val -> CompletableFuture.runAsync(producer)).toArray(CompletableFuture[]::new);
        CompletableFuture.allOf(futures).join();
        ArrayList content = new ArrayList(queue.size());
        TestRegionNormalizerWorkQueue.drainTo(queue, content);
        MatcherAssert.assertThat((String)"at most `maxValue` items should be present.", (Object)content.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(100)));
        Assert.assertEquals((String)"all items should be unique.", (long)content.size(), (long)new HashSet(content).size());
    }

    @Test
    public void testTake() throws Exception {
        RegionNormalizerWorkQueue queue = new RegionNormalizerWorkQueue();
        ConcurrentLinkedQueue takeTimes = new ConcurrentLinkedQueue();
        AtomicBoolean finished = new AtomicBoolean(false);
        Runnable consumer = () -> {
            try {
                while (!finished.get()) {
                    queue.take();
                    takeTimes.add(System.nanoTime());
                }
            }
            catch (InterruptedException e) {
                Assert.fail((String)"interrupted.");
            }
        };
        CompletableFuture<Void> worker = CompletableFuture.runAsync(consumer);
        long testStart = System.nanoTime();
        for (int i = 0; i < 5; ++i) {
            Thread.sleep(10L);
            queue.put((Object)i);
        }
        finished.set(true);
        queue.put((Object)1);
        worker.get(1L, TimeUnit.SECONDS);
        Iterator times = takeTimes.iterator();
        Assert.assertTrue((String)"should have timing information for at least 2 calls to take.", (takeTimes.size() >= 5 ? 1 : 0) != 0);
        for (int i = 0; i < 5; ++i) {
            MatcherAssert.assertThat((String)"Observations collected in takeTimes should increase by roughly 10ms every interval", times.next(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(testStart + TimeUnit.MILLISECONDS.toNanos(i * 10))));
        }
    }

    private static <E> void drainTo(RegionNormalizerWorkQueue<E> queue, Collection<E> dest) throws InterruptedException {
        MatcherAssert.assertThat((Object)queue.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        while (queue.size() > 0) {
            dest.add(queue.take());
        }
    }

    private static enum Action {
        PUT,
        PUT_FIRST,
        PUT_ALL,
        PUT_ALL_FIRST;

    }
}

