/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RackManager;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestStochasticLoadBalancerRegionReplicaWithRacks
extends BalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStochasticLoadBalancerRegionReplicaWithRacks.class);

    @Test
    public void testRegionReplicationOnMidClusterWithRacks() {
        conf.setLong("hbase.master.balancer.stochastic.maxSteps", 10000000L);
        conf.setFloat("hbase.master.balancer.stochastic.maxMovePercent", 1.0f);
        conf.setLong("hbase.master.balancer.stochastic.maxRunningTime", 120000L);
        loadBalancer.setConf(conf);
        int numNodes = 30;
        int numRegions = numNodes * 30;
        int replication = 3;
        int numRegionsPerServer = 28;
        int numTables = 10;
        int numRacks = 4;
        Map<ServerName, List<RegionInfo>> serverMap = this.createServerMap(numNodes, numRegions, numRegionsPerServer, replication, numTables);
        ForTestRackManager rm = new ForTestRackManager(numRacks);
        this.testWithCluster(serverMap, rm, false, true);
    }

    private static class ForTestRackManager
    extends RackManager {
        int numRacks;

        public ForTestRackManager(int numRacks) {
            this.numRacks = numRacks;
        }

        public String getRack(ServerName server) {
            return "rack_" + server.hashCode() % this.numRacks;
        }
    }
}

