/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ProcedureTestUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestCloseRegionWhileRSCrash {
    private static final Logger LOG = LoggerFactory.getLogger(TestCloseRegionWhileRSCrash.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCloseRegionWhileRSCrash.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"Backoff");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static CountDownLatch ARRIVE = new CountDownLatch(1);
    private static CountDownLatch RESUME = new CountDownLatch(1);

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        UTIL.startMiniCluster(3);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.getAdmin().balancerSwitch(false, true);
        HRegionServer srcRs = UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        if (!srcRs.getRegions(TableName.META_TABLE_NAME).isEmpty()) {
            RegionInfo metaRegion = ((HRegion)srcRs.getRegions(TableName.META_TABLE_NAME).get(0)).getRegionInfo();
            HRegionServer dstRs = UTIL.getOtherRegionServer(srcRs);
            UTIL.getAdmin().move(metaRegion.getEncodedNameAsBytes(), dstRs.getServerName());
            UTIL.waitFor(30000L, () -> !dstRs.getRegions(TableName.META_TABLE_NAME).isEmpty());
        }
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRetryBackoff() throws IOException, InterruptedException {
        HRegionServer srcRs = UTIL.getRSForFirstRegionInTable(TABLE_NAME);
        RegionInfo region = ((HRegion)srcRs.getRegions(TABLE_NAME).get(0)).getRegionInfo();
        HRegionServer dstRs = UTIL.getOtherRegionServer(srcRs);
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        procExec.submitProcedure((Procedure)new DummyServerProcedure(srcRs.getServerName()));
        ARRIVE.await();
        UTIL.getMiniHBaseCluster().killRegionServer(srcRs.getServerName());
        UTIL.waitFor(30000L, () -> procExec.getProcedures().stream().anyMatch(p -> p instanceof ServerCrashProcedure));
        Thread t = new Thread(() -> {
            try {
                UTIL.getAdmin().move(region.getEncodedNameAsBytes(), dstRs.getServerName());
            }
            catch (IOException e) {
                LOG.info("Failed move of {}", (Object)region.getRegionNameAsString(), (Object)e);
            }
        });
        t.start();
        ProcedureTestUtil.waitUntilProcedureWaitingTimeout(UTIL, TransitRegionStateProcedure.class, 30000L);
        ProcedureTestUtil.waitUntilProcedureTimeoutIncrease(UTIL, TransitRegionStateProcedure.class, 3);
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        master.getConnection().close();
        RESUME.countDown();
        UTIL.waitFor(30000L, () -> !master.isAlive());
        HMaster master2 = UTIL.getMiniHBaseCluster().startMaster().getMaster();
        LOG.info("Master2 {}, joining move thread", (Object)master2.getServerName());
        t.join();
        try (Table table = UTIL.getConnection().getTable(TABLE_NAME);){
            table.put(new Put(Bytes.toBytes((int)1)).addColumn(CF, Bytes.toBytes((String)"cq"), Bytes.toBytes((int)1)));
        }
        table = UTIL.getConnection().getTable(TABLE_NAME);
        var9_9 = null;
        try {
            table.put(new Put(Bytes.toBytes((int)1)).addColumn(CF, Bytes.toBytes((String)"cq"), Bytes.toBytes((int)1)));
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (table != null) {
                if (var9_9 != null) {
                    try {
                        table.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    table.close();
                }
            }
        }
    }

    public static final class DummyServerProcedure
    extends Procedure<MasterProcedureEnv>
    implements ServerProcedureInterface {
        private ServerName serverName;

        public DummyServerProcedure() {
        }

        public DummyServerProcedure(ServerName serverName) {
            this.serverName = serverName;
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public boolean hasMetaTableRegion() {
            return false;
        }

        public ServerProcedureInterface.ServerOperationType getServerOperationType() {
            return ServerProcedureInterface.ServerOperationType.CRASH_HANDLER;
        }

        protected Procedure<MasterProcedureEnv>[] execute(MasterProcedureEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            ARRIVE.countDown();
            RESUME.await();
            return null;
        }

        protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
            if (env.getProcedureScheduler().waitServerExclusiveLock((Procedure)this, this.getServerName())) {
                return Procedure.LockState.LOCK_EVENT_WAIT;
            }
            return Procedure.LockState.LOCK_ACQUIRED;
        }

        protected void releaseLock(MasterProcedureEnv env) {
            env.getProcedureScheduler().wakeServerExclusiveLock((Procedure)this, this.getServerName());
        }

        protected boolean holdLock(MasterProcedureEnv env) {
            return true;
        }

        protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        }

        protected boolean abort(MasterProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }
}

