/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializerIdManager;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hadoop.hbase.io.hfile.bucket.ByteBufferIOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.RefCnt;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IOTests.class, SmallTests.class})
public class TestByteBufferIOEngine {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestByteBufferIOEngine.class);
    private static BufferGrabbingDeserializer DESERIALIZER = new BufferGrabbingDeserializer();

    static BucketEntry createBucketEntry(long offset, int len) {
        return TestByteBufferIOEngine.createBucketEntry(offset, len, ByteBuffAllocator.HEAP);
    }

    static BucketEntry createBucketEntry(long offset, int len, ByteBuffAllocator allocator) {
        MockBucketEntry be = new MockBucketEntry(offset, len, allocator);
        be.setDeserializerReference(DESERIALIZER);
        return be;
    }

    static ByteBuff getByteBuff(BucketEntry be) {
        return ((BufferGrabbingDeserializer)be.deserializerReference()).buf;
    }

    @Test
    public void testByteBufferIOEngine() throws Exception {
        int capacity = 0x2000000;
        int testNum = 100;
        int maxBlockSize = 65536;
        ByteBufferIOEngine ioEngine = new ByteBufferIOEngine((long)capacity);
        int testOffsetAtStartNum = testNum / 10;
        int testOffsetAtEndNum = testNum / 10;
        for (int i = 0; i < testNum; ++i) {
            int offset;
            byte val = (byte)(Math.random() * 255.0);
            int blockSize = (int)(Math.random() * (double)maxBlockSize);
            if (blockSize == 0) {
                blockSize = 1;
            }
            ByteBuff src = TestByteBufferIOEngine.createByteBuffer(blockSize, val, i % 2 == 0);
            int pos = src.position();
            int lim = src.limit();
            if (testOffsetAtStartNum > 0) {
                --testOffsetAtStartNum;
                offset = 0;
            } else if (testOffsetAtEndNum > 0) {
                --testOffsetAtEndNum;
                offset = capacity - blockSize;
            } else {
                offset = (int)(Math.random() * (double)(capacity - maxBlockSize));
            }
            ioEngine.write(src, (long)offset);
            src.position(pos).limit(lim);
            BucketEntry be = TestByteBufferIOEngine.createBucketEntry(offset, blockSize);
            ioEngine.read(be);
            ByteBuff dst = TestByteBufferIOEngine.getByteBuff(be);
            Assert.assertEquals((long)src.remaining(), (long)blockSize);
            Assert.assertEquals((long)dst.remaining(), (long)blockSize);
            Assert.assertEquals((long)0L, (long)ByteBuff.compareTo((ByteBuff)src, (int)src.position(), (int)src.remaining(), (ByteBuff)dst, (int)dst.position(), (int)dst.remaining()));
        }
        assert (testOffsetAtStartNum == 0);
        assert (testOffsetAtEndNum == 0);
    }

    static ByteBuff createByteBuffer(int len, int val, boolean useHeap) {
        ByteBuffer b = useHeap ? ByteBuffer.allocate(2 * len) : ByteBuffer.allocateDirect(2 * len);
        int pos = (int)(Math.random() * (double)len);
        b.position(pos).limit(pos + len);
        for (int i = pos; i < pos + len; ++i) {
            b.put(i, (byte)val);
        }
        return ByteBuff.wrap((ByteBuffer)b);
    }

    @Test
    public void testByteBufferIOEngineWithMBB() throws Exception {
        int capacity = 0x2000000;
        int testNum = 100;
        int maxBlockSize = 65536;
        ByteBufferIOEngine ioEngine = new ByteBufferIOEngine((long)capacity);
        int testOffsetAtStartNum = testNum / 10;
        int testOffsetAtEndNum = testNum / 10;
        for (int i = 0; i < testNum; ++i) {
            int offset;
            byte val = (byte)(Math.random() * 255.0);
            int blockSize = (int)(Math.random() * (double)maxBlockSize);
            if (blockSize == 0) {
                blockSize = 1;
            }
            ByteBuff src = TestByteBufferIOEngine.createByteBuffer(blockSize, val, i % 2 == 0);
            int pos = src.position();
            int lim = src.limit();
            if (testOffsetAtStartNum > 0) {
                --testOffsetAtStartNum;
                offset = 0;
            } else if (testOffsetAtEndNum > 0) {
                --testOffsetAtEndNum;
                offset = capacity - blockSize;
            } else {
                offset = (int)(Math.random() * (double)(capacity - maxBlockSize));
            }
            ioEngine.write(src, (long)offset);
            src.position(pos).limit(lim);
            BucketEntry be = TestByteBufferIOEngine.createBucketEntry(offset, blockSize);
            ioEngine.read(be);
            ByteBuff dst = TestByteBufferIOEngine.getByteBuff(be);
            Assert.assertEquals((long)src.remaining(), (long)blockSize);
            Assert.assertEquals((long)dst.remaining(), (long)blockSize);
            Assert.assertEquals((long)0L, (long)ByteBuff.compareTo((ByteBuff)src, (int)src.position(), (int)src.remaining(), (ByteBuff)dst, (int)dst.position(), (int)dst.remaining()));
        }
        assert (testOffsetAtStartNum == 0);
        assert (testOffsetAtEndNum == 0);
    }

    static {
        int id = CacheableDeserializerIdManager.registerDeserializer((CacheableDeserializer)DESERIALIZER);
        DESERIALIZER.setIdentifier(id);
    }

    static class BufferGrabbingDeserializer
    implements CacheableDeserializer<Cacheable> {
        private ByteBuff buf;
        private int identifier;

        BufferGrabbingDeserializer() {
        }

        public Cacheable deserialize(ByteBuff b, ByteBuffAllocator alloc) throws IOException {
            this.buf = b;
            return null;
        }

        public void setIdentifier(int identifier) {
            this.identifier = identifier;
        }

        public int getDeserializerIdentifier() {
            return this.identifier;
        }
    }

    private static class MockBucketEntry
    extends BucketEntry {
        private long off;

        MockBucketEntry(long offset, int length, ByteBuffAllocator allocator) {
            super(offset & 0xFF00L, length, 0L, false, RefCnt.create(), allocator);
            this.off = offset;
        }

        long offset() {
            return this.off;
        }
    }
}

