/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.io.util.BlockIOUtils;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

@Category(value={IOTests.class, SmallTests.class})
public class TestBlockIOUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBlockIOUtils.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Test
    public void testIsByteBufferReadable() throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path p = new Path(TEST_UTIL.getDataTestDirOnTestFS(), "testIsByteBufferReadable");
        try (FSDataOutputStream out = fs.create(p);){
            out.writeInt(23);
        }
        var4_4 = null;
        try (FSDataInputStream is = fs.open(p);){
            Assert.assertFalse((boolean)BlockIOUtils.isByteBufferReadable((FSDataInputStream)is));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testReadFully() throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path p = new Path(TEST_UTIL.getDataTestDirOnTestFS(), "testReadFully");
        String s = "hello world";
        try (FSDataOutputStream out = fs.create(p);){
            out.writeBytes(s);
        }
        SingleByteBuff buf = new SingleByteBuff(ByteBuffer.allocate(11));
        try (FSDataInputStream in = fs.open(p);){
            BlockIOUtils.readFully((ByteBuff)buf, (FSDataInputStream)in, (int)11);
        }
        buf.rewind();
        byte[] heapBuf = new byte[s.length()];
        buf.get(heapBuf, 0, heapBuf.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)s), (byte[])heapBuf);
    }

    @Test
    public void testReadWithExtra() throws IOException {
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        Path p = new Path(TEST_UTIL.getDataTestDirOnTestFS(), "testReadWithExtra");
        String s = "hello world";
        try (FSDataOutputStream out = fs.create(p);){
            out.writeBytes(s);
        }
        SingleByteBuff buf = new SingleByteBuff(ByteBuffer.allocate(8));
        try (FSDataInputStream in = fs.open(p);){
            Assert.assertTrue((boolean)BlockIOUtils.readWithExtra((ByteBuff)buf, (FSDataInputStream)in, (int)6, (int)2));
        }
        buf.rewind();
        byte[] heapBuf = new byte[buf.capacity()];
        buf.get(heapBuf, 0, heapBuf.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"hello wo"), (byte[])heapBuf);
        buf = new MultiByteBuff(new ByteBuffer[]{ByteBuffer.allocate(4), ByteBuffer.allocate(4), ByteBuffer.allocate(4)});
        try (FSDataInputStream in = fs.open(p);){
            Assert.assertTrue((boolean)BlockIOUtils.readWithExtra((ByteBuff)buf, (FSDataInputStream)in, (int)8, (int)3));
        }
        buf.rewind();
        heapBuf = new byte[11];
        buf.get(heapBuf, 0, heapBuf.length);
        Assert.assertArrayEquals((byte[])Bytes.toBytes((String)"hello world"), (byte[])heapBuf);
        buf.position(0).limit(12);
        in = fs.open(p);
        var7_12 = null;
        try {
            try {
                BlockIOUtils.readWithExtra((ByteBuff)buf, (FSDataInputStream)in, (int)12, (int)0);
                Assert.fail((String)"Should only read 11 bytes");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var7_12 = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (var7_12 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        var7_12.addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    @Test
    public void testPositionalReadNoExtra() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)totalLen);
        boolean ret = BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
        Assert.assertFalse((String)"Expect false return when no extra bytes requested", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadShortReadOfNecessaryBytes() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)5);
        Mockito.when((Object)in.read(5L, buf, 5, 5)).thenReturn((Object)5);
        boolean ret = BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
        Assert.assertFalse((String)"Expect false return when no extra bytes requested", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(5L, buf, 5, 5);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadExtraSucceeded() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)totalLen);
        boolean ret = BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
        Assert.assertTrue((String)"Expect true return when reading extra bytes succeeds", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadExtraFailed() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)necessaryLen);
        boolean ret = BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
        Assert.assertFalse((String)"Expect false return when reading extra bytes fails", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadShortReadCompletesNecessaryAndExtraBytes() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 5;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)5);
        Mockito.when((Object)in.read(5L, buf, 5, 10)).thenReturn((Object)10);
        boolean ret = BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
        Assert.assertTrue((String)"Expect true return when reading extra bytes succeeds", (boolean)ret);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(position, buf, bufOffset, totalLen);
        ((FSDataInputStream)Mockito.verify((Object)in)).read(5L, buf, 5, 10);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{in});
    }

    @Test
    public void testPositionalReadPrematureEOF() throws IOException {
        long position = 0L;
        int bufOffset = 0;
        int necessaryLen = 10;
        int extraLen = 0;
        int totalLen = necessaryLen + extraLen;
        byte[] buf = new byte[totalLen];
        SingleByteBuff bb = new SingleByteBuff(ByteBuffer.wrap(buf, 0, totalLen));
        FSDataInputStream in = (FSDataInputStream)Mockito.mock(FSDataInputStream.class);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)9);
        Mockito.when((Object)in.read(position, buf, bufOffset, totalLen)).thenReturn((Object)-1);
        this.exception.expect(IOException.class);
        this.exception.expectMessage("EOF");
        BlockIOUtils.preadWithExtra((ByteBuff)bb, (FSDataInputStream)in, (long)position, (int)necessaryLen, (int)extraLen);
    }
}

