/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableMultiplexer;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRegionLocationCaching {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionLocationCaching.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static int SLAVES = 1;
    private static int PER_REGIONSERVER_QUEUE_SIZE = 100000;
    private static TableName TABLE_NAME = TableName.valueOf((String)"TestRegionLocationCaching");
    private static byte[] FAMILY = Bytes.toBytes((String)"testFamily");
    private static byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(SLAVES);
        TEST_UTIL.createTable(TABLE_NAME, (byte[][])new byte[][]{FAMILY});
        TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCachingForHTableMultiplexerSinglePut() throws Exception {
        HTableMultiplexer multiplexer = new HTableMultiplexer(TEST_UTIL.getConfiguration(), PER_REGIONSERVER_QUEUE_SIZE);
        byte[] row = Bytes.toBytes((String)"htable_multiplexer_single_put");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row);
        put.addColumn(FAMILY, QUALIFIER, value);
        Assert.assertTrue((String)"Put request not accepted by multiplexer queue", (boolean)multiplexer.put(TABLE_NAME, put));
        this.checkRegionLocationIsCached(TABLE_NAME, (Connection)multiplexer.getConnection());
        TestRegionLocationCaching.checkExistence(TABLE_NAME, row, FAMILY, QUALIFIER);
        multiplexer.close();
    }

    @Test
    public void testCachingForHTableMultiplexerMultiPut() throws Exception {
        HTableMultiplexer multiplexer = new HTableMultiplexer(TEST_UTIL.getConfiguration(), PER_REGIONSERVER_QUEUE_SIZE);
        ArrayList<Put> multiput = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((String)("htable_multiplexer_multi_put" + i)));
            byte[] value = Bytes.toBytes((String)("value_" + i));
            put.addColumn(FAMILY, QUALIFIER, value);
            multiput.add(put);
        }
        List failedPuts = multiplexer.put(TABLE_NAME, multiput);
        Assert.assertNull((String)"All put requests were not accepted by multiplexer queue", (Object)failedPuts);
        this.checkRegionLocationIsCached(TABLE_NAME, (Connection)multiplexer.getConnection());
        for (int i = 0; i < 10; ++i) {
            TestRegionLocationCaching.checkExistence(TABLE_NAME, Bytes.toBytes((String)("htable_multiplexer_multi_put" + i)), FAMILY, QUALIFIER);
        }
        multiplexer.close();
    }

    @Test
    public void testCachingForHTableSinglePut() throws Exception {
        byte[] row = Bytes.toBytes((String)"htable_single_put");
        byte[] value = Bytes.toBytes((String)"value");
        Put put = new Put(row);
        put.addColumn(FAMILY, QUALIFIER, value);
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            table.put(put);
        }
        this.checkRegionLocationIsCached(TABLE_NAME, TEST_UTIL.getConnection());
        TestRegionLocationCaching.checkExistence(TABLE_NAME, row, FAMILY, QUALIFIER);
    }

    @Test
    public void testCachingForHTableMultiPut() throws Exception {
        ArrayList<Put> multiput = new ArrayList<Put>();
        for (int i = 0; i < 10; ++i) {
            Put put = new Put(Bytes.toBytes((String)("htable_multi_put" + i)));
            byte[] value = Bytes.toBytes((String)("value_" + i));
            put.addColumn(FAMILY, QUALIFIER, value);
            multiput.add(put);
        }
        try (Table table = TEST_UTIL.getConnection().getTable(TABLE_NAME);){
            table.put(multiput);
        }
        this.checkRegionLocationIsCached(TABLE_NAME, TEST_UTIL.getConnection());
        for (int i = 0; i < 10; ++i) {
            TestRegionLocationCaching.checkExistence(TABLE_NAME, Bytes.toBytes((String)("htable_multi_put" + i)), FAMILY, QUALIFIER);
        }
    }

    private void checkRegionLocationIsCached(TableName tableName, Connection conn) throws InterruptedException, IOException {
        for (int count = 0; count < 50; ++count) {
            int number = ((ConnectionImplementation)conn).getNumberOfCachedRegionLocations(tableName);
            Assert.assertNotEquals((String)"Expected non-zero number of cached region locations", (long)0L, (long)number);
            Thread.sleep(100L);
        }
    }

    private static void checkExistence(TableName tableName, byte[] row, byte[] family, byte[] qualifier) throws Exception {
        Get get = new Get(row);
        get.addColumn(family, qualifier);
        int nbTry = 0;
        try (Table table = TEST_UTIL.getConnection().getTable(tableName);){
            Result r;
            do {
                Assert.assertTrue((String)("Failed to get row after " + nbTry + " tries"), (nbTry < 50 ? 1 : 0) != 0);
                ++nbTry;
                Thread.sleep(100L);
            } while ((r = table.get(get)) == null || r.getValue(family, qualifier) == null);
        }
    }
}

