/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientNormalTestBase;
import org.apache.hadoop.hbase.client.CloneSnapshotFromClientTestBase;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class, ClientTests.class})
public class TestMobCloneSnapshotFromClientNormal
extends CloneSnapshotFromClientNormalTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobCloneSnapshotFromClientNormal.class);

    protected static void setupConfiguration() {
        CloneSnapshotFromClientTestBase.setupConfiguration();
        TEST_UTIL.getConfiguration().setLong("hbase.master.hfilecleaner.ttl", 0L);
        TEST_UTIL.getConfiguration().setInt("hbase.mob.file.cache.size", 0);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestMobCloneSnapshotFromClientNormal.setupConfiguration();
        TEST_UTIL.startMiniCluster(3);
    }

    @Override
    protected void createTable() throws IOException, InterruptedException {
        MobSnapshotTestingUtils.createMobTable(TEST_UTIL, this.tableName, SnapshotTestingUtils.getSplitKeys(), this.getNumReplicas(), (byte[][])new byte[][]{this.FAMILY});
    }

    @Override
    protected int numRowsToLoad() {
        return 20;
    }

    @Override
    protected int countRows(Table table) throws IOException {
        return MobSnapshotTestingUtils.countMobRows(table, new byte[0][]);
    }

    @Override
    protected void verifyRowCount(HBaseTestingUtility util, TableName tableName, long expectedRows) throws IOException {
        MobSnapshotTestingUtils.verifyMobRowCount(util, tableName, expectedRows);
    }
}

