/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.BlockingRpcChannel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.FromClientSideBase;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MasterRegistry;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.ZKConnectionRegistry;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
@RunWith(value=Parameterized.class)
public class TestFromClientSide5
extends FromClientSideBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestFromClientSide5.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFromClientSide5.class);
    @Rule
    public TableNameTestRule name = new TableNameTestRule();

    TestFromClientSide5() {
    }

    public TestFromClientSide5(Class registry, int numHedgedReqs) throws Exception {
        TestFromClientSide5.initialize(registry, numHedgedReqs, MultiRowMutationEndpoint.class);
    }

    @Parameterized.Parameters
    public static Collection parameters() {
        return Arrays.asList({MasterRegistry.class, 1}, {MasterRegistry.class, 2}, {ZKConnectionRegistry.class, 1});
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TestFromClientSide5.afterClass();
    }

    @Test
    public void testGetClosestRowBefore() throws IOException, InterruptedException {
        TableName tableName = this.name.getTableName();
        byte[] firstRow = Bytes.toBytes((String)"row111");
        byte[] secondRow = Bytes.toBytes((String)"row222");
        byte[] thirdRow = Bytes.toBytes((String)"row333");
        byte[] forthRow = Bytes.toBytes((String)"row444");
        byte[] beforeFirstRow = Bytes.toBytes((String)"row");
        byte[] beforeSecondRow = Bytes.toBytes((String)"row22");
        byte[] beforeThirdRow = Bytes.toBytes((String)"row33");
        byte[] beforeForthRow = Bytes.toBytes((String)"row44");
        try (Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{HConstants.CATALOG_FAMILY, Bytes.toBytes((String)"info2")}, 1, 1024);
             RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegion().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            Put put1 = new Put(firstRow);
            Put put2 = new Put(secondRow);
            Put put3 = new Put(thirdRow);
            Put put4 = new Put(forthRow);
            byte[] one = new byte[]{1};
            byte[] two = new byte[]{2};
            byte[] three = new byte[]{3};
            byte[] four = new byte[]{4};
            put1.addColumn(HConstants.CATALOG_FAMILY, null, one);
            put2.addColumn(HConstants.CATALOG_FAMILY, null, two);
            put3.addColumn(HConstants.CATALOG_FAMILY, null, three);
            put4.addColumn(HConstants.CATALOG_FAMILY, null, four);
            table.put(put1);
            table.put(put2);
            table.put(put3);
            table.put(put4);
            region.flush(true);
            Result result = this.getReverseScanResult(table, beforeFirstRow);
            Assert.assertNull((Object)result);
            result = this.getReverseScanResult(table, firstRow);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])firstRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
            result = this.getReverseScanResult(table, beforeSecondRow);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])firstRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])one));
            result = this.getReverseScanResult(table, secondRow);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])secondRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])two));
            result = this.getReverseScanResult(table, beforeThirdRow);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])secondRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])two));
            result = this.getReverseScanResult(table, thirdRow);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])thirdRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])three));
            result = this.getReverseScanResult(table, beforeForthRow);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])thirdRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])three));
            result = this.getReverseScanResult(table, forthRow);
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])forthRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])four));
            result = this.getReverseScanResult(table, Bytes.add((byte[])forthRow, (byte[])one));
            Assert.assertTrue((boolean)result.containsColumn(HConstants.CATALOG_FAMILY, null));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])forthRow));
            Assert.assertTrue((boolean)Bytes.equals((byte[])result.getValue(HConstants.CATALOG_FAMILY, null), (byte[])four));
        }
    }

    private Result getReverseScanResult(Table table, byte[] row) throws IOException {
        Scan scan = new Scan(row);
        scan.setSmall(true);
        scan.setReversed(true);
        scan.setCaching(1);
        scan.addFamily(HConstants.CATALOG_FAMILY);
        try (ResultScanner scanner = table.getScanner(scan);){
            Result result = scanner.next();
            return result;
        }
    }

    @Test
    public void testScanVariableReuse() {
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        scan.addColumn(FAMILY, ROW);
        Assert.assertEquals((long)1L, (long)((NavigableSet)scan.getFamilyMap().get(FAMILY)).size());
        scan = new Scan();
        scan.addFamily(FAMILY);
        Assert.assertNull(scan.getFamilyMap().get(FAMILY));
        Assert.assertTrue((boolean)scan.getFamilyMap().containsKey(FAMILY));
    }

    @Test
    public void testMultiRowMutation() throws Exception {
        LOG.info("Starting testMultiRowMutation");
        TableName tableName = this.name.getTableName();
        byte[] ROW1 = Bytes.toBytes((String)"testRow1");
        try (Table t = TEST_UTIL.createTable(tableName, FAMILY);){
            Put p = new Put(ROW);
            p.addColumn(FAMILY, QUALIFIER, VALUE);
            ClientProtos.MutationProto m1 = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)p);
            p = new Put(ROW1);
            p.addColumn(FAMILY, QUALIFIER, VALUE);
            ClientProtos.MutationProto m2 = ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)p);
            MultiRowMutationProtos.MutateRowsRequest.Builder mrmBuilder = MultiRowMutationProtos.MutateRowsRequest.newBuilder();
            mrmBuilder.addMutationRequest(m1);
            mrmBuilder.addMutationRequest(m2);
            MultiRowMutationProtos.MutateRowsRequest mrm = mrmBuilder.build();
            CoprocessorRpcChannel channel = t.coprocessorService(ROW);
            MultiRowMutationProtos.MultiRowMutationService.BlockingInterface service = MultiRowMutationProtos.MultiRowMutationService.newBlockingStub((BlockingRpcChannel)channel);
            service.mutateRows(null, mrm);
            Get g = new Get(ROW);
            Result r = t.get(g);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIER)));
            g = new Get(ROW1);
            r = t.get(g);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIER)));
        }
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testRowMutations() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testBatchAppendWithReturnResultFalse() throws Exception {
        LOG.info("Starting testBatchAppendWithReturnResultFalse");
        TableName tableName = this.name.getTableName();
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            Append append1 = new Append(Bytes.toBytes((String)"row1"));
            append1.setReturnResults(false);
            append1.addColumn(FAMILY, Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"value1"));
            Append append2 = new Append(Bytes.toBytes((String)"row1"));
            append2.setReturnResults(false);
            append2.addColumn(FAMILY, Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"value2"));
            ArrayList<Append> appends = new ArrayList<Append>();
            appends.add(append1);
            appends.add(append2);
            Object[] results = new Object[2];
            table.batch(appends, results);
            Assert.assertEquals((long)2L, (long)results.length);
            for (Object r : results) {
                Result result = (Result)r;
                Assert.assertTrue((boolean)result.isEmpty());
            }
        }
    }

    @Test
    public void testAppend() throws Exception {
        LOG.info("Starting testAppend");
        TableName tableName = this.name.getTableName();
        try (Table t = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[] v1 = Bytes.toBytes((String)"42");
            byte[] v2 = Bytes.toBytes((String)"23");
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"b"), Bytes.toBytes((String)"a"), Bytes.toBytes((String)"c")};
            Append a = new Append(ROW);
            a.addColumn(FAMILY, QUALIFIERS[0], v1);
            a.addColumn(FAMILY, QUALIFIERS[1], v2);
            a.setReturnResults(false);
            this.assertEmptyResult(t.append(a));
            a = new Append(ROW);
            a.addColumn(FAMILY, QUALIFIERS[0], v2);
            a.addColumn(FAMILY, QUALIFIERS[1], v1);
            a.addColumn(FAMILY, QUALIFIERS[2], v2);
            Result r = t.append(a);
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])Bytes.add((byte[])v1, (byte[])v2), (byte[])r.getValue(FAMILY, QUALIFIERS[0])));
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])Bytes.add((byte[])v2, (byte[])v1), (byte[])r.getValue(FAMILY, QUALIFIERS[1])));
            Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])v2, (byte[])r.getValue(FAMILY, QUALIFIERS[2])));
            Assert.assertEquals((long)r.getColumnLatestCell(FAMILY, QUALIFIERS[0]).getTimestamp(), (long)r.getColumnLatestCell(FAMILY, QUALIFIERS[2]).getTimestamp());
        }
    }

    private List<Result> doAppend(boolean walUsed) throws IOException {
        LOG.info("Starting testAppend, walUsed is " + walUsed);
        TableName TABLENAME = TableName.valueOf((String)(walUsed ? "testAppendWithWAL" : "testAppendWithoutWAL"));
        try (Table t = TEST_UTIL.createTable(TABLENAME, FAMILY);){
            byte[] row1 = Bytes.toBytes((String)"c");
            byte[] row2 = Bytes.toBytes((String)"b");
            byte[] row3 = Bytes.toBytes((String)"a");
            byte[] qual = Bytes.toBytes((String)"qual");
            Put put_0 = new Put(row2);
            put_0.addColumn(FAMILY, qual, Bytes.toBytes((String)"put"));
            Put put_1 = new Put(row3);
            put_1.addColumn(FAMILY, qual, Bytes.toBytes((String)"put"));
            Append append_0 = new Append(row1);
            append_0.addColumn(FAMILY, qual, Bytes.toBytes((String)"i"));
            Append append_1 = new Append(row1);
            append_1.addColumn(FAMILY, qual, Bytes.toBytes((String)"k"));
            Append append_2 = new Append(row1);
            append_2.addColumn(FAMILY, qual, Bytes.toBytes((String)"e"));
            if (!walUsed) {
                append_2.setDurability(Durability.SKIP_WAL);
            }
            Append append_3 = new Append(row1);
            append_3.addColumn(FAMILY, qual, Bytes.toBytes((String)"a"));
            Scan s = new Scan();
            s.setCaching(1);
            t.append(append_0);
            t.put(put_0);
            t.put(put_1);
            LinkedList<Result> results = new LinkedList<Result>();
            try (ResultScanner scanner = t.getScanner(s);){
                t.append(append_1);
                t.append(append_2);
                t.append(append_3);
                for (Result r : scanner) {
                    results.add(r);
                }
            }
            TEST_UTIL.deleteTable(TABLENAME);
            LinkedList<Result> linkedList = results;
            return linkedList;
        }
    }

    @Test
    public void testAppendWithoutWAL() throws Exception {
        List<Result> resultsWithWal = this.doAppend(true);
        List<Result> resultsWithoutWal = this.doAppend(false);
        Assert.assertEquals((long)resultsWithWal.size(), (long)resultsWithoutWal.size());
        for (int i = 0; i != resultsWithWal.size(); ++i) {
            Result resultWithWal = resultsWithWal.get(i);
            Result resultWithoutWal = resultsWithoutWal.get(i);
            Assert.assertEquals((long)resultWithWal.rawCells().length, (long)resultWithoutWal.rawCells().length);
            for (int j = 0; j != resultWithWal.rawCells().length; ++j) {
                Cell cellWithWal = resultWithWal.rawCells()[j];
                Cell cellWithoutWal = resultWithoutWal.rawCells()[j];
                Assert.assertArrayEquals((byte[])CellUtil.cloneRow((Cell)cellWithWal), (byte[])CellUtil.cloneRow((Cell)cellWithoutWal));
                Assert.assertArrayEquals((byte[])CellUtil.cloneFamily((Cell)cellWithWal), (byte[])CellUtil.cloneFamily((Cell)cellWithoutWal));
                Assert.assertArrayEquals((byte[])CellUtil.cloneQualifier((Cell)cellWithWal), (byte[])CellUtil.cloneQualifier((Cell)cellWithoutWal));
                Assert.assertArrayEquals((byte[])CellUtil.cloneValue((Cell)cellWithWal), (byte[])CellUtil.cloneValue((Cell)cellWithoutWal));
            }
        }
    }

    @Test
    public void testClientPoolRoundRobin() throws IOException {
        TableName tableName = this.name.getTableName();
        int poolSize = 3;
        int numVersions = poolSize * 2;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.client.ipc.pool.type", "round-robin");
        conf.setInt("hbase.client.ipc.pool.size", poolSize);
        try (Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, Integer.MAX_VALUE);){
            long ts = EnvironmentEdgeManager.currentTime();
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readAllVersions();
            for (int versions = 1; versions <= numVersions; ++versions) {
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, ts + (long)versions, VALUE);
                table.put(put);
                Result result = table.get(get);
                NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
                Assert.assertEquals((String)("The number of versions of '" + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUALIFIER) + " did not match"), (long)versions, (long)navigableMap.size());
                for (Map.Entry entry : navigableMap.entrySet()) {
                    Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="Flakey: HBASE-8989")
    @Test
    public void testClientPoolThreadLocal() throws IOException {
        TableName tableName = this.name.getTableName();
        int poolSize = Integer.MAX_VALUE;
        int numVersions = 3;
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.client.ipc.pool.type", "thread-local");
        conf.setInt("hbase.client.ipc.pool.size", poolSize);
        try (Table table = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 3);){
            long ts = EnvironmentEdgeManager.currentTime();
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readAllVersions();
            for (int versions = 1; versions <= numVersions; ++versions) {
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, ts + (long)versions, VALUE);
                table.put(put);
                Result result = table.get(get);
                NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
                Assert.assertEquals((String)("The number of versions of '" + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUALIFIER) + " did not match"), (long)versions, (long)navigableMap.size());
                for (Map.Entry entry : navigableMap.entrySet()) {
                    Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
                }
            }
            Object waitLock = new Object();
            ExecutorService executorService = Executors.newFixedThreadPool(numVersions);
            AtomicReference<Object> error = new AtomicReference<Object>(null);
            int versions = numVersions;
            while (versions < numVersions * 2) {
                int versionsCopy = versions++;
                executorService.submit(() -> {
                    try {
                        Put put = new Put(ROW);
                        put.addColumn(FAMILY, QUALIFIER, ts + (long)versionsCopy, VALUE);
                        table.put(put);
                        Result result = table.get(get);
                        NavigableMap navigableMap = (NavigableMap)((NavigableMap)result.getMap().get(FAMILY)).get(QUALIFIER);
                        Assert.assertEquals((String)("The number of versions of '" + Bytes.toString((byte[])FAMILY) + ":" + Bytes.toString((byte[])QUALIFIER) + " did not match " + versionsCopy), (long)versionsCopy, (long)navigableMap.size());
                        for (Map.Entry entry : navigableMap.entrySet()) {
                            Assert.assertTrue((String)("The value at time " + entry.getKey() + " did not match what was put"), (boolean)Bytes.equals((byte[])VALUE, (byte[])((byte[])entry.getValue())));
                        }
                        Object object = waitLock;
                        synchronized (object) {
                            waitLock.wait();
                        }
                    }
                    catch (Exception put) {
                    }
                    catch (AssertionError e) {
                        error.set(e);
                        LOG.error(((Throwable)((Object)e)).toString(), (Throwable)((Object)e));
                    }
                    return null;
                });
            }
            Object object = waitLock;
            synchronized (object) {
                waitLock.notifyAll();
            }
            executorService.shutdownNow();
            Assert.assertNull(error.get());
        }
    }

    @Test
    public void testCheckAndPut() throws IOException {
        byte[] anotherrow = Bytes.toBytes((String)"anotherrow");
        byte[] value2 = Bytes.toBytes((String)"abcd");
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Put put1 = new Put(ROW);
            put1.addColumn(FAMILY, QUALIFIER, VALUE);
            boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenPut(put1);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put1);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put1);
            Assert.assertFalse((boolean)ok);
            Put put2 = new Put(ROW);
            put2.addColumn(FAMILY, QUALIFIER, value2);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(VALUE).thenPut(put2);
            Assert.assertTrue((boolean)ok);
            Put put3 = new Put(anotherrow);
            put3.addColumn(FAMILY, QUALIFIER, VALUE);
            try {
                table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(value2).thenPut(put3);
                Assert.fail((String)"trying to check and modify different rows should have failed.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void testCheckAndMutateWithTimeRange() throws IOException {
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            long ts = System.currentTimeMillis() / 2L;
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, ts, VALUE);
            boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenPut(put);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.from((long)(ts + 10000L))).ifEquals(VALUE).thenPut(put);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.between((long)(ts + 10000L), (long)(ts + 20000L))).ifEquals(VALUE).thenPut(put);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.until((long)ts)).ifEquals(VALUE).thenPut(put);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenPut(put);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.from((long)ts)).ifEquals(VALUE).thenPut(put);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.between((long)ts, (long)(ts + 20000L))).ifEquals(VALUE).thenPut(put);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.until((long)(ts + 10000L))).ifEquals(VALUE).thenPut(put);
            Assert.assertTrue((boolean)ok);
            RowMutations rm = new RowMutations(ROW).add((Mutation)put);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenMutate(rm);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenMutate(rm);
            Assert.assertTrue((boolean)ok);
            Delete delete = new Delete(ROW).addColumn(FAMILY, QUALIFIER);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)(ts + 10000L))).ifEquals(VALUE).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).timeRange(TimeRange.at((long)ts)).ifEquals(VALUE).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
        }
    }

    @Test
    public void testCheckAndPutWithCompareOp() throws IOException {
        byte[] value1 = Bytes.toBytes((String)"aaaa");
        byte[] value2 = Bytes.toBytes((String)"bbbb");
        byte[] value3 = Bytes.toBytes((String)"cccc");
        byte[] value4 = Bytes.toBytes((String)"dddd");
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Put put2 = new Put(ROW);
            put2.addColumn(FAMILY, QUALIFIER, value2);
            Put put3 = new Put(ROW);
            put3.addColumn(FAMILY, QUALIFIER, value3);
            boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifNotExists().thenPut(put2);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value1).thenPut(put2);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value1).thenPut(put2);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value1).thenPut(put2);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value1).thenPut(put2);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value1).thenPut(put2);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value1).thenPut(put3);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value4).thenPut(put3);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value4).thenPut(put3);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value4).thenPut(put3);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value4).thenPut(put3);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value4).thenPut(put3);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value4).thenPut(put2);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value2).thenPut(put2);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value2).thenPut(put2);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value2).thenPut(put2);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value2).thenPut(put2);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value2).thenPut(put2);
            Assert.assertTrue((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value2).thenPut(put3);
            Assert.assertTrue((boolean)ok);
        }
    }

    @Test
    public void testCheckAndDelete() throws IOException {
        byte[] value1 = Bytes.toBytes((String)"aaaa");
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, value1);
            table.put(put);
            Delete delete = new Delete(ROW);
            delete.addColumns(FAMILY, QUALIFIER);
            boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifEquals(value1).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
        }
    }

    @Test
    public void testCheckAndDeleteWithCompareOp() throws IOException {
        byte[] value1 = Bytes.toBytes((String)"aaaa");
        byte[] value2 = Bytes.toBytes((String)"bbbb");
        byte[] value3 = Bytes.toBytes((String)"cccc");
        byte[] value4 = Bytes.toBytes((String)"dddd");
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Put put2 = new Put(ROW);
            put2.addColumn(FAMILY, QUALIFIER, value2);
            table.put(put2);
            Put put3 = new Put(ROW);
            put3.addColumn(FAMILY, QUALIFIER, value3);
            Delete delete = new Delete(ROW);
            delete.addColumns(FAMILY, QUALIFIER);
            boolean ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value1).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value1).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value1).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value1).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put2);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value1).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put2);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value1).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put3);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value4).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value4).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value4).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value4).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put3);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value4).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put3);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value4).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put2);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER, value2).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.NOT_EQUAL, value2).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS, value2).thenDelete(delete);
            Assert.assertFalse((boolean)ok);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.GREATER_OR_EQUAL, value2).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put2);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.LESS_OR_EQUAL, value2).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
            table.put(put2);
            ok = table.checkAndMutate(ROW, FAMILY).qualifier(QUALIFIER).ifMatches(CompareOperator.EQUAL, value2).thenDelete(delete);
            Assert.assertTrue((boolean)ok);
        }
    }

    @Test
    public void testScanMetrics() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createMultiRegionTable(tableName, FAMILY);){
            Result[] scanMetrics;
            int numOfRegions;
            try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);){
                numOfRegions = r.getStartKeys().length;
            }
            Put put1 = new Put(Bytes.toBytes((String)"zzz1"));
            put1.addColumn(FAMILY, QUALIFIER, VALUE);
            Put put2 = new Put(Bytes.toBytes((String)"zzz2"));
            put2.addColumn(FAMILY, QUALIFIER, VALUE);
            Put put3 = new Put(Bytes.toBytes((String)"zzz3"));
            put3.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(Arrays.asList(put1, put2, put3));
            Scan scan1 = new Scan();
            int numRecords = 0;
            try (ResultScanner scanner = ht.getScanner(scan1);){
                for (Result[] result : scanner) {
                    ++numRecords;
                }
                LOG.info("test data has " + numRecords + " records.");
                Assert.assertNull((Object)scanner.getScanMetrics());
            }
            Scan scan2 = new Scan();
            scan2.setScanMetricsEnabled(true);
            scan2.setCaching(numRecords + 1);
            ResultScanner scanner = ht.getScanner(scan2);
            Object object = null;
            try {
                for (Result result : scanner.next(numRecords - 1)) {
                }
                scanner.close();
                Assert.assertNotNull((Object)scanner.getScanMetrics());
            }
            catch (Throwable result) {
                object = result;
                throw result;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable result) {
                            ((Throwable)object).addSuppressed(result);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            scan2 = new Scan();
            scan2.setScanMetricsEnabled(true);
            scan2.setCaching(1);
            scanner = ht.getScanner(scan2);
            object = null;
            try {
                for (Result result : scanner.next(numRecords - 1)) {
                }
                ScanMetrics scanMetrics2 = scanner.getScanMetrics();
                Assert.assertEquals((String)"Did not access all the regions in the table", (long)numOfRegions, (long)scanMetrics2.countOfRegions.get());
            }
            catch (Throwable scanMetrics2) {
                object = scanMetrics2;
                throw scanMetrics2;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable scanMetrics2) {
                            ((Throwable)object).addSuppressed(scanMetrics2);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            scan2 = new Scan();
            scan2.setScanMetricsEnabled(true);
            scan2.setCaching(1);
            scanner = ht.getScanner(scan2);
            object = null;
            try {
                int numBytes = 0;
                for (Result result : scanner.next(1)) {
                    for (Cell cell : result.listCells()) {
                        numBytes += PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
                    }
                }
                scanner.close();
                scanMetrics = scanner.getScanMetrics();
                Assert.assertEquals((String)"Did not count the result bytes", (long)numBytes, (long)scanMetrics.countOfBytesInResults.get());
            }
            catch (Throwable numBytes) {
                object = numBytes;
                throw numBytes;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable numBytes) {
                            ((Throwable)object).addSuppressed(numBytes);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            scan2 = new Scan();
            scan2.setScanMetricsEnabled(true);
            scan2.setCaching(1);
            scan2.setSmall(true);
            scanner = ht.getScanner(scan2);
            object = null;
            try {
                int numBytes = 0;
                for (Result result : scanner.next(1)) {
                    for (Cell cell : result.listCells()) {
                        numBytes += PrivateCellUtil.estimatedSerializedSizeOf((Cell)cell);
                    }
                }
                scanner.close();
                scanMetrics = scanner.getScanMetrics();
                Assert.assertEquals((String)"Did not count the result bytes", (long)numBytes, (long)scanMetrics.countOfBytesInResults.get());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            Scan scanWithClose = new Scan();
            scanWithClose.setCaching(numRecords);
            scanWithClose.setScanMetricsEnabled(true);
            try (ResultScanner scannerWithClose = ht.getScanner(scanWithClose);){
                for (Result result : scannerWithClose.next(numRecords + 1)) {
                }
                scannerWithClose.close();
                ScanMetrics scanMetricsWithClose = scannerWithClose.getScanMetrics();
                Assert.assertEquals((String)"Did not access all the regions in the table", (long)numOfRegions, (long)scanMetricsWithClose.countOfRegions.get());
            }
        }
    }

    @Test
    public void testCacheOnWriteEvictOnClose() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[] data = Bytes.toBytes((String)"data");
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);
             RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            String regionName = ((HRegionLocation)locator.getAllRegionLocations().get(0)).getRegion().getEncodedName();
            HRegion region = TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegion(regionName);
            HStore store = (HStore)region.getStores().iterator().next();
            CacheConfig cacheConf = store.getCacheConfig();
            cacheConf.setCacheDataOnWrite(true);
            cacheConf.setEvictOnClose(true);
            BlockCache cache = (BlockCache)cacheConf.getBlockCache().get();
            long startBlockCount = cache.getBlockCount();
            long startBlockHits = cache.getStats().getHitCount();
            long startBlockMiss = cache.getStats().getMissCount();
            for (int i = 0; i < 5; ++i) {
                Thread.sleep(100L);
                if (startBlockCount == cache.getBlockCount() && startBlockHits == cache.getStats().getHitCount() && startBlockMiss == cache.getStats().getMissCount()) continue;
                startBlockCount = cache.getBlockCount();
                startBlockHits = cache.getStats().getHitCount();
                startBlockMiss = cache.getStats().getMissCount();
                i = -1;
            }
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, data);
            table.put(put);
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            Assert.assertEquals((long)startBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)startBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)startBlockMiss, (long)cache.getStats().getMissCount());
            LOG.debug("Flushing cache");
            region.flush(true);
            long expectedBlockCount = startBlockCount + 2L;
            long expectedBlockHits = startBlockHits;
            long expectedBlockMiss = startBlockMiss;
            Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            Assert.assertTrue((boolean)Bytes.equals((byte[])table.get(new Get(ROW)).value(), (byte[])data));
            Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)(++expectedBlockHits), (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            byte[] QUALIFIER2 = Bytes.add((byte[])QUALIFIER, (byte[])QUALIFIER);
            byte[] data2 = Bytes.add((byte[])data, (byte[])data);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER2, data2);
            table.put(put);
            Result r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)(++expectedBlockHits), (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            System.out.println("Flushing cache");
            region.flush(true);
            Assert.assertEquals((long)(expectedBlockCount += 2L), (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            System.out.println("Compacting");
            Assert.assertEquals((long)2L, (long)store.getStorefilesCount());
            store.triggerMajorCompaction();
            region.compact(true);
            store.closeAndArchiveCompactedFiles();
            this.waitForStoreFileCount(store, 1, 10000);
            Assert.assertEquals((long)1L, (long)store.getStorefilesCount());
            expectedBlockCount = 0L;
            Assert.assertEquals((long)expectedBlockCount, (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockMiss, (long)cache.getStats().getMissCount());
            Assert.assertEquals((long)(expectedBlockHits += 2L), (long)cache.getStats().getHitCount());
            r = table.get(new Get(ROW));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])data));
            Assert.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER2), (byte[])data2));
            Assert.assertEquals((long)(++expectedBlockCount), (long)cache.getBlockCount());
            Assert.assertEquals((long)expectedBlockHits, (long)cache.getStats().getHitCount());
            Assert.assertEquals((long)(++expectedBlockMiss), (long)cache.getStats().getMissCount());
        }
    }

    private void waitForStoreFileCount(HStore store, int count, int timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (start + (long)timeout > System.currentTimeMillis() && store.getStorefilesCount() != count) {
            Thread.sleep(100L);
        }
        System.out.println("start=" + start + ", now=" + System.currentTimeMillis() + ", cur=" + store.getStorefilesCount());
        Assert.assertEquals((long)count, (long)store.getStorefilesCount());
    }

    @Test
    public void testNonCachedGetRegionLocation() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[] family1 = Bytes.toBytes((String)"f1");
        byte[] family2 = Bytes.toBytes((String)"f2");
        try (Table ignored = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{family1, family2}, 10);
             Admin admin = TEST_UTIL.getAdmin();
             RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            List allRegionLocations = locator.getAllRegionLocations();
            Assert.assertEquals((long)1L, (long)allRegionLocations.size());
            RegionInfo regionInfo = ((HRegionLocation)allRegionLocations.get(0)).getRegion();
            ServerName addrBefore = ((HRegionLocation)allRegionLocations.get(0)).getServerName();
            HRegionLocation addrCache = locator.getRegionLocation(regionInfo.getStartKey(), false);
            HRegionLocation addrNoCache = locator.getRegionLocation(regionInfo.getStartKey(), true);
            Assert.assertEquals((long)addrBefore.getPort(), (long)addrCache.getPort());
            Assert.assertEquals((long)addrBefore.getPort(), (long)addrNoCache.getPort());
            if (TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size() <= 1) {
                TEST_UTIL.getMiniHBaseCluster().startRegionServer();
                Waiter.waitFor((Configuration)TEST_UTIL.getConfiguration(), (long)30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                    public boolean evaluate() throws Exception {
                        return FromClientSideBase.TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size() > 1;
                    }
                });
            }
            ServerName addrAfter = null;
            for (int i = 0; i < TEST_UTIL.getMiniHBaseCluster().getLiveRegionServerThreads().size(); ++i) {
                HRegionServer regionServer = TEST_UTIL.getHBaseCluster().getRegionServer(i);
                ServerName addr = regionServer.getServerName();
                if (addr.getPort() == addrBefore.getPort()) continue;
                admin.move(regionInfo.getEncodedNameAsBytes(), addr);
                Thread.sleep(5000L);
                addrAfter = addr;
                break;
            }
            addrCache = locator.getRegionLocation(regionInfo.getStartKey(), false);
            addrNoCache = locator.getRegionLocation(regionInfo.getStartKey(), true);
            Assert.assertNotNull(addrAfter);
            Assert.assertTrue((addrAfter.getPort() != addrCache.getPort() ? 1 : 0) != 0);
            Assert.assertEquals((long)addrAfter.getPort(), (long)addrNoCache.getPort());
        }
    }

    @Test
    public void testGetRegionsInRange() throws Exception {
        int numOfRegions;
        byte[] startKey = Bytes.toBytes((String)"ddc");
        byte[] endKey = Bytes.toBytes((String)"mmm");
        TableName tableName = this.name.getTableName();
        TEST_UTIL.createMultiRegionTable(tableName, new byte[][]{FAMILY}, 10);
        try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            numOfRegions = r.getStartKeys().length;
        }
        Assert.assertEquals((long)26L, (long)numOfRegions);
        List<HRegionLocation> regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)10L, (long)regionsList.size());
        startKey = Bytes.toBytes((String)"fff");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)7L, (long)regionsList.size());
        endKey = Bytes.toBytes((String)"nnn");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)8L, (long)regionsList.size());
        regionsList = this.getRegionsInRange(tableName, HConstants.EMPTY_START_ROW, endKey);
        Assert.assertEquals((long)13L, (long)regionsList.size());
        regionsList = this.getRegionsInRange(tableName, startKey, HConstants.EMPTY_END_ROW);
        Assert.assertEquals((long)21L, (long)regionsList.size());
        regionsList = this.getRegionsInRange(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
        Assert.assertEquals((long)26L, (long)regionsList.size());
        endKey = Bytes.toBytes((String)"zzz1");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)21L, (long)regionsList.size());
        startKey = Bytes.toBytes((String)"aac");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)26L, (long)regionsList.size());
        startKey = Bytes.toBytes((String)"ccc");
        endKey = Bytes.toBytes((String)"ccc");
        regionsList = this.getRegionsInRange(tableName, startKey, endKey);
        Assert.assertEquals((long)1L, (long)regionsList.size());
    }

    private List<HRegionLocation> getRegionsInRange(TableName tableName, byte[] startKey, byte[] endKey) throws IOException {
        ArrayList<HRegionLocation> regionsInRange = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        try (RegionLocator r = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            HRegionLocation regionLocation;
            do {
                regionLocation = r.getRegionLocation(currentKey);
                regionsInRange.add(regionLocation);
            } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegion().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
            ArrayList<HRegionLocation> arrayList = regionsInRange;
            return arrayList;
        }
    }

    @Test
    public void testJira6912() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table foo = TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{FAMILY}, 10);){
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = 0; i != 100; ++i) {
                Put put = new Put(Bytes.toBytes((int)i));
                put.addColumn(FAMILY, FAMILY, Bytes.toBytes((int)i));
                puts.add(put);
            }
            foo.put(puts);
            TEST_UTIL.flush();
            Scan scan = new Scan();
            scan.setStartRow(Bytes.toBytes((int)1));
            scan.setStopRow(Bytes.toBytes((int)3));
            scan.addColumn(FAMILY, FAMILY);
            scan.setFilter((Filter)new RowFilter(CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((int)1))));
            try (ResultScanner scanner = foo.getScanner(scan);){
                Result[] bar = scanner.next(100);
                Assert.assertEquals((long)1L, (long)bar.length);
            }
        }
    }

    @Test
    public void testScan_NullQualifier() throws IOException {
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            put = new Put(ROW);
            put.addColumn(FAMILY, null, VALUE);
            table.put(put);
            LOG.info("Row put");
            Scan scan = new Scan();
            scan.addColumn(FAMILY, null);
            ResultScanner scanner = table.getScanner(scan);
            Result[] bar = scanner.next(100);
            Assert.assertEquals((long)1L, (long)bar.length);
            Assert.assertEquals((long)1L, (long)bar[0].size());
            scan = new Scan();
            scan.addFamily(FAMILY);
            scanner = table.getScanner(scan);
            bar = scanner.next(100);
            Assert.assertEquals((long)1L, (long)bar.length);
            Assert.assertEquals((long)2L, (long)bar[0].size());
        }
    }

    @Test
    public void testNegativeTimestamp() throws IOException {
        try (Table table = TEST_UTIL.createTable(this.name.getTableName(), FAMILY);){
            Delete delete;
            Put put;
            try {
                put = new Put(ROW, -1L);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                table.put(put);
                Assert.fail((String)"Negative timestamps should not have been allowed");
            }
            catch (IllegalArgumentException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
            }
            try {
                put = new Put(ROW);
                long ts = -1L;
                put.addColumn(FAMILY, QUALIFIER, ts, VALUE);
                table.put(put);
                Assert.fail((String)"Negative timestamps should not have been allowed");
            }
            catch (IllegalArgumentException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
            }
            try {
                delete = new Delete(ROW, -1L);
                table.delete(delete);
                Assert.fail((String)"Negative timestamps should not have been allowed");
            }
            catch (IllegalArgumentException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
            }
            try {
                delete = new Delete(ROW);
                delete.addFamily(FAMILY, -1L);
                table.delete(delete);
                Assert.fail((String)"Negative timestamps should not have been allowed");
            }
            catch (IllegalArgumentException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
            }
            try {
                Scan scan = new Scan();
                scan.setTimeRange(-1L, 1L);
                table.getScanner(scan);
                Assert.fail((String)"Negative timestamps should not have been allowed");
            }
            catch (IllegalArgumentException ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("negative"));
            }
            try {
                new KeyValue(Bytes.toBytes((int)42), Bytes.toBytes((int)42), Bytes.toBytes((int)42), -1L, Bytes.toBytes((int)42));
            }
            catch (IllegalArgumentException ex) {
                Assert.fail((String)"KeyValue SHOULD allow negative timestamps");
            }
        }
    }

    @Test
    public void testRawScanRespectsVersions() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            int count;
            byte[] row = Bytes.toBytes((String)"row");
            Put p = new Put(row);
            p.addColumn(FAMILY, QUALIFIER, 10L, VALUE);
            table.put(p);
            p = new Put(row);
            p.addColumn(FAMILY, QUALIFIER, 11L, ArrayUtils.add((byte[])VALUE, (byte)2));
            table.put(p);
            p = new Put(row);
            p.addColumn(FAMILY, QUALIFIER, 12L, ArrayUtils.add((byte[])VALUE, (byte)3));
            table.put(p);
            p = new Put(row);
            p.addColumn(FAMILY, QUALIFIER, 13L, ArrayUtils.add((byte[])VALUE, (byte)4));
            table.put(p);
            int versions = 4;
            Scan s = new Scan(row);
            s.setMaxVersions();
            s.setRaw(true);
            try (ResultScanner scanner = table.getScanner(s);){
                count = 0;
                for (Result r : scanner) {
                    Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
                    ++count;
                }
                Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
            }
            versions = 2;
            s.setMaxVersions(versions);
            scanner = table.getScanner(s);
            var9_11 = null;
            try {
                count = 0;
                for (Result r : scanner) {
                    Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
                    ++count;
                }
                Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count);
            }
            catch (Throwable count2) {
                var9_11 = count2;
                throw count2;
            }
            finally {
                if (scanner != null) {
                    if (var9_11 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable count2) {
                            var9_11.addSuppressed(count2);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            versions = 3;
            s.setMaxVersions(versions);
            scanner = table.getScanner(s);
            var9_11 = null;
            try {
                int count3 = 0;
                for (Result r : scanner) {
                    Assert.assertEquals((String)"Found an unexpected number of results for the row!", (long)versions, (long)r.listCells().size());
                    ++count3;
                }
                Assert.assertEquals((String)"Found more than a single row when raw scanning the table with a single row!", (long)1L, (long)count3);
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var9_11 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testEmptyFilterList() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            Put put = new Put(Bytes.toBytes((String)"row"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            LinkedList<Result> scanResults = new LinkedList<Result>();
            Scan scan = new Scan();
            scan.setFilter((Filter)new FilterList(new Filter[0]));
            try (ResultScanner scanner = table.getScanner(scan);){
                for (Result r : scanner) {
                    scanResults.add(r);
                }
            }
            Assert.assertEquals((long)1L, (long)scanResults.size());
            Get g = new Get(Bytes.toBytes((String)"row"));
            g.setFilter((Filter)new FilterList(new Filter[0]));
            Result getResult = table.get(g);
            Result scanResult = (Result)scanResults.get(0);
            Assert.assertEquals((long)scanResult.rawCells().length, (long)getResult.rawCells().length);
            for (int i = 0; i != scanResult.rawCells().length; ++i) {
                Cell scanCell = scanResult.rawCells()[i];
                Cell getCell = getResult.rawCells()[i];
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneRow((Cell)scanCell), (byte[])CellUtil.cloneRow((Cell)getCell)));
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneFamily((Cell)scanCell), (byte[])CellUtil.cloneFamily((Cell)getCell)));
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneQualifier((Cell)scanCell), (byte[])CellUtil.cloneQualifier((Cell)getCell)));
                Assert.assertEquals((long)0L, (long)Bytes.compareTo((byte[])CellUtil.cloneValue((Cell)scanCell), (byte[])CellUtil.cloneValue((Cell)getCell)));
            }
        }
    }

    @Test
    public void testSmallScan() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            Throwable put;
            int insertNum = 10;
            for (int i = 0; i < 10; ++i) {
                put = new Put(Bytes.toBytes((String)("row" + String.format("%03d", i))));
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                table.put((Put)put);
            }
            put = null;
            try (ResultScanner scanner = table.getScanner(new Scan());){
                int count = 0;
                for (Result r : scanner) {
                    Assert.assertFalse((boolean)r.isEmpty());
                    ++count;
                }
                Assert.assertEquals((long)insertNum, (long)count);
            }
            catch (Throwable throwable) {
                put = throwable;
                throw throwable;
            }
            Scan scan = new Scan(HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW);
            scan.setSmall(true);
            scan.setCaching(2);
            try (ResultScanner scanner = table.getScanner(scan);){
                int count = 0;
                for (Result r : scanner) {
                    Assert.assertFalse((boolean)r.isEmpty());
                    ++count;
                }
                Assert.assertEquals((long)insertNum, (long)count);
            }
        }
    }

    @Test
    public void testSuperSimpleWithReverseScan() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            Put put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000000"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000002"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000004"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000006"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b11111-0000000000000000008"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000001"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000003"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000005"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000007"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            put = new Put(Bytes.toBytes((String)"0-b22222-0000000000000000009"));
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            Scan scan = new Scan(Bytes.toBytes((String)"0-b11111-9223372036854775807"), Bytes.toBytes((String)"0-b11111-0000000000000000000"));
            scan.setReversed(true);
            try (ResultScanner scanner = ht.getScanner(scan);){
                Result result = scanner.next();
                Assert.assertTrue((boolean)Bytes.equals((byte[])result.getRow(), (byte[])Bytes.toBytes((String)"0-b11111-0000000000000000008")));
            }
        }
    }

    @Test
    public void testFiltersWithReverseScan() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[][] ROWS = this.makeN(ROW, 10);
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
            for (int i = 0; i < 10; ++i) {
                Put put = new Put(ROWS[i]);
                put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
                ht.put(put);
            }
            Scan scan = new Scan();
            scan.setReversed(true);
            scan.addFamily(FAMILY);
            QualifierFilter filter = new QualifierFilter(CompareOperator.EQUAL, (ByteArrayComparable)new RegexStringComparator("col[1-5]"));
            scan.setFilter((Filter)filter);
            try (ResultScanner scanner = ht.getScanner(scan);){
                int expectedIndex = 5;
                for (Result result : scanner) {
                    Assert.assertEquals((long)1L, (long)result.size());
                    Cell c = result.rawCells()[0];
                    Assert.assertTrue((boolean)Bytes.equals((byte[])c.getRowArray(), (int)c.getRowOffset(), (int)c.getRowLength(), (byte[])ROWS[expectedIndex], (int)0, (int)ROWS[expectedIndex].length));
                    Assert.assertTrue((boolean)Bytes.equals((byte[])c.getQualifierArray(), (int)c.getQualifierOffset(), (int)c.getQualifierLength(), (byte[])QUALIFIERS[expectedIndex], (int)0, (int)QUALIFIERS[expectedIndex].length));
                    --expectedIndex;
                }
                Assert.assertEquals((long)0L, (long)expectedIndex);
            }
        }
    }

    @Test
    public void testKeyOnlyFilterWithReverseScan() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[][] ROWS = this.makeN(ROW, 10);
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"col0-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col1-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col2-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col3-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col4-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col5-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col6-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col7-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col8-<d2v1>-<d3v2>"), Bytes.toBytes((String)"col9-<d2v1>-<d3v2>")};
            for (int i = 0; i < 10; ++i) {
                Put put = new Put(ROWS[i]);
                put.addColumn(FAMILY, QUALIFIERS[i], VALUE);
                ht.put(put);
            }
            Scan scan = new Scan();
            scan.setReversed(true);
            scan.addFamily(FAMILY);
            KeyOnlyFilter filter = new KeyOnlyFilter(true);
            scan.setFilter((Filter)filter);
            try (ResultScanner ignored = ht.getScanner(scan);){
                int count = 0;
                for (Result result : ht.getScanner(scan)) {
                    Assert.assertEquals((long)1L, (long)result.size());
                    Assert.assertEquals((long)4L, (long)result.rawCells()[0].getValueLength());
                    Assert.assertEquals((long)VALUE.length, (long)Bytes.toInt((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0])));
                    ++count;
                }
                Assert.assertEquals((long)10L, (long)count);
            }
        }
    }

    @Test
    public void testSimpleMissingWithReverseScan() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[][] ROWS = this.makeN(ROW, 4);
            Scan scan = new Scan();
            scan.setReversed(true);
            Result result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan(ROWS[0]);
            scan.setReversed(true);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan(ROWS[0], ROWS[1]);
            scan.setReversed(true);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan();
            scan.setReversed(true);
            scan.addFamily(FAMILY);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            scan = new Scan();
            scan.setReversed(true);
            scan.addColumn(FAMILY, QUALIFIER);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
            Put put = new Put(ROWS[2]);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            ht.put(put);
            scan = new Scan();
            scan.setReversed(true);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            scan = new Scan(ROWS[3], ROWS[0]);
            scan.setReversed(true);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            scan = new Scan(ROWS[2], ROWS[1]);
            scan.setReversed(true);
            result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROWS[2], FAMILY, QUALIFIER, VALUE);
            scan = new Scan(ROWS[1]);
            scan.setReversed(true);
            result = this.getSingleScanResult(ht, scan);
            this.assertNullResult(result);
        }
    }

    @Test
    public void testNullWithReverseScan() throws Exception {
        Delete delete;
        Put put;
        TableName tableName = this.name.getTableName();
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY);){
            put = new Put(ROW);
            put.addColumn(FAMILY, null, VALUE);
            ht.put(put);
            this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
            delete = new Delete(ROW);
            delete.addColumns(FAMILY, null);
            ht.delete(delete);
        }
        ht = TEST_UTIL.createTable(TableName.valueOf((String)(this.name.getTableName().toString() + "2")), FAMILY);
        var3_3 = null;
        try {
            put = new Put(ROW);
            put.addColumn(FAMILY, HConstants.EMPTY_BYTE_ARRAY, VALUE);
            ht.put(put);
            this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
            TEST_UTIL.flush();
            this.scanTestNull(ht, ROW, FAMILY, VALUE, true);
            delete = new Delete(ROW);
            delete.addColumns(FAMILY, HConstants.EMPTY_BYTE_ARRAY);
            ht.delete(delete);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, null);
            ht.put(put);
            Scan scan = new Scan();
            scan.setReversed(true);
            scan.addColumn(FAMILY, QUALIFIER);
            Result result = this.getSingleScanResult(ht, scan);
            this.assertSingleResult(result, ROW, FAMILY, QUALIFIER, null);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (ht != null) {
                if (var3_3 != null) {
                    try {
                        ht.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    ht.close();
                }
            }
        }
    }

    @Test
    public void testDeletesWithReverseScan() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] ROWS = this.makeNAscii(ROW, 6);
        byte[][] FAMILIES = this.makeNAscii(FAMILY, 3);
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILIES, 3);){
            Put put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
            ht.put(put);
            Delete delete = new Delete(ROW);
            delete.addFamily(FAMILIES[0], ts[0]);
            ht.delete(delete);
            Scan scan = new Scan(ROW);
            scan.setReversed(true);
            scan.addFamily(FAMILIES[0]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            Result result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
            put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
            put.addColumn(FAMILIES[0], null, ts[4], VALUES[4]);
            put.addColumn(FAMILIES[0], null, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[0], null, ts[3], VALUES[3]);
            ht.put(put);
            delete = new Delete(ROW);
            delete.addColumn(FAMILIES[0], QUALIFIER);
            ht.delete(delete);
            scan = new Scan(ROW);
            scan.setReversed(true);
            scan.addColumn(FAMILIES[0], QUALIFIER);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            delete = new Delete(ROW);
            delete.addColumn(FAMILIES[0], null);
            ht.delete(delete);
            delete = new Delete(ROW);
            delete.addColumns(FAMILIES[0], null);
            ht.delete(delete);
            put = new Put(ROW);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
            ht.put(put);
            scan = new Scan(ROW);
            scan.setReversed(true);
            scan.addFamily(FAMILIES[0]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            this.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            put = new Put(ROWS[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            put = new Put(ROWS[1]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            put = new Put(ROWS[2]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.addColumn(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.addColumn(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            delete = new Delete(ROWS[0]);
            delete.addFamily(FAMILIES[2]);
            ht.delete(delete);
            delete = new Delete(ROWS[1]);
            delete.addColumns(FAMILIES[1], QUALIFIER);
            ht.delete(delete);
            delete = new Delete(ROWS[2]);
            delete.addColumn(FAMILIES[1], QUALIFIER);
            delete.addColumn(FAMILIES[1], QUALIFIER);
            delete.addColumn(FAMILIES[2], QUALIFIER);
            ht.delete(delete);
            scan = new Scan(ROWS[0]);
            scan.setReversed(true);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            this.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
            scan = new Scan(ROWS[1]);
            scan.setReversed(true);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            scan = new Scan(ROWS[2]);
            scan.setReversed(true);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = this.getSingleScanResult(ht, scan);
            Assert.assertEquals((long)1L, (long)result.size());
            this.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
            delete = new Delete(ROWS[3]);
            delete.addFamily(FAMILIES[1]);
            ht.delete(delete);
            put = new Put(ROWS[3]);
            put.addColumn(FAMILIES[2], QUALIFIER, VALUES[0]);
            ht.put(put);
            put = new Put(ROWS[4]);
            put.addColumn(FAMILIES[1], QUALIFIER, VALUES[1]);
            put.addColumn(FAMILIES[2], QUALIFIER, VALUES[2]);
            ht.put(put);
            scan = new Scan(ROWS[4]);
            scan.setReversed(true);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            ResultScanner scanner = ht.getScanner(scan);
            result = scanner.next();
            Assert.assertEquals((String)("Expected 2 keys but received " + result.size()), (long)2L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[4]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[1]), (byte[])ROWS[4]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[1]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[1]), (byte[])VALUES[2]));
            result = scanner.next();
            Assert.assertEquals((String)("Expected 1 key but received " + result.size()), (long)1L, (long)result.size());
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneRow((Cell)result.rawCells()[0]), (byte[])ROWS[3]));
            Assert.assertTrue((boolean)Bytes.equals((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]), (byte[])VALUES[0]));
            scanner.close();
        }
    }

    @Test
    public void testReversedScanUnderMultiRegions() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[] maxByteArray = ConnectionUtils.MAX_BYTE_ARRAY;
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"005"), Bytes.add((byte[])Bytes.toBytes((String)"005"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)16)), Bytes.toBytes((String)"006"), Bytes.add((byte[])Bytes.toBytes((String)"006"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)8)), Bytes.toBytes((String)"007"), Bytes.add((byte[])Bytes.toBytes((String)"007"), (byte[])Bytes.multiple((byte[])maxByteArray, (int)4)), Bytes.toBytes((String)"008"), Bytes.multiple((byte[])maxByteArray, (int)2)};
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY, (byte[][])splitRows);){
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            RegionLocator l = TEST_UTIL.getConnection().getRegionLocator(tableName);
            Object object = null;
            try {
                Assert.assertEquals((long)(splitRows.length + 1), (long)l.getAllRegionLocations().size());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (l != null) {
                    if (object != null) {
                        try {
                            l.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        l.close();
                    }
                }
            }
            int insertNum = splitRows.length;
            for (Object splitRow : (Object)splitRows) {
                Put put = new Put((byte[])splitRow);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                table.put(put);
            }
            try (ResultScanner scanner = table.getScanner(new Scan());){
                int count = 0;
                for (Result r : scanner) {
                    Assert.assertFalse((boolean)r.isEmpty());
                    ++count;
                }
                Assert.assertEquals((long)insertNum, (long)count);
            }
            Scan scan = new Scan();
            scan.setReversed(true);
            try (ResultScanner scanner = table.getScanner(scan);){
                int count = 0;
                byte[] lastRow = null;
                for (Result r : scanner) {
                    Assert.assertFalse((boolean)r.isEmpty());
                    ++count;
                    byte[] thisRow = r.getRow();
                    if (lastRow != null) {
                        Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
                    }
                    lastRow = thisRow;
                }
                Assert.assertEquals((long)insertNum, (long)count);
            }
        }
    }

    @Test
    public void testSmallReversedScanUnderMultiRegions() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] splitRows = new byte[][]{Bytes.toBytes((String)"000"), Bytes.toBytes((String)"002"), Bytes.toBytes((String)"004"), Bytes.toBytes((String)"006"), Bytes.toBytes((String)"008"), Bytes.toBytes((String)"010")};
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY, (byte[][])splitRows);){
            TEST_UTIL.waitUntilAllRegionsAssigned(table.getName());
            try (RegionLocator regionLocator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
                Assert.assertEquals((long)(splitRows.length + 1), (long)regionLocator.getAllRegionLocations().size());
            }
            for (byte[] splitRow : splitRows) {
                Put put = new Put(splitRow);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                table.put(put);
                byte[] nextRow = Bytes.copy((byte[])splitRow);
                int n = nextRow.length - 1;
                nextRow[n] = (byte)(nextRow[n] + 1);
                put = new Put(nextRow);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                table.put(put);
            }
            try (ResultScanner resultScanner = table.getScanner(new Scan());){
                int count = 0;
                for (Result r : resultScanner) {
                    Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
                    ++count;
                }
                Assert.assertEquals((long)12L, (long)count);
            }
            this.reverseScanTest(table, false);
            this.reverseScanTest(table, true);
        }
    }

    private void reverseScanTest(Table table, boolean small) throws IOException {
        byte[] thisRow;
        byte[] lastRow;
        int count;
        Scan scan = new Scan();
        scan.setReversed(true);
        try (ResultScanner scanner = table.getScanner(scan);){
            count = 0;
            lastRow = null;
            for (Result r : scanner) {
                Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
                ++count;
                thisRow = r.getRow();
                if (lastRow != null) {
                    Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
                }
                lastRow = thisRow;
            }
            Assert.assertEquals((long)12L, (long)count);
        }
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"002"));
        scanner = table.getScanner(scan);
        var5_5 = null;
        try {
            count = 0;
            lastRow = null;
            for (Result r : scanner) {
                Assert.assertTrue((!r.isEmpty() ? 1 : 0) != 0);
                ++count;
                thisRow = r.getRow();
                if (lastRow != null) {
                    Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
                }
                lastRow = thisRow;
            }
            Assert.assertEquals((long)3L, (long)count);
        }
        catch (Throwable count2) {
            var5_5 = count2;
            throw count2;
        }
        finally {
            if (scanner != null) {
                if (var5_5 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable count2) {
                        var5_5.addSuppressed(count2);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"002"));
        scan.setStopRow(Bytes.toBytes((String)"000"));
        scanner = table.getScanner(scan);
        var5_5 = null;
        try {
            int count3 = 0;
            lastRow = null;
            for (Result r : scanner) {
                Assert.assertFalse((boolean)r.isEmpty());
                ++count3;
                thisRow = r.getRow();
                if (lastRow != null) {
                    Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
                }
                lastRow = thisRow;
            }
            Assert.assertEquals((long)2L, (long)count3);
        }
        catch (Throwable count3) {
            var5_5 = count3;
            throw count3;
        }
        finally {
            if (scanner != null) {
                if (var5_5 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable count3) {
                        var5_5.addSuppressed(count3);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"001"));
        scanner = table.getScanner(scan);
        var5_5 = null;
        try {
            int count4 = 0;
            lastRow = null;
            for (Result r : scanner) {
                Assert.assertFalse((boolean)r.isEmpty());
                ++count4;
                thisRow = r.getRow();
                if (lastRow != null) {
                    Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
                }
                lastRow = thisRow;
            }
            Assert.assertEquals((long)2L, (long)count4);
        }
        catch (Throwable count4) {
            var5_5 = count4;
            throw count4;
        }
        finally {
            if (scanner != null) {
                if (var5_5 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable count4) {
                        var5_5.addSuppressed(count4);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"000"));
        scanner = table.getScanner(scan);
        var5_5 = null;
        try {
            int count5 = 0;
            lastRow = null;
            for (Result r : scanner) {
                Assert.assertFalse((boolean)r.isEmpty());
                ++count5;
                thisRow = r.getRow();
                if (lastRow != null) {
                    Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
                }
                lastRow = thisRow;
            }
            Assert.assertEquals((long)1L, (long)count5);
        }
        catch (Throwable count5) {
            var5_5 = count5;
            throw count5;
        }
        finally {
            if (scanner != null) {
                if (var5_5 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable count5) {
                        var5_5.addSuppressed(count5);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        scan = new Scan();
        scan.setSmall(small);
        scan.setReversed(true);
        scan.setStartRow(Bytes.toBytes((String)"006"));
        scan.setStopRow(Bytes.toBytes((String)"002"));
        scanner = table.getScanner(scan);
        var5_5 = null;
        try {
            int count6 = 0;
            lastRow = null;
            for (Result r : scanner) {
                Assert.assertFalse((boolean)r.isEmpty());
                ++count6;
                thisRow = r.getRow();
                if (lastRow != null) {
                    Assert.assertTrue((String)("Error scan order, last row= " + Bytes.toString((byte[])lastRow) + ",this row=" + Bytes.toString((byte[])thisRow)), (Bytes.compareTo((byte[])thisRow, (byte[])lastRow) < 0 ? 1 : 0) != 0);
                }
                lastRow = thisRow;
            }
            Assert.assertEquals((long)4L, (long)count6);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (scanner != null) {
                if (var5_5 != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    scanner.close();
                }
            }
        }
    }

    @Test
    public void testFilterAllRecords() throws IOException {
        Scan scan = new Scan();
        scan.setBatch(1);
        scan.setCaching(1);
        scan.setFilter((Filter)new FilterList(new Filter[]{new FirstKeyOnlyFilter(), new InclusiveStopFilter(new byte[0])}));
        try (Table table = TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME);
             ResultScanner s = table.getScanner(scan);){
            Assert.assertNull((Object)s.next());
        }
    }

    @Test
    public void testCellSizeLimit() throws IOException {
        TableName tableName = this.name.getTableName();
        TableDescriptorBuilder.ModifyableTableDescriptor tableDescriptor = new TableDescriptorBuilder.ModifyableTableDescriptor(tableName).setValue("hbase.server.keyvalue.maxsize", Integer.toString(10240));
        ColumnFamilyDescriptorBuilder.ModifyableColumnFamilyDescriptor familyDescriptor = new ColumnFamilyDescriptorBuilder.ModifyableColumnFamilyDescriptor(FAMILY);
        tableDescriptor.setColumnFamily((ColumnFamilyDescriptor)familyDescriptor);
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.createTable((TableDescriptor)tableDescriptor);
        }
        var5_5 = null;
        try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
            t.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, Bytes.toBytes((long)0L)));
            t.increment(new Increment(ROW).addColumn(FAMILY, QUALIFIER, 1L));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        t = TEST_UTIL.getConnection().getTable(tableName);
        var5_5 = null;
        try {
            t.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, new byte[9216]));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (t != null) {
                if (var5_5 != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    t.close();
                }
            }
        }
        t = TEST_UTIL.getConnection().getTable(tableName);
        var5_5 = null;
        try {
            try {
                t.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, new byte[10240]));
                Assert.fail((String)"Oversize cell failed to trigger exception");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                t.append(new Append(ROW).addColumn(FAMILY, QUALIFIER, new byte[2048]));
                Assert.fail((String)"Oversize cell failed to trigger exception");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (t != null) {
                if (var5_5 != null) {
                    try {
                        t.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    t.close();
                }
            }
        }
    }

    @Test
    public void testCellSizeNoLimit() throws IOException {
        TableName tableName = this.name.getTableName();
        ColumnFamilyDescriptorBuilder.ModifyableColumnFamilyDescriptor familyDescriptor = new ColumnFamilyDescriptorBuilder.ModifyableColumnFamilyDescriptor(FAMILY);
        TableDescriptorBuilder.ModifyableTableDescriptor tableDescriptor = new TableDescriptorBuilder.ModifyableTableDescriptor(tableName).setValue("hbase.server.keyvalue.maxsize", Integer.toString(0));
        tableDescriptor.setColumnFamily((ColumnFamilyDescriptor)familyDescriptor);
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.createTable((TableDescriptor)tableDescriptor);
        }
        var5_5 = null;
        try (Table ht = TEST_UTIL.getConnection().getTable(tableName);){
            ht.put(new Put(ROW).addColumn(FAMILY, QUALIFIER, new byte[10484736]));
            ht.append(new Append(ROW).addColumn(FAMILY, QUALIFIER, new byte[1025]));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testDeleteSpecifiedVersionOfSpecifiedColumn() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);){
            Put put = new Put(ROW);
            for (int t = 0; t < 4; ++t) {
                put.addColumn(FAMILY, QUALIFIER, ts[t], VALUES[t]);
            }
            ht.put(put);
            Delete delete = new Delete(ROW);
            delete.addColumn(FAMILY, QUALIFIER, ts[2]);
            ht.delete(delete);
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[1], ts[3]}, new byte[][]{VALUES[0], VALUES[1], VALUES[3]}, 0, 2);
            delete = new Delete(ROW);
            delete.addColumn(FAMILY, QUALIFIER, ts[4]);
            ht.delete(delete);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[1], ts[3]}, new byte[][]{VALUES[0], VALUES[1], VALUES[3]}, 0, 2);
        }
    }

    @Test
    public void testDeleteLatestVersionOfSpecifiedColumn() throws Exception {
        TableName tableName = this.name.getTableName();
        byte[][] VALUES = this.makeN(VALUE, 5);
        long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
        try (Table ht = TEST_UTIL.createTable(tableName, FAMILY, 5);){
            Put put = new Put(ROW);
            for (int t = 0; t < 4; ++t) {
                put.addColumn(FAMILY, QUALIFIER, ts[t], VALUES[t]);
            }
            ht.put(put);
            Delete delete = new Delete(ROW);
            delete.addColumn(FAMILY, QUALIFIER);
            ht.delete(delete);
            Get get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[1], ts[2]}, new byte[][]{VALUES[0], VALUES[1], VALUES[2]}, 0, 2);
            delete = new Delete(ROW);
            delete.addColumn(FAMILY, QUALIFIER);
            delete.addColumn(FAMILY, QUALIFIER);
            ht.delete(delete);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0]}, new byte[][]{VALUES[0]}, 0, 0);
            put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, ts[4], VALUES[4]);
            ht.put(put);
            get = new Get(ROW);
            get.addColumn(FAMILY, QUALIFIER);
            get.readVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[0], ts[4]}, new byte[][]{VALUES[0], VALUES[4]}, 0, 1);
        }
    }

    @Test
    public void testReadWithFilter() throws Exception {
        TableName tableName = this.name.getTableName();
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY, 3);){
            byte[] VALUEA = Bytes.toBytes((String)"value-a");
            byte[] VALUEB = Bytes.toBytes((String)"value-b");
            long[] ts = new long[]{1000L, 2000L, 3000L, 4000L};
            Put put = new Put(ROW);
            for (int t = 0; t <= 3; ++t) {
                if (t <= 1) {
                    put.addColumn(FAMILY, QUALIFIER, ts[t], VALUEA);
                    continue;
                }
                put.addColumn(FAMILY, QUALIFIER, ts[t], VALUEB);
            }
            table.put(put);
            Scan scan = new Scan().setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(3);
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
            Get get = new Get(ROW).setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).readVersions(3);
            result = table.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
            scan = new Scan().setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(1);
            scanner = table.getScanner(scan);
            result = scanner.next();
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
            get = new Get(ROW).setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).readVersions(1);
            result = table.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
            scan = new Scan().setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).setMaxVersions(5);
            scanner = table.getScanner(scan);
            result = scanner.next();
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
            get = new Get(ROW).setFilter((Filter)new ValueFilter(CompareOperator.EQUAL, (ByteArrayComparable)new SubstringComparator("value-a"))).readVersions(5);
            result = table.get(get);
            this.assertNResult(result, ROW, FAMILY, QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUEA}, 0, 0);
        }
    }

    @Test
    public void testCellUtilTypeMethods() throws IOException {
        TableName tableName = this.name.getTableName();
        try (Table table = TEST_UTIL.createTable(tableName, FAMILY);){
            byte[] row = Bytes.toBytes((String)"p");
            Put p = new Put(row);
            p.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(p);
            try (ResultScanner scanner = table.getScanner(new Scan());){
                Result result = scanner.next();
                Assert.assertNotNull((Object)result);
                CellScanner cs = result.cellScanner();
                Assert.assertTrue((boolean)cs.advance());
                Cell c = cs.current();
                Assert.assertTrue((boolean)CellUtil.isPut((Cell)c));
                Assert.assertFalse((boolean)CellUtil.isDelete((Cell)c));
                Assert.assertFalse((boolean)cs.advance());
                Assert.assertNull((Object)scanner.next());
            }
            Delete d = new Delete(row);
            d.addColumn(FAMILY, QUALIFIER);
            table.delete(d);
            Scan scan = new Scan();
            scan.setRaw(true);
            try (ResultScanner scanner = table.getScanner(scan);){
                Result result = scanner.next();
                Assert.assertNotNull((Object)result);
                CellScanner cs = result.cellScanner();
                Assert.assertTrue((boolean)cs.advance());
                Cell c = cs.current();
                Assert.assertTrue((String)("Cell should be a Delete: " + c), (boolean)CellUtil.isDelete((Cell)c));
                Assert.assertFalse((String)("Cell should not be a Put: " + c), (boolean)CellUtil.isPut((Cell)c));
                Assert.assertTrue((boolean)cs.advance());
                c = cs.current();
                Assert.assertFalse((String)("Cell should not be a Delete: " + c), (boolean)CellUtil.isDelete((Cell)c));
                Assert.assertTrue((String)("Cell should be a Put: " + c), (boolean)CellUtil.isPut((Cell)c));
                Assert.assertFalse((boolean)cs.advance());
                Assert.assertNull((Object)scanner.next());
            }
        }
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testCreateTableWithZeroRegionReplicas() throws Exception {
        TableName tableName = this.name.getTableName();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"cf"))).setRegionReplication(0).build();
        TEST_UTIL.getAdmin().createTable(desc);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testModifyTableWithZeroRegionReplicas() throws Exception {
        TableName tableName = this.name.getTableName();
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])Bytes.toBytes((String)"cf"))).build();
        TEST_UTIL.getAdmin().createTable(desc);
        TableDescriptor newDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)desc).setRegionReplication(0).build();
        TEST_UTIL.getAdmin().modifyTable(newDesc);
    }

    @Test(timeout=60000L)
    public void testModifyTableWithMemstoreData() throws Exception {
        TableName tableName = this.name.getTableName();
        this.createTableAndValidateTableSchemaModification(tableName, true);
    }

    @Test(timeout=60000L)
    public void testDeleteCFWithMemstoreData() throws Exception {
        TableName tableName = this.name.getTableName();
        this.createTableAndValidateTableSchemaModification(tableName, false);
    }

    private void createTableAndValidateTableSchemaModification(TableName tableName, boolean modifyTable) throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        byte[] cf1 = Bytes.toBytes((String)"cf1");
        byte[] cf2 = Bytes.toBytes((String)"cf2");
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf1)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])cf2)).build();
        admin.createTable(tableDesc);
        Table t = TEST_UTIL.getConnection().getTable(tableName);
        t.put(new Put(ROW).addColumn(cf1, QUALIFIER, Bytes.toBytes((String)"val1")));
        t.put(new Put(ROW).addColumn(cf2, QUALIFIER, Bytes.toBytes((String)"val2")));
        admin.flush(tableName);
        Path tableDir = CommonFSUtils.getTableDir((Path)TEST_UTIL.getDefaultRootDirPath(), (TableName)tableName);
        List regionDirs = FSUtils.getRegionDirs((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)tableDir);
        Assert.assertEquals((long)1L, (long)regionDirs.size());
        List familyDirs = FSUtils.getFamilyDirs((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)((Path)regionDirs.get(0)));
        Assert.assertEquals((long)2L, (long)familyDirs.size());
        t.put(new Put(ROW).addColumn(cf1, QUALIFIER, Bytes.toBytes((String)"val2")));
        t.put(new Put(ROW).addColumn(cf2, QUALIFIER, Bytes.toBytes((String)"val2")));
        if (modifyTable) {
            tableDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)tableDesc).removeColumnFamily(cf2).build();
            admin.modifyTable(tableDesc);
        } else {
            admin.deleteColumnFamily(tableName, cf2);
        }
        familyDirs = FSUtils.getFamilyDirs((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)((Path)regionDirs.get(0)));
        Assert.assertEquals((String)("CF dir count should be 1, but was " + familyDirs.size()), (long)1L, (long)familyDirs.size());
    }
}

