/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestSwitchToStreamRead {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSwitchToStreamRead.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"stream");
    private static byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static byte[] QUAL = Bytes.toBytes((String)"cq");
    private static String VALUE_PREFIX;
    private static HRegion REGION;

    @Before
    public void setUp() throws IOException {
        int i;
        UTIL.getConfiguration().setLong("hbase.storescanner.pread.max.bytes", 2048L);
        StringBuilder sb = new StringBuilder(256);
        for (i = 0; i < 255; ++i) {
            sb.append((char)ThreadLocalRandom.current().nextInt(65, 123));
        }
        VALUE_PREFIX = sb.append("-").toString();
        REGION = UTIL.createLocalHRegion(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setBlocksize(1024).build()).build(), null, null);
        for (i = 0; i < 900; ++i) {
            REGION.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUAL, Bytes.toBytes((String)(VALUE_PREFIX + i))));
        }
        REGION.flush(true);
        for (i = 900; i < 1000; ++i) {
            REGION.put(new Put(Bytes.toBytes((int)i)).addColumn(FAMILY, QUAL, Bytes.toBytes((String)(VALUE_PREFIX + i))));
        }
    }

    @After
    public void tearDown() throws IOException {
        REGION.close(true);
        UTIL.cleanupTestDir();
    }

    @Test
    public void test() throws IOException {
        try (HRegion.RegionScannerImpl scanner = REGION.getScanner(new Scan());){
            Result result;
            StoreScanner storeScanner = (StoreScanner)scanner.getStoreHeapForTesting().getCurrentForTesting();
            for (KeyValueScanner kvs : storeScanner.getAllScannersForTesting()) {
                if (!(kvs instanceof StoreFileScanner)) continue;
                StoreFileScanner sfScanner = (StoreFileScanner)kvs;
                Assert.assertTrue((sfScanner.getReader().getReaderContext().getReaderType() == ReaderContext.ReaderType.PREAD ? 1 : 0) != 0);
            }
            ArrayList cells = new ArrayList();
            for (int i = 0; i < 500; ++i) {
                Assert.assertTrue((boolean)scanner.next(cells));
                result = Result.create(cells);
                Assert.assertEquals((Object)(VALUE_PREFIX + i), (Object)Bytes.toString((byte[])result.getValue(FAMILY, QUAL)));
                cells.clear();
                scanner.shipped();
            }
            for (KeyValueScanner kvs : storeScanner.getAllScannersForTesting()) {
                if (!(kvs instanceof StoreFileScanner)) continue;
                StoreFileScanner sfScanner = (StoreFileScanner)kvs;
                Assert.assertFalse((sfScanner.getReader().getReaderContext().getReaderType() == ReaderContext.ReaderType.PREAD ? 1 : 0) != 0);
            }
            for (int i = 500; i < 1000; ++i) {
                Assert.assertEquals((Object)(i != 999 ? 1 : 0), (Object)scanner.next(cells));
                result = Result.create(cells);
                Assert.assertEquals((Object)(VALUE_PREFIX + i), (Object)Bytes.toString((byte[])result.getValue(FAMILY, QUAL)));
                cells.clear();
                scanner.shipped();
            }
        }
        for (HStoreFile sf : REGION.getStore(FAMILY).getStorefiles()) {
            Assert.assertFalse((boolean)sf.isReferencedInReads());
        }
    }

    private void testFilter(Filter filter) throws IOException {
        try (HRegion.RegionScannerImpl scanner = REGION.getScanner(new Scan().setFilter(filter));){
            StoreScanner storeScanner = (StoreScanner)scanner.getStoreHeapForTesting().getCurrentForTesting();
            for (Object kvs : storeScanner.getAllScannersForTesting()) {
                if (!(kvs instanceof StoreFileScanner)) continue;
                StoreFileScanner sfScanner = (StoreFileScanner)kvs;
                Assert.assertTrue((sfScanner.getReader().getReaderContext().getReaderType() == ReaderContext.ReaderType.PREAD ? 1 : 0) != 0);
            }
            ArrayList cells = new ArrayList();
            Assert.assertTrue((boolean)scanner.next(cells, ScannerContext.newBuilder().setTimeLimit(ScannerContext.LimitScope.BETWEEN_CELLS, -1L).build()));
            Assert.assertTrue((boolean)cells.isEmpty());
            scanner.shipped();
            for (KeyValueScanner kvs : storeScanner.getAllScannersForTesting()) {
                if (!(kvs instanceof StoreFileScanner)) continue;
                StoreFileScanner sfScanner = (StoreFileScanner)kvs;
                Assert.assertFalse((sfScanner.getReader().getReaderContext().getReaderType() == ReaderContext.ReaderType.PREAD ? 1 : 0) != 0);
            }
            Assert.assertFalse((boolean)scanner.next(cells, ScannerContext.newBuilder().setTimeLimit(ScannerContext.LimitScope.BETWEEN_CELLS, -1L).build()));
            Result result = Result.create(cells);
            Assert.assertEquals((Object)(VALUE_PREFIX + 999), (Object)Bytes.toString((byte[])result.getValue(FAMILY, QUAL)));
            cells.clear();
            scanner.shipped();
        }
        for (HStoreFile sf : REGION.getStore(FAMILY).getStorefiles()) {
            Assert.assertFalse((boolean)sf.isReferencedInReads());
        }
    }

    @Ignore
    @Test
    public void testFilterRowKey() throws IOException {
        this.testFilter((Filter)new MatchLastRowKeyFilter());
    }

    @Test
    public void testFilterCellNextCol() throws IOException {
        this.testFilter((Filter)new MatchLastRowCellNextColFilter());
    }

    @Test
    public void testFilterCellNextRow() throws IOException {
        this.testFilter((Filter)new MatchLastRowCellNextRowFilter());
    }

    @Test
    public void testFilterRow() throws IOException {
        this.testFilter((Filter)new MatchLastRowFilterRowFilter());
    }

    public static final class MatchLastRowFilterRowFilter
    extends FilterBase {
        private boolean exclude;

        public void filterRowCells(List<Cell> kvs) throws IOException {
            Cell c = kvs.get(0);
            this.exclude = Bytes.toInt((byte[])c.getRowArray(), (int)c.getRowOffset()) != 999;
        }

        public void reset() throws IOException {
            this.exclude = false;
        }

        public boolean filterRow() throws IOException {
            return this.exclude;
        }

        public boolean hasFilterRow() {
            return true;
        }
    }

    public static final class MatchLastRowCellNextRowFilter
    extends FilterBase {
        public Filter.ReturnCode filterCell(Cell c) throws IOException {
            if (Bytes.toInt((byte[])c.getRowArray(), (int)c.getRowOffset()) == 999) {
                return Filter.ReturnCode.INCLUDE;
            }
            return Filter.ReturnCode.NEXT_ROW;
        }
    }

    public static final class MatchLastRowCellNextColFilter
    extends FilterBase {
        public Filter.ReturnCode filterCell(Cell c) throws IOException {
            if (Bytes.toInt((byte[])c.getRowArray(), (int)c.getRowOffset()) == 999) {
                return Filter.ReturnCode.INCLUDE;
            }
            return Filter.ReturnCode.NEXT_COL;
        }
    }

    public static final class MatchLastRowKeyFilter
    extends FilterBase {
        public boolean filterRowKey(Cell cell) throws IOException {
            return Bytes.toInt((byte[])cell.getRowArray(), (int)cell.getRowOffset()) != 999;
        }
    }
}

