/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
@Category(value={LargeTests.class})
public class TestMultiLogThreshold {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiLogThreshold.class);
    private static RSRpcServices SERVICES;
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration CONF;
    private static final byte[] TEST_FAM;
    private static RSRpcServices.LogDelegate LD;
    private static HRegionServer RS;
    private static int THRESHOLD;
    @Parameterized.Parameter
    public static boolean rejectLargeBatchOp;

    @Parameterized.Parameters
    public static List<Object[]> params() {
        return Arrays.asList({false}, {true});
    }

    @Before
    public void setupTest() throws Exception {
        TableName tableName = TableName.valueOf((String)"tableName");
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        CONF = TEST_UTIL.getConfiguration();
        THRESHOLD = CONF.getInt("hbase.rpc.rows.warning.threshold", 5000);
        CONF.setBoolean("hbase.rpc.rows.size.threshold.reject", rejectLargeBatchOp);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.createTable(tableName, TEST_FAM);
        RS = TEST_UTIL.getRSForFirstRegionInTable(tableName);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private void sendMultiRequest(int rows, ActionType actionType) throws ServiceException, IOException {
        RpcController rpcc = (RpcController)Mockito.mock(HBaseRpcController.class);
        ClientProtos.MultiRequest.Builder builder = ClientProtos.MultiRequest.newBuilder();
        int numRAs = 1;
        int numAs = 1;
        switch (actionType) {
            case REGION_ACTIONS: {
                numRAs = rows;
                break;
            }
            case ACTIONS: {
                numAs = rows;
            }
        }
        for (int i = 0; i < numRAs; ++i) {
            ClientProtos.RegionAction.Builder rab = ClientProtos.RegionAction.newBuilder();
            rab.setRegion(RequestConverter.buildRegionSpecifier((HBaseProtos.RegionSpecifier.RegionSpecifierType)HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, (byte[])new String("someStuff" + i).getBytes()));
            for (int j = 0; j < numAs; ++j) {
                ClientProtos.Action.Builder ab = ClientProtos.Action.newBuilder();
                rab.addAction(ab.build());
            }
            builder.addRegionAction(rab.build());
        }
        LD = (RSRpcServices.LogDelegate)Mockito.mock(RSRpcServices.LogDelegate.class);
        SERVICES = new RSRpcServices(RS, LD);
        SERVICES.multi(rpcc, builder.build());
    }

    @Test
    public void testMultiLogThresholdRegionActions() throws ServiceException, IOException {
        try {
            this.sendMultiRequest(THRESHOLD + 1, ActionType.REGION_ACTIONS);
            Assert.assertFalse((boolean)rejectLargeBatchOp);
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)rejectLargeBatchOp);
        }
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.times((int)1))).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
        this.sendMultiRequest(THRESHOLD, ActionType.REGION_ACTIONS);
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.never())).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
        try {
            this.sendMultiRequest(THRESHOLD + 1, ActionType.ACTIONS);
            Assert.assertFalse((boolean)rejectLargeBatchOp);
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)rejectLargeBatchOp);
        }
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.times((int)1))).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
        this.sendMultiRequest(THRESHOLD, ActionType.ACTIONS);
        ((RSRpcServices.LogDelegate)Mockito.verify((Object)LD, (VerificationMode)Mockito.never())).logBatchWarning(Mockito.anyString(), Mockito.anyInt(), Mockito.anyInt());
    }

    static {
        TEST_FAM = Bytes.toBytes((String)"fam");
    }

    private static enum ActionType {
        REGION_ACTIONS,
        ACTIONS;

    }
}

