/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestMasterQuotaManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterQuotaManager.class);

    @Test
    public void testUninitializedQuotaManangerDoesNotFail() {
        MasterServices masterServices = (MasterServices)Mockito.mock(MasterServices.class);
        MasterQuotaManager manager = new MasterQuotaManager(masterServices);
        manager.addRegionSize(null, 0L, 0L);
        Assert.assertNotNull((Object)manager.snapshotRegionSizes());
    }

    @Test
    public void testOldEntriesRemoved() {
        MasterServices masterServices = (MasterServices)Mockito.mock(MasterServices.class);
        MasterQuotaManager manager = new MasterQuotaManager(masterServices);
        manager.initializeRegionSizes();
        TableName tableName = TableName.valueOf((String)"foo");
        HRegionInfo region1 = new HRegionInfo(tableName, null, Bytes.toBytes((String)"a"));
        HRegionInfo region2 = new HRegionInfo(tableName, Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"));
        HRegionInfo region3 = new HRegionInfo(tableName, Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"));
        HRegionInfo region4 = new HRegionInfo(tableName, Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"));
        HRegionInfo region5 = new HRegionInfo(tableName, Bytes.toBytes((String)"d"), null);
        long size = 0L;
        long time1 = 10L;
        manager.addRegionSize((RegionInfo)region1, 0L, time1);
        manager.addRegionSize((RegionInfo)region2, 0L, time1);
        long time2 = 20L;
        manager.addRegionSize((RegionInfo)region3, 0L, time2);
        manager.addRegionSize((RegionInfo)region4, 0L, time2);
        long time3 = 30L;
        manager.addRegionSize((RegionInfo)region5, 0L, time3);
        Assert.assertEquals((long)5L, (long)manager.snapshotRegionSizes().size());
        QuotaObserverChore chore = (QuotaObserverChore)Mockito.mock(QuotaObserverChore.class);
        Assert.assertEquals((long)0L, (long)manager.pruneEntriesOlderThan(0L, chore));
        Assert.assertEquals((long)5L, (long)manager.snapshotRegionSizes().size());
        Assert.assertEquals((long)0L, (long)manager.pruneEntriesOlderThan(10L, chore));
        Assert.assertEquals((long)5L, (long)manager.snapshotRegionSizes().size());
        Assert.assertEquals((long)2L, (long)manager.pruneEntriesOlderThan(15L, chore));
        Assert.assertEquals((long)3L, (long)manager.snapshotRegionSizes().size());
        Assert.assertEquals((long)2L, (long)manager.pruneEntriesOlderThan(30L, chore));
        Assert.assertEquals((long)1L, (long)manager.snapshotRegionSizes().size());
    }
}

