/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ipc.CallQueueInfo;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandler;
import org.apache.hadoop.hbase.monitoring.MonitoredRPCHandlerImpl;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RPCTests.class, SmallTests.class})
public class TestFifoRpcScheduler {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFifoRpcScheduler.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFifoRpcScheduler.class);
    private AtomicInteger callExecutionCount;
    private final RpcScheduler.Context CONTEXT = new RpcScheduler.Context(){

        public InetSocketAddress getListenerAddress() {
            return InetSocketAddress.createUnresolved("127.0.0.1", 1000);
        }
    };
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = HBaseConfiguration.create();
        this.callExecutionCount = new AtomicInteger(0);
    }

    private ThreadPoolExecutor disableHandlers(RpcScheduler scheduler) {
        ThreadPoolExecutor rpcExecutor = null;
        try {
            Field ExecutorField = scheduler.getClass().getDeclaredField("executor");
            ExecutorField.setAccessible(true);
            scheduler.start();
            rpcExecutor = (ThreadPoolExecutor)ExecutorField.get(scheduler);
            rpcExecutor.setMaximumPoolSize(1);
            rpcExecutor.allowCoreThreadTimeOut(true);
            rpcExecutor.setCorePoolSize(0);
            rpcExecutor.setKeepAliveTime(1L, TimeUnit.MICROSECONDS);
            Thread.sleep(2000L);
        }
        catch (NoSuchFieldException e) {
            LOG.error("No such field exception:" + e);
        }
        catch (IllegalAccessException e) {
            LOG.error("Illegal access exception:" + e);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted exception:" + e);
        }
        return rpcExecutor;
    }

    @Test
    public void testCallQueueInfo() throws IOException, InterruptedException {
        FifoRpcScheduler scheduler = new FifoRpcScheduler(this.conf, 1);
        scheduler.init(this.CONTEXT);
        this.disableHandlers((RpcScheduler)scheduler);
        int totalCallMethods = 30;
        int unableToDispatch = 0;
        for (int i = totalCallMethods; i > 0; --i) {
            CallRunner task = this.createMockTask();
            task.setStatus((MonitoredRPCHandler)new MonitoredRPCHandlerImpl());
            if (!scheduler.dispatch(task)) {
                ++unableToDispatch;
            }
            Thread.sleep(10L);
        }
        CallQueueInfo callQueueInfo = scheduler.getCallQueueInfo();
        int executionCount = this.callExecutionCount.get();
        int callQueueSize = 0;
        for (String callQueueName : callQueueInfo.getCallQueueNames()) {
            for (String calledMethod : callQueueInfo.getCalledMethodNames(callQueueName)) {
                callQueueSize = (int)((long)callQueueSize + callQueueInfo.getCallMethodCount(callQueueName, calledMethod));
            }
        }
        Assert.assertEquals((long)(totalCallMethods - unableToDispatch), (long)(callQueueSize + executionCount));
        scheduler.stop();
    }

    private CallRunner createMockTask() {
        ServerCall call = (ServerCall)Mockito.mock(ServerCall.class);
        CallRunner task = (CallRunner)Mockito.mock(CallRunner.class);
        Mockito.when((Object)task.getRpcCall()).thenReturn((Object)call);
        ((CallRunner)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                TestFifoRpcScheduler.this.callExecutionCount.incrementAndGet();
                Thread.sleep(1000L);
                return null;
            }
        }).when((Object)task)).run();
        return task;
    }
}

