/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.master.snapshot.DefaultSnapshotFileManager;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.security.access.AccessControlClient;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.ShadedAccessControlUtil;
import org.apache.hadoop.hbase.security.access.TablePermission;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ListMultimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RestoreSnapshotHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RestoreSnapshotHelper.class);
    private final Map<byte[], byte[]> regionsMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    private final Map<String, org.apache.hadoop.hbase.util.Pair<String, String>> parentsMap = new HashMap<String, org.apache.hadoop.hbase.util.Pair<String, String>>();
    private final ForeignExceptionDispatcher monitor;
    private final MonitoredTask status;
    private final SnapshotManifest snapshotManifest;
    private final SnapshotProtos.SnapshotDescription snapshotDesc;
    private final TableName snapshotTable;
    private final TableDescriptor tableDesc;
    private final Path rootDir;
    private final Path tableDir;
    private final Configuration conf;
    private final FileSystem fs;
    private final boolean createBackRefs;
    private final SnapshotFileManager snapshotFileManager;

    public RestoreSnapshotHelper(Configuration conf, FileSystem fs, SnapshotManifest manifest, TableDescriptor tableDescriptor, Path rootDir, ForeignExceptionDispatcher monitor, MonitoredTask status, SnapshotFileManager snapshotFileManager) {
        this(conf, fs, manifest, tableDescriptor, rootDir, monitor, status, true, snapshotFileManager);
    }

    public RestoreSnapshotHelper(Configuration conf, FileSystem fs, SnapshotManifest manifest, TableDescriptor tableDescriptor, Path rootDir, ForeignExceptionDispatcher monitor, MonitoredTask status, boolean createBackRefs) {
        this(conf, fs, manifest, tableDescriptor, rootDir, monitor, status, createBackRefs, new DefaultSnapshotFileManager());
    }

    public RestoreSnapshotHelper(Configuration conf, FileSystem fs, SnapshotManifest manifest, TableDescriptor tableDescriptor, Path rootDir, ForeignExceptionDispatcher monitor, MonitoredTask status, boolean createBackRefs, SnapshotFileManager snapshotFileManager) {
        this.fs = fs;
        this.conf = conf;
        this.snapshotManifest = manifest;
        this.snapshotDesc = manifest.getSnapshotDescription();
        this.snapshotTable = TableName.valueOf((String)this.snapshotDesc.getTable());
        this.tableDesc = tableDescriptor;
        this.rootDir = rootDir;
        this.tableDir = FSUtils.getTableDir((Path)rootDir, (TableName)this.tableDesc.getTableName());
        this.monitor = monitor;
        this.status = status;
        this.createBackRefs = createBackRefs;
        this.snapshotFileManager = snapshotFileManager;
    }

    public RestoreChanges restoreHdfsRegions() throws IOException {
        ThreadPoolExecutor exec = SnapshotManifest.createExecutor(this.conf, "RestoreSnapshot");
        try {
            RestoreChanges restoreChanges = this.restoreHdfsRegions(exec);
            return restoreChanges;
        }
        finally {
            exec.shutdown();
        }
    }

    private RestoreChanges restoreHdfsRegions(ThreadPoolExecutor exec) throws IOException {
        LOG.info("starting restore table regions using snapshot=" + this.snapshotDesc);
        Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests = this.snapshotManifest.getRegionManifestsMap();
        if (regionManifests == null) {
            LOG.warn("Nothing to restore. Snapshot " + this.snapshotDesc + " looks empty");
            return null;
        }
        RestoreMetaChanges metaChanges = new RestoreMetaChanges(this.tableDesc, this.parentsMap);
        RestoreFileChanges fileChanges = new RestoreFileChanges();
        RestoreFileChanges mobFileChanges = new RestoreFileChanges();
        RestoreChanges restoreChanges = new RestoreChanges(fileChanges, metaChanges);
        HashSet<String> regionNames = new HashSet<String>(regionManifests.keySet());
        List<RegionInfo> tableRegions = this.getTableRegions();
        RegionInfo mobRegion = MobUtils.getMobRegionInfo(this.snapshotManifest.getTableDescriptor().getTableName());
        if (tableRegions != null && regionNames.contains(mobRegion.getEncodedName())) {
            this.monitor.rethrowException();
            this.status.setStatus("Restoring mob region...");
            ArrayList mobRegions = new ArrayList(1);
            mobRegions.add(mobRegion);
            this.restoreHdfsMobRegions(exec, regionManifests, mobRegions, mobFileChanges);
            regionNames.remove(mobRegion.getEncodedName());
            this.status.setStatus("Finished restoring mob region.");
        }
        if (regionNames.contains(mobRegion.getEncodedName())) {
            this.monitor.rethrowException();
            this.status.setStatus("Cloning mob region...");
            this.cloneHdfsMobRegion(regionManifests, mobRegion, mobFileChanges);
            regionNames.remove(mobRegion.getEncodedName());
            this.status.setStatus("Finished cloning mob region.");
        }
        if (tableRegions != null) {
            this.monitor.rethrowException();
            for (RegionInfo regionInfo : tableRegions) {
                String regionName = regionInfo.getEncodedName();
                if (regionNames.contains(regionName)) {
                    LOG.info("region to restore: " + regionName);
                    regionNames.remove(regionName);
                    metaChanges.addRegionToRestore(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)regionManifests.get(regionName).getRegionInfo()));
                    continue;
                }
                LOG.info("region to remove: " + regionName);
                metaChanges.addRegionToRemove(regionInfo);
            }
        }
        ArrayList<RegionInfo> regionsToAdd = new ArrayList<RegionInfo>(regionNames.size());
        if (regionNames.size() > 0) {
            this.monitor.rethrowException();
            for (String regionName : regionNames) {
                LOG.info("region to add: " + regionName);
                regionsToAdd.add(ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)regionManifests.get(regionName).getRegionInfo()));
            }
        }
        this.monitor.rethrowException();
        this.status.setStatus("Cloning regions...");
        RegionInfo[] regionInfoArray = this.cloneHdfsRegions(exec, regionManifests, regionsToAdd, fileChanges);
        metaChanges.setNewRegions(regionInfoArray);
        this.status.setStatus("Finished cloning regions.");
        this.monitor.rethrowException();
        this.status.setStatus("Restoring table regions...");
        this.restoreHdfsRegions(exec, regionManifests, metaChanges.getRegionsToRestore(), fileChanges);
        this.status.setStatus("Finished restoring all table regions.");
        this.monitor.rethrowException();
        this.status.setStatus("Starting to delete excess regions from table");
        this.removeHdfsRegions(exec, metaChanges.getRegionsToRemove());
        this.status.setStatus("Finished deleting excess regions from table.");
        LOG.info("finishing restore table regions using snapshot=" + this.snapshotDesc);
        return restoreChanges;
    }

    private void removeHdfsRegions(ThreadPoolExecutor exec, List<RegionInfo> regions) throws IOException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        ModifyRegionUtils.editRegions(exec, regions, new ModifyRegionUtils.RegionEditTask(){

            @Override
            public void editRegion(RegionInfo hri) throws IOException {
                HFileArchiver.archiveRegion(RestoreSnapshotHelper.this.conf, RestoreSnapshotHelper.this.fs, hri);
            }
        });
    }

    private void restoreHdfsRegions(ThreadPoolExecutor exec, final Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests, List<RegionInfo> regions, final RestoreFileChanges fileChanges) throws IOException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        ModifyRegionUtils.editRegions(exec, regions, new ModifyRegionUtils.RegionEditTask(){

            @Override
            public void editRegion(RegionInfo hri) throws IOException {
                RestoreSnapshotHelper.this.restoreRegion(hri, (SnapshotProtos.SnapshotRegionManifest)regionManifests.get(hri.getEncodedName()), fileChanges);
            }
        });
    }

    private void restoreHdfsMobRegions(ThreadPoolExecutor exec, final Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests, List<RegionInfo> regions, final RestoreFileChanges mobFileChanges) throws IOException {
        if (regions == null || regions.isEmpty()) {
            return;
        }
        ModifyRegionUtils.editRegions(exec, regions, new ModifyRegionUtils.RegionEditTask(){

            @Override
            public void editRegion(RegionInfo hri) throws IOException {
                RestoreSnapshotHelper.this.restoreMobRegion(hri, (SnapshotProtos.SnapshotRegionManifest)regionManifests.get(hri.getEncodedName()), mobFileChanges);
            }
        });
    }

    private Map<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>> getRegionHFileReferences(SnapshotProtos.SnapshotRegionManifest manifest) {
        HashMap<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>> familyMap = new HashMap<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>>(manifest.getFamilyFilesCount());
        for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles familyFiles : manifest.getFamilyFilesList()) {
            familyMap.put(familyFiles.getFamilyName().toStringUtf8(), new ArrayList(familyFiles.getStoreFilesList()));
        }
        return familyMap;
    }

    private void restoreRegion(RegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest regionManifest, RestoreFileChanges fileChanges) throws IOException {
        this.restoreRegion(regionInfo, regionManifest, new Path(this.tableDir, regionInfo.getEncodedName()), fileChanges);
    }

    private void restoreMobRegion(RegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest regionManifest, RestoreFileChanges mobFileChanges) throws IOException {
        if (regionManifest == null) {
            return;
        }
        this.restoreRegion(regionInfo, regionManifest, MobUtils.getMobRegionPath(this.conf, this.tableDesc.getTableName()), mobFileChanges);
    }

    private void restoreRegion(RegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest regionManifest, Path regionDir, RestoreFileChanges fileChanges) throws IOException {
        Map<String, List<SnapshotProtos.SnapshotRegionManifest.StoreFile>> snapshotFiles = this.getRegionHFileReferences(regionManifest);
        String tableName = this.tableDesc.getTableName().getNameAsString();
        String snapshotName = this.snapshotDesc.getName();
        for (Path path : FSUtils.getFamilyDirs(this.fs, regionDir)) {
            byte[] family = Bytes.toBytes((String)path.getName());
            Set<String> familyFiles = this.getTableRegionFamilyFiles(path);
            List<SnapshotProtos.SnapshotRegionManifest.StoreFile> snapshotFamilyFiles = snapshotFiles.remove(path.getName());
            if (snapshotFamilyFiles != null) {
                ArrayList<SnapshotProtos.SnapshotRegionManifest.StoreFile> hfilesToAdd = new ArrayList<SnapshotProtos.SnapshotRegionManifest.StoreFile>();
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : snapshotFamilyFiles) {
                    if (familyFiles.contains(storeFile.getName())) {
                        familyFiles.remove(storeFile.getName());
                        continue;
                    }
                    hfilesToAdd.add(storeFile);
                }
                for (String hfileName : familyFiles) {
                    Path hfile = new Path(path, hfileName);
                    LOG.trace("Removing HFile=" + hfileName + " not present in snapshot=" + snapshotName + " from region=" + regionInfo.getEncodedName() + " table=" + tableName);
                    HFileArchiver.archiveStoreFile(this.conf, this.fs, regionInfo, this.tableDir, family, hfile);
                    fileChanges.updateFilesToAddAndDelete(regionInfo.getEncodedName(), Bytes.toString((byte[])family), hfile, false);
                }
                for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : hfilesToAdd) {
                    LOG.debug("Restoring missing HFileLink " + storeFile.getName() + " of snapshot=" + snapshotName + " to region=" + regionInfo.getEncodedName() + " table=" + tableName);
                    this.restoreStoreFile(path, regionInfo, storeFile, this.createBackRefs, fileChanges);
                }
                continue;
            }
            LOG.trace("Removing family=" + Bytes.toString((byte[])family) + " in snapshot=" + snapshotName + " from region=" + regionInfo.getEncodedName() + " table=" + tableName);
            HFileArchiver.archiveFamilyByFamilyDir(this.fs, this.conf, regionInfo, path, family);
            this.fs.delete(path, true);
            fileChanges.updateFamiliesToDelete(regionInfo.getEncodedName(), Bytes.toString((byte[])family));
        }
        for (Map.Entry entry : snapshotFiles.entrySet()) {
            Path familyDir = new Path(regionDir, (String)entry.getKey());
            if (!this.fs.mkdirs(familyDir)) {
                throw new IOException("Unable to create familyDir=" + familyDir);
            }
            for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : (List)entry.getValue()) {
                LOG.trace("Adding HFileLink (Not present in the table) " + storeFile.getName() + " of snapshot " + snapshotName + " to table=" + tableName);
                this.restoreStoreFile(familyDir, regionInfo, storeFile, this.createBackRefs, fileChanges);
            }
        }
    }

    private Set<String> getTableRegionFamilyFiles(Path familyDir) throws IOException {
        FileStatus[] hfiles = FSUtils.listStatus((FileSystem)this.fs, (Path)familyDir);
        if (hfiles == null) {
            return Collections.emptySet();
        }
        HashSet<String> familyFiles = new HashSet<String>(hfiles.length);
        for (int i = 0; i < hfiles.length; ++i) {
            String hfileName = hfiles[i].getPath().getName();
            familyFiles.add(hfileName);
        }
        return familyFiles;
    }

    private RegionInfo[] cloneHdfsRegions(ThreadPoolExecutor exec, final Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests, List<RegionInfo> regions, final RestoreFileChanges fileChanges) throws IOException {
        if (regions == null || regions.isEmpty()) {
            return null;
        }
        final HashMap<String, RegionInfo> snapshotRegions = new HashMap<String, RegionInfo>(regions.size());
        String snapshotName = this.snapshotDesc.getName();
        RegionInfo[] clonedRegionsInfo = new RegionInfo[regions.size()];
        for (int i = 0; i < clonedRegionsInfo.length; ++i) {
            RegionInfo snapshotRegionInfo = regions.get(i);
            clonedRegionsInfo[i] = this.cloneRegionInfo(snapshotRegionInfo);
            String snapshotRegionName = snapshotRegionInfo.getEncodedName();
            String clonedRegionName = clonedRegionsInfo[i].getEncodedName();
            this.regionsMap.put(Bytes.toBytes((String)snapshotRegionName), Bytes.toBytes((String)clonedRegionName));
            LOG.info("clone region=" + snapshotRegionName + " as " + clonedRegionName + " in snapshot " + snapshotName);
            snapshotRegions.put(clonedRegionName, snapshotRegionInfo);
        }
        ModifyRegionUtils.createRegions(exec, this.conf, this.rootDir, this.tableDesc, clonedRegionsInfo, new ModifyRegionUtils.RegionFillTask(){

            @Override
            public void fillRegion(HRegion region) throws IOException {
                RegionInfo snapshotHri = (RegionInfo)snapshotRegions.get(region.getRegionInfo().getEncodedName());
                RestoreSnapshotHelper.this.cloneRegion(region, snapshotHri, (SnapshotProtos.SnapshotRegionManifest)regionManifests.get(snapshotHri.getEncodedName()), fileChanges);
            }
        });
        return clonedRegionsInfo;
    }

    private void cloneHdfsMobRegion(Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests, RegionInfo region, RestoreFileChanges mobFileChanges) throws IOException {
        Path clonedRegionPath = MobUtils.getMobRegionPath(this.rootDir, this.tableDesc.getTableName());
        this.cloneRegion(clonedRegionPath, region, regionManifests.get(region.getEncodedName()), mobFileChanges);
    }

    private void cloneRegion(Path regionDir, RegionInfo snapshotRegionInfo, SnapshotProtos.SnapshotRegionManifest manifest, RestoreFileChanges fileChanges) throws IOException {
        String tableName = this.tableDesc.getTableName().getNameAsString();
        String snapshotName = this.snapshotDesc.getName();
        for (SnapshotProtos.SnapshotRegionManifest.FamilyFiles familyFiles : manifest.getFamilyFilesList()) {
            Path familyDir = new Path(regionDir, familyFiles.getFamilyName().toStringUtf8());
            for (SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile : familyFiles.getStoreFilesList()) {
                LOG.info("Adding HFileLink " + storeFile.getName() + " from cloned region in snapshot " + snapshotName + " to table=" + tableName);
                this.restoreStoreFile(familyDir, snapshotRegionInfo, storeFile, this.createBackRefs, fileChanges);
            }
        }
    }

    private void cloneRegion(HRegion region, RegionInfo snapshotRegionInfo, SnapshotProtos.SnapshotRegionManifest manifest, RestoreFileChanges fileChanges) throws IOException {
        this.cloneRegion(new Path(this.tableDir, region.getRegionInfo().getEncodedName()), snapshotRegionInfo, manifest, fileChanges);
    }

    private void restoreStoreFile(Path familyDir, RegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile, boolean createBackRef, RestoreFileChanges fileChanges) throws IOException {
        Path destinationPath;
        String hfileName = storeFile.getName();
        if (HFileLink.isHFileLink(hfileName)) {
            HFileLink.HFileLinkNameComponents linkNameParts = HFileLink.getHFileLinkNameComponents(hfileName);
            TableName linkedTableName = TableName.valueOf((String)linkNameParts.namespace, (String)linkNameParts.tableName);
            String destinationHFileLinkName = HFileLink.createHFileLinkName(linkedTableName, linkNameParts.regionName, linkNameParts.hfileName);
            HFileLink.create(this.conf, this.fs, familyDir, linkedTableName, linkNameParts.regionName, linkNameParts.hfileName, createBackRef, destinationHFileLinkName);
            destinationPath = new Path(familyDir, destinationHFileLinkName);
        } else if (StoreFileInfo.isReference(hfileName)) {
            destinationPath = this.restoreReferenceFile(familyDir, regionInfo, storeFile);
        } else {
            String destinationHFileLinkName = HFileLink.createHFileLinkName(regionInfo.getTable(), regionInfo.getEncodedName(), hfileName);
            HFileLink.create(this.conf, this.fs, familyDir, regionInfo, hfileName, createBackRef, destinationHFileLinkName);
            destinationPath = new Path(familyDir, destinationHFileLinkName);
        }
        fileChanges.updateFilesToAddAndDelete(familyDir.getParent().getName(), familyDir.getName(), destinationPath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path restoreReferenceFile(Path familyDir, RegionInfo regionInfo, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
        String hfileName = storeFile.getName();
        Path refPath = StoreFileInfo.getReferredToFile(new Path(new Path(new Path(new Path(this.snapshotTable.getNamespaceAsString(), this.snapshotTable.getQualifierAsString()), regionInfo.getEncodedName()), familyDir.getName()), hfileName));
        String snapshotRegionName = refPath.getParent().getParent().getName();
        String fileName = refPath.getName();
        String clonedRegionName = Bytes.toString((byte[])this.regionsMap.get(Bytes.toBytes((String)snapshotRegionName)));
        if (clonedRegionName == null) {
            clonedRegionName = snapshotRegionName;
        }
        Path linkPath = null;
        String refLink = fileName;
        if (!HFileLink.isHFileLink(fileName)) {
            refLink = HFileLink.createHFileLinkName(this.snapshotTable, snapshotRegionName, fileName);
            linkPath = new Path(familyDir, HFileLink.createHFileLinkName(this.snapshotTable, regionInfo.getEncodedName(), hfileName));
        }
        Path outPath = new Path(familyDir, refLink + '.' + clonedRegionName);
        if (storeFile.hasReference()) {
            Reference reference = Reference.convert(storeFile.getReference());
            reference.write(this.fs, outPath, this.snapshotFileManager.overWriteExistingFiles());
        } else {
            FSDataInputStream in;
            if (linkPath != null) {
                in = HFileLink.buildFromHFileLinkPattern(this.conf, linkPath).open(this.fs);
            } else {
                linkPath = new Path(new Path(HRegion.getRegionDir(this.snapshotManifest.getSnapshotDir(), regionInfo.getEncodedName()), familyDir.getName()), hfileName);
                in = this.fs.open(linkPath);
            }
            FSDataOutputStream out = this.fs.create(outPath, this.snapshotFileManager.overWriteExistingFiles());
            IOUtils.copyBytes((InputStream)in, (OutputStream)out, (Configuration)this.conf);
        }
        String regionName = Bytes.toString((byte[])this.regionsMap.get(regionInfo.getEncodedNameAsBytes()));
        if (regionName == null) {
            regionName = regionInfo.getEncodedName();
        }
        LOG.debug("Restore reference " + regionName + " to " + clonedRegionName);
        Map<String, org.apache.hadoop.hbase.util.Pair<String, String>> map = this.parentsMap;
        synchronized (map) {
            org.apache.hadoop.hbase.util.Pair daughters = this.parentsMap.get(clonedRegionName);
            if (daughters == null) {
                daughters = new org.apache.hadoop.hbase.util.Pair((Object)regionName, (Object)regionName);
                this.parentsMap.put(clonedRegionName, (org.apache.hadoop.hbase.util.Pair<String, String>)daughters);
            } else if (!regionName.equals(daughters.getFirst())) {
                daughters.setSecond((Object)regionName);
            }
        }
        return outPath;
    }

    public RegionInfo cloneRegionInfo(RegionInfo snapshotRegionInfo) {
        return RestoreSnapshotHelper.cloneRegionInfo(this.tableDesc.getTableName(), snapshotRegionInfo);
    }

    public static RegionInfo cloneRegionInfo(TableName tableName, RegionInfo snapshotRegionInfo) {
        return RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(snapshotRegionInfo.getStartKey()).setEndKey(snapshotRegionInfo.getEndKey()).setSplit(snapshotRegionInfo.isSplit()).setRegionId(snapshotRegionInfo.getRegionId()).setOffline(snapshotRegionInfo.isOffline()).build();
    }

    private List<RegionInfo> getTableRegions() throws IOException {
        LOG.debug("get table regions: " + this.tableDir);
        FileStatus[] regionDirs = FSUtils.listStatus((FileSystem)this.fs, (Path)this.tableDir, (PathFilter)new FSUtils.RegionDirFilter(this.fs));
        if (regionDirs == null) {
            return null;
        }
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(regionDirs.length);
        for (int i = 0; i < regionDirs.length; ++i) {
            RegionInfo hri = HRegionFileSystem.loadRegionInfoFileContent(this.fs, regionDirs[i].getPath());
            regions.add(hri);
        }
        LOG.debug("found " + regions.size() + " regions for table=" + this.tableDesc.getTableName().getNameAsString());
        return regions;
    }

    public static RestoreMetaChanges copySnapshotForScanner(Configuration conf, FileSystem fs, Path rootDir, Path restoreDir, String snapshotName) throws IOException {
        if (!restoreDir.getFileSystem(conf).getUri().equals(rootDir.getFileSystem(conf).getUri())) {
            throw new IllegalArgumentException("Filesystems for restore directory and HBase root directory should be the same");
        }
        if (restoreDir.toUri().getPath().startsWith(rootDir.toUri().getPath() + "/")) {
            throw new IllegalArgumentException("Restore directory cannot be a sub directory of HBase root directory. RootDir: " + rootDir + ", restoreDir: " + restoreDir);
        }
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir(snapshotName, rootDir);
        SnapshotProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo(fs, snapshotDir);
        SnapshotManifest manifest = SnapshotManifest.open(conf, fs, snapshotDir, snapshotDesc);
        MonitoredTask status = TaskMonitor.get().createStatus("Restoring  snapshot '" + snapshotName + "' to directory " + restoreDir);
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher();
        RestoreSnapshotHelper helper = new RestoreSnapshotHelper(conf, fs, manifest, manifest.getTableDescriptor(), restoreDir, monitor, status, false);
        RestoreMetaChanges metaChanges = helper.restoreHdfsRegions().getRestoreMetaChanges();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restored table dir:" + restoreDir);
            FSUtils.logFileSystemState((FileSystem)fs, (Path)restoreDir, (Logger)LOG);
        }
        return metaChanges;
    }

    public static void restoreSnapshotAcl(SnapshotProtos.SnapshotDescription snapshot, TableName newTableName, Configuration conf) throws IOException {
        if (snapshot.hasUsersAndPermissions() && snapshot.getUsersAndPermissions() != null) {
            LOG.info("Restore snapshot acl to table. snapshot: " + snapshot + ", table: " + newTableName);
            ListMultimap perms = ShadedAccessControlUtil.toUserTablePermissions((AccessControlProtos.UsersAndPermissions)snapshot.getUsersAndPermissions());
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                for (Map.Entry e : perms.entries()) {
                    String user = (String)e.getKey();
                    TablePermission tablePerm = (TablePermission)e.getValue();
                    AccessControlClient.grant((Connection)conn, (TableName)newTableName, (String)user, (byte[])tablePerm.getFamily(), (byte[])tablePerm.getQualifier(), (Permission.Action[])tablePerm.getActions());
                }
            }
            catch (Throwable e) {
                throw new IOException("Grant acl into newly creatd table failed. snapshot: " + snapshot + ", table: " + newTableName, e);
            }
        }
    }

    public static class RestoreMetaChanges {
        private final Map<String, org.apache.hadoop.hbase.util.Pair<String, String>> parentsMap;
        private final TableDescriptor htd;
        private List<RegionInfo> regionsToRestore = null;
        private List<RegionInfo> regionsToRemove = null;
        private List<RegionInfo> regionsToAdd = null;

        public RestoreMetaChanges(TableDescriptor htd, Map<String, org.apache.hadoop.hbase.util.Pair<String, String>> parentsMap) {
            this.parentsMap = parentsMap;
            this.htd = htd;
        }

        public TableDescriptor getTableDescriptor() {
            return this.htd;
        }

        public Map<String, org.apache.hadoop.hbase.util.Pair<String, String>> getParentToChildrenPairMap() {
            return this.parentsMap;
        }

        public boolean hasRegionsToAdd() {
            return this.regionsToAdd != null && this.regionsToAdd.size() > 0;
        }

        public List<RegionInfo> getRegionsToAdd() {
            return this.regionsToAdd;
        }

        public boolean hasRegionsToRestore() {
            return this.regionsToRestore != null && this.regionsToRestore.size() > 0;
        }

        public List<RegionInfo> getRegionsToRestore() {
            return this.regionsToRestore;
        }

        public boolean hasRegionsToRemove() {
            return this.regionsToRemove != null && this.regionsToRemove.size() > 0;
        }

        public List<RegionInfo> getRegionsToRemove() {
            return this.regionsToRemove;
        }

        void setNewRegions(RegionInfo[] hris) {
            this.regionsToAdd = hris != null ? Arrays.asList(hris) : null;
        }

        void addRegionToRemove(RegionInfo hri) {
            if (this.regionsToRemove == null) {
                this.regionsToRemove = new LinkedList<RegionInfo>();
            }
            this.regionsToRemove.add(hri);
        }

        void addRegionToRestore(RegionInfo hri) {
            if (this.regionsToRestore == null) {
                this.regionsToRestore = new LinkedList<RegionInfo>();
            }
            this.regionsToRestore.add(hri);
        }

        public void updateMetaParentRegions(Connection connection, List<RegionInfo> regionInfos) throws IOException {
            if (regionInfos == null || this.parentsMap.isEmpty()) {
                return;
            }
            HashMap<String, RegionInfo> regionsByName = new HashMap<String, RegionInfo>(regionInfos.size());
            LinkedList<RegionInfo> parentRegions = new LinkedList<RegionInfo>();
            for (RegionInfo regionInfo : regionInfos) {
                if (regionInfo.isSplitParent()) {
                    parentRegions.add(regionInfo);
                    continue;
                }
                regionsByName.put(regionInfo.getEncodedName(), regionInfo);
            }
            for (RegionInfo regionInfo : parentRegions) {
                org.apache.hadoop.hbase.util.Pair<String, String> daughters = this.parentsMap.get(regionInfo.getEncodedName());
                if (daughters == null) {
                    LOG.warn("Skip update of unreferenced offline parent: " + regionInfo);
                    continue;
                }
                if (daughters.getSecond() == null) {
                    daughters.setSecond(daughters.getFirst());
                }
                LOG.debug("Update splits parent " + regionInfo.getEncodedName() + " -> " + daughters);
                MetaTableAccessor.addSplitsToParent((Connection)connection, (RegionInfo)regionInfo, (RegionInfo)((RegionInfo)regionsByName.get(daughters.getFirst())), (RegionInfo)((RegionInfo)regionsByName.get(daughters.getSecond())));
            }
        }
    }

    public static class RestoreFileChanges {
        private final Set<Pair<String, String>> familiesToDelete = new ConcurrentSkipListSet<Pair<String, String>>();
        private final Map<Pair<String, String>, Pair<Set<Path>, Set<Path>>> filesToAddAndDelete = new ConcurrentHashMap<Pair<String, String>, Pair<Set<Path>, Set<Path>>>();

        public void updateFamiliesToDelete(String region, String columnFamily) {
            Pair regionFamilyPair = Pair.of((Object)region, (Object)columnFamily);
            this.familiesToDelete.add((Pair<String, String>)regionFamilyPair);
        }

        public void updateFilesToAddAndDelete(String region, String columnFamily, Path path, boolean isAdd) {
            Pair key = Pair.of((Object)region, (Object)columnFamily);
            Pair existingPathsPair = this.filesToAddAndDelete.get(key);
            if (existingPathsPair == null) {
                existingPathsPair = Pair.of(new HashSet(), new HashSet());
                this.filesToAddAndDelete.put((Pair<String, String>)key, (Pair<Set<Path>, Set<Path>>)existingPathsPair);
            }
            if (isAdd) {
                ((Set)existingPathsPair.getLeft()).add(path);
            } else {
                ((Set)existingPathsPair.getRight()).add(path);
            }
        }

        public Set<Pair<String, String>> getFamiliesToDelete() {
            return this.familiesToDelete;
        }

        public Map<Pair<String, String>, Pair<Set<Path>, Set<Path>>> getFilesToAddAndDelete() {
            return this.filesToAddAndDelete;
        }
    }

    public static class RestoreChanges {
        private RestoreFileChanges restoreFileChanges;
        private RestoreMetaChanges restoreMetaChanges;

        public RestoreChanges(RestoreFileChanges restoreFileChanges, RestoreMetaChanges restoreMetaChanges) {
            this.restoreMetaChanges = restoreMetaChanges;
            this.restoreFileChanges = restoreFileChanges;
        }

        public RestoreFileChanges getRestoreFileChanges() {
            return this.restoreFileChanges;
        }

        public RestoreMetaChanges getRestoreMetaChanges() {
            return this.restoreMetaChanges;
        }
    }
}

