/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.AbstractStoreFilePathAccessor;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKStoreFilePathAccessor
extends AbstractStoreFilePathAccessor
implements Closeable {
    private ZKWatcher zookeeper;
    private final String storefileZNode;

    public ZKStoreFilePathAccessor(Configuration conf) throws IOException {
        super(conf);
        String storeFileZNodeParent = conf.get("zookeeper.znode.storefile", "storefile");
        this.storefileZNode = ZNodePaths.joinZNode((String)this.getZookeeper().getZNodePaths().baseZNode, (String)storeFileZNodeParent);
    }

    @Override
    public void initialize(MasterServices masterServices) throws IOException {
        ZKWatcher zkWatcher = masterServices.getZooKeeper();
        try {
            ZKUtil.createAndFailSilent((ZKWatcher)zkWatcher, (String)this.storefileZNode);
        }
        catch (KeeperException e) {
            throw new IOException("Failed to create ZNode " + this.storefileZNode, e);
        }
    }

    @Override
    public void updateIncludedAndExcludedStoreFilePaths(String tableName, String regionName, String storeName, Set<Path> storeFilePathsToAdd, Set<Path> storeFilePathsToDelete) throws IOException {
        throw new UnsupportedOperationException("Updating included and excluded storefile paths unsupported for ZK based file tracking");
    }

    @Override
    List<Path> getStoreFilePaths(String tableName, String regionName, String storeName, String zNodeName) throws IOException {
        ZKStoreFilePathAccessor.validate(tableName, regionName, storeName, zNodeName);
        String zNode = this.getKey(tableName, regionName, storeName, zNodeName);
        byte[] result = this.doGet(zNode);
        return ZKStoreFilePathAccessor.byteToStoreFileList(result);
    }

    @Override
    void writeStoreFilePaths(String tableName, String regionName, String storeName, String zNodeName, List<Path> storeFilePaths) throws IOException {
        ZKStoreFilePathAccessor.validate(tableName, regionName, storeName, zNodeName);
        if (zNodeName.equals("included")) {
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(storeFilePaths), (Object)"Storefile paths should not be empty when writing to included data set");
        }
        Preconditions.checkNotNull(storeFilePaths, (Object)"storeFilePaths cannot be null");
        String zNode = this.getKey(tableName, regionName, storeName, zNodeName);
        this.doCreateSetData(zNode, ZKStoreFilePathAccessor.storeFileListToByteArray(storeFilePaths));
    }

    @Override
    public void writeIncludedAndExcludedStoreFilePaths(String tableName, String regionName, String storeName, List<Path> includedStoreFilePaths, List<Path> excludedStoreFilePaths) throws IOException {
        this.writeStoreFilePaths(tableName, regionName, storeName, "included", includedStoreFilePaths);
        this.writeStoreFilePaths(tableName, regionName, storeName, "excluded", excludedStoreFilePaths);
    }

    @Override
    public void deleteStoreFilePaths(String tableName, String regionName, String storeName) throws IOException {
        ZKStoreFilePathAccessor.validate(tableName, regionName, storeName);
        String zNode = this.getKey(tableName, regionName, storeName);
        try {
            ZKUtil.deleteNodeRecursively((ZKWatcher)this.getZookeeper(), (String)ZNodePaths.joinZNode((String)this.storefileZNode, (String)zNode));
        }
        catch (KeeperException e) {
            throw new IOException("Failed to delete data from ZNode " + zNode, e);
        }
    }

    @Override
    public void deleteRegion(String tableName, String regionName) throws IOException {
        throw new UnsupportedOperationException("deleting region unsupported for ZK based file tracking");
    }

    @Override
    String getSeparator() {
        return "/";
    }

    private byte[] doGet(String zNode) throws IOException {
        try {
            return ZKUtil.getData((ZKWatcher)this.getZookeeper(), (String)ZNodePaths.joinZNode((String)this.storefileZNode, (String)zNode));
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Failed to get data from ZooKeeper ZNode " + zNode, e);
        }
    }

    private void doCreateSetData(String zNode, byte[] data) throws IOException {
        try {
            ZKUtil.createSetData((ZKWatcher)this.getZookeeper(), (String)ZNodePaths.joinZNode((String)this.storefileZNode, (String)zNode), (byte[])data);
        }
        catch (KeeperException e) {
            throw new IOException("Failed to set data for ZooKeeper ZNode " + zNode, e);
        }
    }

    private ZKWatcher getZookeeper() throws IOException {
        if (this.zookeeper == null) {
            this.zookeeper = new ZKWatcher(this.conf, "storefile" + System.currentTimeMillis(), null, false);
        }
        return this.zookeeper;
    }

    @Override
    public void close() throws IOException {
        if (this.zookeeper != null) {
            this.zookeeper.close();
        }
    }
}

