/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.HTableStoreFilePathAccessor;
import org.apache.hadoop.hbase.regionserver.PersistedStoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFilePathAccessor;
import org.apache.hadoop.hbase.regionserver.ZKStoreFilePathAccessor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StorefileTrackingUtils {
    private static Logger LOG = LoggerFactory.getLogger(StorefileTrackingUtils.class);
    public static final long SLEEP_DELTA_MS = TimeUnit.MILLISECONDS.toMillis(100L);
    public static final String STOREFILE_ZNODE = "zookeeper.znode.storefile";
    public static final String STOREFILE_TRACKING_LOADED = "loaded";

    public static boolean isStorefileTrackingPersistEnabled(Configuration conf) {
        boolean isFeatureEnabled;
        boolean isStoreTrackingPersistEnabled = conf.getBoolean("hbase.storefile.tracking.persist.enabled", false);
        boolean isPersistedStoreEngineSet = conf.get("hbase.hstore.engine.class", DefaultStoreEngine.class.getName()).equals(PersistedStoreEngine.class.getName());
        boolean bl = isFeatureEnabled = isStoreTrackingPersistEnabled && isPersistedStoreEngineSet;
        if (isStoreTrackingPersistEnabled ^ isPersistedStoreEngineSet) {
            String errorMessage = String.format("please set %s to true and set store engine key %s to %s to enable persist storefile tracking", "hbase.storefile.tracking.persist.enabled", "hbase.hstore.engine.class", PersistedStoreEngine.class.getName());
            throw new IllegalArgumentException(errorMessage);
        }
        return isFeatureEnabled;
    }

    public static void init(MasterServices masterServices) throws IOException {
        StorefileTrackingUtils.createStorefileTable(masterServices, masterServices.getConfiguration());
        StorefileTrackingUtils.waitForStoreFileTableOnline(masterServices);
    }

    public static void cleanup(MasterServices masterServices) throws IOException {
        try {
            ZKWatcher zkWatcher = masterServices.getZooKeeper();
            ZKUtil.deleteChildrenRecursively((ZKWatcher)zkWatcher, (String)StorefileTrackingUtils.getStoreFileLoadedRootZNode(zkWatcher, masterServices.getConfiguration()));
        }
        catch (KeeperException ex) {
            String message = "Failed cleanup of the StoreFileLoadedRootZNode's children";
            LOG.info("Failed cleanup of the StoreFileLoadedRootZNode's children");
            throw new IOException("Failed cleanup of the StoreFileLoadedRootZNode's children", ex);
        }
    }

    public static StoreFilePathAccessor createStoreFilePathAccessor(Configuration conf, Connection connection) {
        return new HTableStoreFilePathAccessor(conf, connection);
    }

    public static StoreFilePathAccessor createStoreFilePathAccessor(Configuration conf, TableName tableName, Connection connection) throws IOException {
        if (tableName.isMeta() || tableName.equals((Object)TableName.STOREFILE_TABLE_NAME)) {
            return new ZKStoreFilePathAccessor(conf);
        }
        return new HTableStoreFilePathAccessor(conf, connection);
    }

    public static List<Path> convertStoreFilesToPaths(Collection<HStoreFile> storeFiles) {
        return storeFiles.stream().map(HStoreFile::getPath).collect(Collectors.toList());
    }

    private static void createStorefileTable(MasterServices masterServices, Configuration conf) throws IOException {
        if (!MetaTableAccessor.tableExists((Connection)masterServices.getConnection(), (TableName)TableName.STOREFILE_TABLE_NAME)) {
            LOG.info("{} table not found. Creating...", (Object)TableName.STOREFILE_TABLE_NAME);
            byte[][] splitKeys = new RegionSplitter.UniformSplit().split(conf.getInt("hbase.storefile.tracking.region.count", 4));
            masterServices.createSystemTable(HTableStoreFilePathAccessor.STOREFILE_TABLE_DESC, splitKeys);
        }
    }

    private static void waitForStoreFileTableOnline(MasterServices masterServices) throws IOException {
        try {
            long startTime = EnvironmentEdgeManager.currentTime();
            long timeout = masterServices.getConfiguration().getLong("hbase.storefile.tracking.init.timeout", HConstants.DEFAULT_STOREFILE_TRACKING_INIT_TIMEOUT);
            while (!StorefileTrackingUtils.isStoreFileTableAssignedAndEnabled(masterServices)) {
                if (EnvironmentEdgeManager.currentTime() - startTime + SLEEP_DELTA_MS > timeout) {
                    throw new IOException("Time out " + timeout + " ms waiting for hbase:storefile table to be assigned and enabled: " + masterServices.getTableStateManager().getTableState(TableName.STOREFILE_TABLE_NAME));
                }
                Thread.sleep(SLEEP_DELTA_MS);
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted when wait for " + TableName.STOREFILE_TABLE_NAME + " to be assigned and enabled", e);
        }
    }

    @VisibleForTesting
    static boolean isStoreFileTableAssignedAndEnabled(MasterServices masterServices) throws IOException {
        return masterServices.getAssignmentManager().getRegionStates().hasTableRegionStates(TableName.STOREFILE_TABLE_NAME) && masterServices.getTableStateManager().getTableState(TableName.STOREFILE_TABLE_NAME).isEnabled();
    }

    public static Set<String> setTablesToUseStoreFileTracking(ZKWatcher zkWatcher, Configuration conf, Set<String> tableNames) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(tableNames), (Object)"Set of input table cannot be empty");
        ConcurrentSkipListSet<String> setTableNames = new ConcurrentSkipListSet<String>();
        tableNames.parallelStream().forEach(tableName -> {
            String storeFileLoadedZNode = StorefileTrackingUtils.getStoreFileLoadedLeafZNode(zkWatcher, conf, tableName);
            try {
                ZKUtil.createWithParents((ZKWatcher)zkWatcher, (String)storeFileLoadedZNode, (byte[])Bytes.toBytes((boolean)true));
                setTableNames.add((String)tableName);
            }
            catch (KeeperException e) {
                LOG.debug("Failed to set zNode " + storeFileLoadedZNode + ", will retry by the caller.", (Throwable)e);
            }
        });
        return setTableNames;
    }

    public static boolean getIfTableSetToUseStoreFileTracking(ZKWatcher zkWatcher, Configuration conf, String tableName) {
        boolean isLoaded = false;
        String storeFileLoadedZNode = StorefileTrackingUtils.getStoreFileLoadedLeafZNode(zkWatcher, conf, tableName);
        try {
            byte[] znodeBytes = ZKUtil.getData((ZKWatcher)zkWatcher, (String)storeFileLoadedZNode);
            isLoaded = znodeBytes == null ? false : Bytes.toBoolean((byte[])znodeBytes);
        }
        catch (Throwable t) {
            LOG.debug("Failed to get zNode " + storeFileLoadedZNode + " for using hbase:storefile  for region open of table " + tableName + ", return false to trigger refresh from file system", t);
        }
        return isLoaded;
    }

    public static boolean removeZNodeForDeletedTable(ZKWatcher zkWatcher, Configuration conf, String tableName) {
        boolean deleted = false;
        String storeFileLoadedZNode = StorefileTrackingUtils.getStoreFileLoadedLeafZNode(zkWatcher, conf, tableName);
        try {
            ZKUtil.deleteNode((ZKWatcher)zkWatcher, (String)storeFileLoadedZNode);
            deleted = true;
        }
        catch (Throwable t) {
            LOG.debug("Failed to delete zNode " + storeFileLoadedZNode + " for table " + tableName + ",  return false", t);
        }
        return deleted;
    }

    public static String getStoreFileLoadedRootZNode(ZKWatcher zkWatcher, Configuration conf) {
        String storeFileLoadedRootZNode = conf.get(STOREFILE_ZNODE, "storefile") + '/' + STOREFILE_TRACKING_LOADED;
        return ZNodePaths.joinZNode((String)zkWatcher.getZNodePaths().baseZNode, (String)storeFileLoadedRootZNode);
    }

    public static String getStoreFileLoadedLeafZNode(ZKWatcher zkWatcher, Configuration conf, String tableName) {
        return ZNodePaths.joinZNode((String)StorefileTrackingUtils.getStoreFileLoadedRootZNode(zkWatcher, conf), (String)tableName);
    }
}

