/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileManager;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFilePathAccessor;
import org.apache.hadoop.hbase.regionserver.StorefileTrackingUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionConfiguration;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableList;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSortedSet;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class PersistedStoreFileManager
extends DefaultStoreFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(PersistedStoreFileManager.class);
    private final RegionInfo regionInfo;
    private final String tableName;
    private final String regionName;
    private final String storeName;
    private StoreFilePathAccessor accessor;
    private Configuration conf;
    private boolean refreshFromFilesystem;
    private boolean hasRetriedOnFileNotFoundException;

    public PersistedStoreFileManager(CellComparator cellComparator, Comparator<HStoreFile> storeFileComparator, Configuration conf, CompactionConfiguration compactionConfiguration, HRegionFileSystem regionFs, RegionInfo regionInfo, String familyName, StoreFilePathAccessor accessor, boolean refreshFromFilesystem) throws IOException {
        super(cellComparator, storeFileComparator, conf, compactionConfiguration, regionFs, familyName);
        this.conf = conf;
        this.regionInfo = regionInfo;
        this.tableName = regionInfo.getTable().getNameAsString();
        this.regionName = regionInfo.getEncodedName();
        this.storeName = familyName;
        this.accessor = accessor;
        this.refreshFromFilesystem = refreshFromFilesystem;
        this.hasRetriedOnFileNotFoundException = false;
        this.init();
    }

    @VisibleForTesting
    public PersistedStoreFileManager(CellComparator cellComparator, Comparator<HStoreFile> storeFileComparator, Configuration conf, CompactionConfiguration compactionConfiguration, HRegionFileSystem regionFs, RegionInfo regionInfo, String familyName, StoreFilePathAccessor accessor) throws IOException {
        this(cellComparator, storeFileComparator, conf, compactionConfiguration, regionFs, regionInfo, familyName, accessor, false);
    }

    @VisibleForTesting
    void init() throws IOException {
        this.updateCompactedFilesToTracker(Collections.emptyList());
    }

    @Override
    public void loadFiles(List<HStoreFile> storeFiles) throws IOException {
        Preconditions.checkArgument((storeFiles != null ? 1 : 0) != 0, (Object)"store files cannot be null when loading");
        if (storeFiles.isEmpty()) {
            LOG.warn("Other than fresh region with no store files, store files should not be empty");
            return;
        }
        ImmutableList sortedStorefiles = ImmutableList.sortedCopyOf((Comparator)this.getStoreFileComparator(), storeFiles);
        this.setStorefiles((ImmutableList<HStoreFile>)sortedStorefiles);
        this.updateStoreFilesToTracker((List<HStoreFile>)sortedStorefiles);
    }

    @Override
    public Collection<StoreFileInfo> loadInitialFiles() throws IOException {
        List<Path> pathList = this.accessor.getIncludedStoreFilePaths(this.tableName, this.regionName, this.storeName);
        boolean isEmptyInPersistedFilePaths = CollectionUtils.isEmpty(pathList);
        if (isEmptyInPersistedFilePaths || this.refreshFromFilesystem) {
            LOG.info("Cannot find tracking paths ({}) or force refresh ({}) for store {} in region {} of table {}, fall back to scan the storage to get a list of storefiles to be opened", new Object[]{isEmptyInPersistedFilePaths, this.refreshFromFilesystem, this.storeName, this.regionName, this.tableName});
            return this.getRegionFs().getStoreFiles(this.getFamilyName());
        }
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>();
        try {
            for (Path storeFilePath : pathList) {
                if (!StoreFileInfo.isValid(this.getRegionFs().getFileSystem().getFileStatus(storeFilePath))) {
                    LOG.warn("Invalid StoreFile: {}", (Object)storeFilePath);
                    continue;
                }
                StoreFileInfo info = ServerRegionReplicaUtil.getStoreFileInfo(this.conf, this.getRegionFs().getFileSystem(), this.regionInfo, ServerRegionReplicaUtil.getRegionInfoForFs(this.regionInfo), this.getFamilyName(), storeFilePath);
                storeFiles.add(info);
            }
        }
        catch (FileNotFoundException fnfe) {
            if (this.hasRetriedOnFileNotFoundException) {
                throw new IOException("Retry once from the file system view for storeName " + this.storeName + " still failed.", fnfe);
            }
            this.refreshFromFilesystem = true;
            this.hasRetriedOnFileNotFoundException = true;
            return this.loadInitialFiles();
        }
        return storeFiles;
    }

    @Override
    public void insertNewFiles(Collection<HStoreFile> sfs) throws IOException {
        if (CollectionUtils.isEmpty(sfs)) {
            return;
        }
        ImmutableList storefiles = ImmutableList.sortedCopyOf((Comparator)this.getStoreFileComparator(), (Iterable)Iterables.concat(this.getStorefiles(), sfs));
        this.setStorefiles((ImmutableList<HStoreFile>)storefiles);
        this.updateStoreFilesToTracker((List<HStoreFile>)storefiles);
    }

    @Override
    public Collection<HStoreFile> clearCompactedFiles() throws IOException {
        Collection result = this.getCompactedfiles();
        ImmutableList emptyCompactedfiles = ImmutableList.of();
        this.setCompactedfiles((ImmutableList<HStoreFile>)emptyCompactedfiles);
        return result;
    }

    @Override
    public void addCompactionResults(Collection<HStoreFile> newCompactedfiles, Collection<HStoreFile> results) throws IOException {
        Preconditions.checkNotNull(newCompactedfiles, (Object)"compactedFiles cannot be null");
        Preconditions.checkNotNull(results, (Object)"compaction result cannot be null");
        ImmutableList storefiles = ImmutableList.sortedCopyOf((Comparator)this.getStoreFileComparator(), (Iterable)Iterables.concat((Iterable)Iterables.filter(this.getStorefiles(), sf -> !newCompactedfiles.contains(sf)), results)).asList();
        this.setStorefiles((ImmutableList<HStoreFile>)storefiles);
        ImmutableList compactedfiles = ImmutableSortedSet.copyOf((Comparator)this.getStoreFileComparator(), (Iterable)Iterables.concat((Iterable)this.getCompactedfiles(), newCompactedfiles)).asList();
        this.setCompactedfiles((ImmutableList<HStoreFile>)compactedfiles);
        this.updateStorefilesAndCompactedfilesToTracker((List<HStoreFile>)storefiles, (List<HStoreFile>)compactedfiles);
        newCompactedfiles.forEach(HStoreFile::markCompactedAway);
    }

    @Override
    public void removeCompactedFiles(Collection<HStoreFile> removedCompactedfiles) throws IOException {
        if (removedCompactedfiles != null) {
            ImmutableList compactedfiles = (ImmutableList)this.getCompactedfiles().stream().filter(sf -> !removedCompactedfiles.contains(sf)).sorted(this.getStoreFileComparator()).collect(ImmutableList.toImmutableList());
            if (!CollectionUtils.isEqualCollection((Collection)compactedfiles, (Collection)this.getCompactedfiles())) {
                this.updateCompactedFilesToTracker((List<HStoreFile>)compactedfiles);
            }
            this.setCompactedfiles((ImmutableList<HStoreFile>)compactedfiles);
        }
    }

    private void updateStorefilesAndCompactedfilesToTracker(List<HStoreFile> storeFiles, List<HStoreFile> compactedfiles) throws IOException {
        try {
            this.accessor.writeIncludedAndExcludedStoreFilePaths(this.tableName, this.regionName, this.storeName, StorefileTrackingUtils.convertStoreFilesToPaths(storeFiles), StorefileTrackingUtils.convertStoreFilesToPaths(compactedfiles));
        }
        catch (IOException e) {
            String message = "failed to update the Included and Exclude list of " + this.tableName + "-" + this.regionName + "-" + this.storeName + ", on " + "storefile" + ". The new files are not persistent and will be removed from " + this.regionName + "," + this.storeName + ".\nNew store files: " + storeFiles + " and new compacted files" + compactedfiles;
            LOG.warn(message);
            throw new IOException(message, e);
        }
    }

    private void updateStoreFilesToTracker(List<HStoreFile> storeFiles) throws IOException {
        try {
            this.accessor.writeIncludedStoreFilePaths(this.tableName, this.regionName, this.storeName, StorefileTrackingUtils.convertStoreFilesToPaths(storeFiles));
        }
        catch (IOException e) {
            String message = "failed to update the Included list of " + this.tableName + "-" + this.regionName + "-" + this.storeName + ", on " + "storefile" + ". The new files are not persistent and will be removed from " + this.regionName + "," + this.storeName + ".\nNew files: " + storeFiles;
            LOG.warn(message);
            throw new IOException(message, e);
        }
    }

    private void updateCompactedFilesToTracker(List<HStoreFile> storeFiles) throws IOException {
        try {
            this.accessor.writeExcludedStoreFilePaths(this.tableName, this.regionName, this.storeName, StorefileTrackingUtils.convertStoreFilesToPaths(storeFiles));
        }
        catch (IOException e) {
            String message = "failed to update the Excluded list of " + this.tableName + "-" + this.regionName + "-" + this.storeName + ", on " + "storefile" + ". These files won't be explicitly deleted by the StoreFileManager and may linger for longer than expected.\nPotentially lingering files: " + storeFiles;
            throw new IOException(message, e);
        }
    }
}

