/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.regionserver.DefaultStoreEngine;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFlusher;
import org.apache.hadoop.hbase.regionserver.DirectStoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.DirectStoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.PersistedStoreFileManager;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.StoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.StoreFileComparators;
import org.apache.hadoop.hbase.regionserver.StoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.StorefileTrackingUtils;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.regionserver.compactions.RatioBasedCompactionPolicy;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class PersistedStoreEngine
extends DefaultStoreEngine {
    private StoreFileWriterFactory storeFileWriterFactory;
    private StoreFileCommitter storeFileCommitter;

    @Override
    public void createComponents(Configuration conf, HStore store, CellComparator kvComparator) throws IOException {
        Preconditions.checkArgument((boolean)StorefileTrackingUtils.isStorefileTrackingPersistEnabled(conf));
        this.storeFileWriterFactory = new DirectStoreFileWriterFactory(store.getStoreContext(), conf);
        this.storeFileCommitter = new DirectStoreFileCommitter(store.getStoreContext());
        this.createCompactor(conf, store);
        this.createCompactionPolicy(conf, store);
        this.createStoreFlusher(conf, store);
        this.createStoreFileManager(conf, store, kvComparator);
    }

    @Override
    protected void createCompactor(Configuration conf, HStore store) throws IOException {
        this.compactor = new DefaultCompactor(conf, store, this.storeFileWriterFactory, this.storeFileCommitter);
    }

    @Override
    protected void createStoreFlusher(Configuration conf, HStore store) throws IOException {
        this.storeFlusher = new DefaultStoreFlusher(conf, store, this.storeFileWriterFactory, this.storeFileCommitter);
    }

    @Override
    protected void createStoreFileManager(Configuration conf, HStore store, CellComparator kvComparator) throws IOException {
        Connection connection = null;
        boolean refreshFromFileSystem = true;
        RegionServerServices regionServerServices = store.getHRegion().getRegionServerServices();
        if (regionServerServices != null) {
            connection = regionServerServices.getConnection();
            refreshFromFileSystem = !StorefileTrackingUtils.getIfTableSetToUseStoreFileTracking(regionServerServices.getZooKeeper(), conf, store.getTableName().getNameAsString());
        }
        this.storeFileManager = new PersistedStoreFileManager(kvComparator, StoreFileComparators.SEQ_ID, conf, ((RatioBasedCompactionPolicy)this.compactionPolicy).getConf(), store.getRegionFileSystem(), store.getRegionInfo(), store.getColumnFamilyName(), StorefileTrackingUtils.createStoreFilePathAccessor(conf, store.getTableName(), connection), refreshFromFileSystem);
    }
}

