/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemHelper;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class HRegionFileSystemSplitHandler {
    protected final Configuration conf;
    protected final FileSystem fs;
    protected final HRegionFileSystemHelper hrfsHelper;

    HRegionFileSystemSplitHandler(HRegionFileSystemHelper hrfsHelper) {
        this.hrfsHelper = hrfsHelper;
        this.fs = hrfsHelper.getFileSystem();
        this.conf = hrfsHelper.getConf();
    }

    abstract Path getSplitsDir(RegionInfo var1);

    abstract void cleanupSplitsDir() throws IOException;

    abstract void cleanupAnySplitDetritus() throws IOException;

    abstract Path commitDaughterRegion(RegionInfo var1) throws IOException;

    abstract void createSplitsDir(RegionInfo var1, RegionInfo var2) throws IOException;

    void cleanupDaughterRegion(RegionInfo regionInfo) throws IOException {
        Path regionDir = new Path(this.hrfsHelper.getTableDir(), regionInfo.getEncodedName());
        if (this.fs.exists(regionDir) && !this.hrfsHelper.deleteDir(regionDir)) {
            throw new IOException("Failed delete of " + regionDir);
        }
    }

    abstract Path writeReferenceFile(Reference var1, Path var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Path splitStoreFile(RegionInfo hri, String familyName, HStoreFile f, byte[] splitRow, boolean top, RegionSplitPolicy splitPolicy) throws IOException {
        block9: {
            block7: {
                block8: {
                    block6: {
                        block5: {
                            if (splitPolicy != null && splitPolicy.skipStoreFileRangeCheck(familyName)) break block9;
                            f.initReader();
                            try {
                                if (!top) ** GOTO lbl23
                                splitKey = PrivateCellUtil.createFirstOnRow((byte[])splitRow);
                                lastKey = f.getLastKey();
                                if (lastKey.isPresent()) break block5;
                                var9_9 = null;
                                f.closeStoreFile(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                            }
                            catch (Throwable var10_14) {
                                f.closeStoreFile(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                                throw var10_14;
                            }
                            return var9_9;
                        }
                        if (f.getComparator().compare(splitKey, lastKey.get()) <= 0) break block6;
                        var9_10 = null;
                        f.closeStoreFile(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                        return var9_10;
                    }
                    break block7;
lbl23:
                    // 1 sources

                    splitKey = PrivateCellUtil.createLastOnRow((byte[])splitRow);
                    firstKey = f.getFirstKey();
                    if (firstKey.isPresent()) break block8;
                    var9_11 = null;
                    f.closeStoreFile(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                    return var9_11;
                }
                if (f.getComparator().compare(splitKey, firstKey.get()) >= 0) break block7;
                var9_12 = null;
                f.closeStoreFile(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                return var9_12;
            }
            f.closeStoreFile(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
        }
        splitDir = new Path(this.getSplitsDir(hri), familyName);
        r = top != false ? Reference.createTopReference(splitRow) : Reference.createBottomReference(splitRow);
        parentRegionName = this.hrfsHelper.getRegionInfoForFS().getEncodedName();
        p = new Path(splitDir, f.getPath().getName() + "." + parentRegionName);
        return this.writeReferenceFile(r, p);
    }
}

