/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.regionserver.DefaultHRegionFileSystemMergeHandler;
import org.apache.hadoop.hbase.regionserver.DefaultHRegionFileSystemSplitHandler;
import org.apache.hadoop.hbase.regionserver.DirectInsertHRegionFileSystemMergeHandler;
import org.apache.hadoop.hbase.regionserver.DirectInsertHRegionFileSystemSplitHandler;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemHelper;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemMergeHandler;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemSplitHandler;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.StorefileTrackingUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HRegionFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(HRegionFileSystem.class);
    public static final String REGION_INFO_FILE = ".regioninfo";
    public static final String REGION_MERGES_DIR = ".merges";
    public static final String REGION_SPLITS_DIR = ".splits";
    @VisibleForTesting
    static final String REGION_TEMP_DIR = ".tmp";
    private final RegionInfo regionInfo;
    final RegionInfo regionInfoForFs;
    final Configuration conf;
    private final Path tableDir;
    final FileSystem fs;
    private final Path regionDir;
    private final HRegionFileSystemHelper hrfsHelper;
    private final HRegionFileSystemSplitHandler splitHandler;
    private final HRegionFileSystemMergeHandler mergeHandler;

    HRegionFileSystem(Configuration conf, FileSystem fs, Path tableDir, RegionInfo regionInfo) {
        this.fs = fs;
        this.conf = conf;
        this.tableDir = Objects.requireNonNull(tableDir, "tableDir is null");
        this.regionInfo = Objects.requireNonNull(regionInfo, "regionInfo is null");
        this.regionInfoForFs = ServerRegionReplicaUtil.getRegionInfoForFs(regionInfo);
        this.regionDir = FSUtils.getRegionDirFromTableDir(tableDir, regionInfo);
        this.hrfsHelper = new HRegionFileSystemHelper(conf, fs, tableDir, this.regionDir, regionInfo, this.regionInfoForFs);
        boolean isDirectInsert = StorefileTrackingUtils.isStorefileTrackingPersistEnabled(conf);
        this.splitHandler = isDirectInsert ? new DirectInsertHRegionFileSystemSplitHandler(this.hrfsHelper) : new DefaultHRegionFileSystemSplitHandler(this.hrfsHelper);
        this.mergeHandler = isDirectInsert ? new DirectInsertHRegionFileSystemMergeHandler(this.hrfsHelper) : new DefaultHRegionFileSystemMergeHandler(this.hrfsHelper);
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public RegionInfo getRegionInfoForFS() {
        return this.regionInfoForFs;
    }

    public Path getTableDir() {
        return this.tableDir;
    }

    public Path getRegionDir() {
        return this.regionDir;
    }

    @VisibleForTesting
    public Path getTempDir() {
        return this.hrfsHelper.getTempDir();
    }

    void cleanupTempDir() throws IOException {
        this.hrfsHelper.deleteDir(this.getTempDir());
    }

    public Path getStoreDir(String familyName) {
        return new Path(this.getRegionDir(), familyName);
    }

    Path createStoreDir(String familyName) throws IOException {
        Path storeDir = this.getStoreDir(familyName);
        if (!this.fs.exists(storeDir) && !this.createDir(storeDir)) {
            throw new IOException("Failed creating " + storeDir);
        }
        return storeDir;
    }

    public void setStoragePolicy(String familyName, String policyName) {
        FSUtils.setStoragePolicy((FileSystem)this.fs, (Path)this.getStoreDir(familyName), (String)policyName);
    }

    @Nullable
    public String getStoragePolicyName(String familyName) {
        if (this.fs instanceof HFileSystem) {
            Path storeDir = this.getStoreDir(familyName);
            return ((HFileSystem)this.fs).getStoragePolicyName(storeDir);
        }
        return null;
    }

    public Collection<StoreFileInfo> getStoreFiles(byte[] familyName) throws IOException {
        return this.getStoreFiles(Bytes.toString((byte[])familyName));
    }

    public Collection<StoreFileInfo> getStoreFiles(String familyName) throws IOException {
        return this.getStoreFiles(familyName, true);
    }

    public Collection<StoreFileInfo> getStoreFiles(String familyName, boolean validate) throws IOException {
        Path familyDir = this.getStoreDir(familyName);
        FileStatus[] files = FSUtils.listStatus((FileSystem)this.fs, (Path)familyDir);
        if (files == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No StoreFiles for: " + familyDir);
            }
            return null;
        }
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(files.length);
        for (FileStatus status : files) {
            if (validate && !StoreFileInfo.isValid(status)) {
                LOG.warn("Invalid StoreFile: " + status.getPath());
                continue;
            }
            StoreFileInfo info = ServerRegionReplicaUtil.getStoreFileInfo(this.conf, this.fs, this.regionInfo, this.regionInfoForFs, familyName, status.getPath());
            storeFiles.add(info);
        }
        return storeFiles;
    }

    public static List<LocatedFileStatus> getStoreFilesLocatedStatus(HRegionFileSystem regionfs, String familyName, boolean validate) throws IOException {
        Path familyDir = regionfs.getStoreDir(familyName);
        List locatedFileStatuses = FSUtils.listLocatedStatus((FileSystem)regionfs.getFileSystem(), (Path)familyDir);
        if (locatedFileStatuses == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No StoreFiles for: " + familyDir);
            }
            return null;
        }
        ArrayList validStoreFiles = Lists.newArrayList();
        for (LocatedFileStatus status : locatedFileStatuses) {
            if (validate && !StoreFileInfo.isValid((FileStatus)status)) {
                LOG.warn("Invalid StoreFile: " + status.getPath());
                continue;
            }
            validStoreFiles.add(status);
        }
        return validStoreFiles;
    }

    Path getStoreFilePath(String familyName, String fileName) {
        Path familyDir = this.getStoreDir(familyName);
        return new Path(familyDir, fileName).makeQualified(this.fs.getUri(), this.fs.getWorkingDirectory());
    }

    StoreFileInfo getStoreFileInfo(String familyName, String fileName) throws IOException {
        Path familyDir = this.getStoreDir(familyName);
        return ServerRegionReplicaUtil.getStoreFileInfo(this.conf, this.fs, this.regionInfo, this.regionInfoForFs, familyName, new Path(familyDir, fileName));
    }

    public boolean hasReferences(String familyName) throws IOException {
        Path storeDir = this.getStoreDir(familyName);
        FileStatus[] files = FSUtils.listStatus((FileSystem)this.fs, (Path)storeDir);
        if (files != null) {
            for (FileStatus stat : files) {
                if (stat.isDirectory() || !StoreFileInfo.isReference(stat.getPath())) continue;
                LOG.trace("Reference {}", (Object)stat.getPath());
                return true;
            }
        }
        return false;
    }

    public boolean hasReferences(TableDescriptor htd) throws IOException {
        for (ColumnFamilyDescriptor family : htd.getColumnFamilies()) {
            if (!this.hasReferences(family.getNameAsString())) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getFamilies() throws IOException {
        FileStatus[] fds = FSUtils.listStatus((FileSystem)this.fs, (Path)this.getRegionDir(), (PathFilter)new FSUtils.FamilyDirFilter(this.fs));
        if (fds == null) {
            return null;
        }
        ArrayList<String> families = new ArrayList<String>(fds.length);
        for (FileStatus status : fds) {
            families.add(status.getPath().getName());
        }
        return families;
    }

    public void deleteFamily(String familyName) throws IOException {
        HFileArchiver.archiveFamily(this.fs, this.conf, this.regionInfoForFs, this.tableDir, Bytes.toBytes((String)familyName));
        Path familyDir = this.getStoreDir(familyName);
        if (this.fs.exists(familyDir) && !this.deleteDir(familyDir)) {
            throw new IOException("Could not delete family " + familyName + " from FileSystem for region " + this.regionInfoForFs.getRegionNameAsString() + "(" + this.regionInfoForFs.getEncodedName() + ")");
        }
    }

    public Path createTempName() {
        return this.createTempName(null);
    }

    public Path createTempName(String suffix) {
        return new Path(this.getTempDir(), StoreUtils.generateUniqueName(suffix));
    }

    public Path commitStoreFile(String familyName, Path buildPath) throws IOException {
        Path dstPath = this.preCommitStoreFile(familyName, buildPath, -1L, false);
        return this.commitStoreFile(buildPath, dstPath);
    }

    private Path preCommitStoreFile(String familyName, Path buildPath, long seqNum, boolean generateNewName) throws IOException {
        Path storeDir = this.getStoreDir(familyName);
        if (!this.fs.exists(storeDir) && !this.createDir(storeDir)) {
            throw new IOException("Failed creating " + storeDir);
        }
        String name = buildPath.getName();
        if (generateNewName) {
            name = StoreUtils.generateUniqueName(seqNum < 0L ? null : "_SeqId_" + seqNum + "_");
        }
        Path dstPath = new Path(storeDir, name);
        if (!this.fs.exists(buildPath)) {
            throw new FileNotFoundException(buildPath.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Committing " + buildPath + " as " + dstPath);
        }
        return dstPath;
    }

    Path commitStoreFile(Path buildPath, Path dstPath) throws IOException {
        if (!this.rename(buildPath, dstPath)) {
            throw new IOException("Failed rename of " + buildPath + " to " + dstPath);
        }
        return dstPath;
    }

    public void removeStoreFile(String familyName, Path filePath) throws IOException {
        HFileArchiver.archiveStoreFile(this.conf, this.fs, this.regionInfoForFs, this.tableDir, Bytes.toBytes((String)familyName), filePath);
    }

    public void removeStoreFiles(String familyName, Collection<HStoreFile> storeFiles) throws IOException {
        HFileArchiver.archiveStoreFiles(this.conf, this.fs, this.regionInfoForFs, this.tableDir, Bytes.toBytes((String)familyName), storeFiles);
    }

    Pair<Path, Path> bulkLoadStoreFile(String familyName, Path srcPath, long seqNum) throws IOException {
        FileSystem desFs;
        FileSystem srcFs = srcPath.getFileSystem(this.conf);
        srcPath = srcFs.resolvePath(srcPath);
        FileSystem realSrcFs = srcPath.getFileSystem(this.conf);
        FileSystem fileSystem = desFs = this.fs instanceof HFileSystem ? ((HFileSystem)this.fs).getBackingFs() : this.fs;
        if (!FSHDFSUtils.isSameHdfs(this.conf, realSrcFs, desFs)) {
            LOG.info("Bulk-load file " + srcPath + " is on different filesystem than the destination store. Copying file over to destination filesystem.");
            Path tmpPath = this.createTempName();
            FileUtil.copy((FileSystem)realSrcFs, (Path)srcPath, (FileSystem)this.fs, (Path)tmpPath, (boolean)false, (Configuration)this.conf);
            LOG.info("Copied " + srcPath + " to temporary path on destination filesystem: " + tmpPath);
            srcPath = tmpPath;
        }
        return new Pair((Object)srcPath, (Object)this.preCommitStoreFile(familyName, srcPath, seqNum, true));
    }

    public Path getSplitsDir(RegionInfo hri) {
        return this.splitHandler.getSplitsDir(hri);
    }

    void cleanupSplitsDir() throws IOException {
        this.splitHandler.cleanupSplitsDir();
    }

    void cleanupAnySplitDetritus() throws IOException {
        this.splitHandler.cleanupAnySplitDetritus();
    }

    @VisibleForTesting
    void cleanupDaughterRegion(RegionInfo regionInfo) throws IOException {
        this.splitHandler.cleanupDaughterRegion(regionInfo);
    }

    public Path commitDaughterRegion(RegionInfo regionInfo) throws IOException {
        return this.splitHandler.commitDaughterRegion(regionInfo);
    }

    public void createSplitsDir(RegionInfo daughterA, RegionInfo daughterB) throws IOException {
        this.splitHandler.createSplitsDir(daughterA, daughterB);
    }

    public Path splitStoreFile(RegionInfo hri, String familyName, HStoreFile f, byte[] splitRow, boolean top, RegionSplitPolicy splitPolicy) throws IOException {
        return this.splitHandler.splitStoreFile(hri, familyName, f, splitRow, top, splitPolicy);
    }

    public Path getMergesDir() {
        return this.mergeHandler.getMergesDir();
    }

    void cleanupMergesDir() throws IOException {
        this.mergeHandler.cleanupMergesDir();
    }

    public void cleanupMergedRegion(RegionInfo mergedRegion) throws IOException {
        this.mergeHandler.cleanupMergedRegion(mergedRegion);
    }

    public void createMergesDir() throws IOException {
        this.mergeHandler.createMergesDir();
    }

    public Path mergeStoreFile(RegionInfo mergedRegion, String familyName, HStoreFile f, Path mergedDir) throws IOException {
        return this.mergeHandler.mergeStoreFile(mergedRegion, familyName, f, mergedDir);
    }

    public void commitMergedRegion(RegionInfo mergedRegionInfo) throws IOException {
        this.mergeHandler.commitMergedRegion(mergedRegionInfo);
    }

    void logFileSystemState(Logger LOG) throws IOException {
        FSUtils.logFileSystemState((FileSystem)this.fs, (Path)this.getRegionDir(), (Logger)LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegionInfo loadRegionInfoFileContent(FileSystem fs, Path regionDir) throws IOException {
        try (FSDataInputStream in = fs.open(new Path(regionDir, REGION_INFO_FILE));){
            RegionInfo regionInfo = RegionInfo.parseFrom((DataInputStream)in);
            return regionInfo;
        }
    }

    void checkRegionInfoOnFilesystem() throws IOException {
        this.hrfsHelper.checkRegionInfoOnFilesystem();
    }

    void writeRegionInfoOnFilesystem(boolean useTempDir) throws IOException {
        this.hrfsHelper.writeRegionInfoOnFilesystem(useTempDir);
    }

    public static HRegionFileSystem createRegionOnFileSystem(Configuration conf, FileSystem fs, Path tableDir, RegionInfo regionInfo) throws IOException {
        return HRegionFileSystemHelper.createRegionOnFileSystem(conf, fs, tableDir, regionInfo);
    }

    public static HRegionFileSystem openRegionFromFileSystem(Configuration conf, FileSystem fs, Path tableDir, RegionInfo regionInfo, boolean readOnly) throws IOException {
        return HRegionFileSystemHelper.openRegionFromFileSystem(conf, fs, tableDir, regionInfo, readOnly);
    }

    public static void deleteRegionFromFileSystem(Configuration conf, FileSystem fs, Path tableDir, RegionInfo regionInfo) throws IOException {
        HRegionFileSystemHelper.deleteRegionFromFileSystem(conf, fs, tableDir, regionInfo);
    }

    boolean createDir(Path dir) throws IOException {
        return this.hrfsHelper.createDir(dir);
    }

    boolean rename(Path srcpath, Path dstPath) throws IOException {
        return this.hrfsHelper.rename(srcpath, dstPath);
    }

    boolean deleteDir(Path dir) throws IOException {
        return this.hrfsHelper.deleteDir(dir);
    }

    static boolean mkdirs(FileSystem fs, Configuration conf, Path dir) throws IOException {
        return HRegionFileSystemHelper.mkdirs(fs, conf, dir);
    }
}

