/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.DefaultHRegionFileSystemSplitHandler;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemHelper;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DirectInsertHRegionFileSystemSplitHandler
extends DefaultHRegionFileSystemSplitHandler {
    public DirectInsertHRegionFileSystemSplitHandler(HRegionFileSystemHelper hrfsHelper) {
        super(hrfsHelper);
    }

    @Override
    protected Path getSplitsDir() {
        return this.hrfsHelper.getRegionDir();
    }

    @Override
    public Path getSplitsDir(RegionInfo hri) {
        return new Path(this.hrfsHelper.getTableDir(), hri.getEncodedName());
    }

    @Override
    public void cleanupSplitsDir() {
    }

    @Override
    public void cleanupAnySplitDetritus() throws IOException {
    }

    @Override
    public Path commitDaughterRegion(RegionInfo regionInfo) throws IOException {
        Path daughterRegionDir = this.getSplitsDir(regionInfo);
        if (this.fs.exists(daughterRegionDir)) {
            Path regionInfoFile = new Path(daughterRegionDir, ".regioninfo");
            byte[] regionInfoContent = HRegionFileSystemHelper.getRegionInfoFileContent(regionInfo);
            HRegionFileSystemHelper.writeRegionInfoFileContent(this.conf, this.fs, regionInfoFile, regionInfoContent);
        }
        return daughterRegionDir;
    }

    @Override
    public void createSplitsDir(RegionInfo daughterA, RegionInfo daughterB) throws IOException {
        Path daughterARegionDir = this.getSplitsDir(daughterA);
        if (!this.hrfsHelper.createDir(daughterARegionDir)) {
            throw new IOException("Failed create of " + daughterARegionDir);
        }
        Path daughterBRegionDir = this.getSplitsDir(daughterB);
        if (!this.hrfsHelper.createDir(daughterBRegionDir)) {
            this.hrfsHelper.deleteDir(daughterARegionDir);
            throw new IOException("Failed create of " + daughterBRegionDir);
        }
    }

    @Override
    Path writeReferenceFile(Reference r, Path path) throws IOException {
        return r.write(this.fs, path, true);
    }
}

