/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.DefaultStoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.StoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriterFactory;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultStoreFlusher
extends StoreFlusher {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStoreFlusher.class);
    private final Object flushLock = new Object();

    public DefaultStoreFlusher(Configuration conf, HStore store, StoreFileWriterFactory storeFileWriterFactory, StoreFileCommitter storeFileCommitter) {
        super(conf, store, storeFileWriterFactory, storeFileCommitter);
    }

    public DefaultStoreFlusher(Configuration conf, HStore store) {
        this(conf, store, new DefaultStoreFileWriterFactory(store.getStoreContext(), conf), new DefaultStoreFileCommitter(store.getStoreContext()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushId, MonitoredTask status, ThroughputController throughputController, FlushLifeCycleTracker tracker) throws IOException {
        StoreFileWriter writer;
        ArrayList<Path> result = new ArrayList<Path>();
        int cellsCount = snapshot.getCellsCount();
        if (cellsCount == 0) {
            return result;
        }
        long smallestReadPoint = this.store.getSmallestReadPoint();
        try (InternalScanner scanner = this.createScanner(snapshot.getScanners(), smallestReadPoint, tracker);){
            Object object = this.flushLock;
            synchronized (object) {
                status.setStatus("Flushing " + this.store + ": creating writer");
                writer = this.createWriter(snapshot);
                IOException e = null;
                try {
                    this.performFlush(scanner, writer, smallestReadPoint, throughputController);
                }
                catch (IOException ioe) {
                    e = ioe;
                    throw ioe;
                }
                finally {
                    if (e != null) {
                        writer.close();
                    } else {
                        this.finalizeWriter(writer, cacheFlushId, status);
                    }
                }
            }
        }
        LOG.info("Flushed memstore data size={} at sequenceid={} (bloomFilter={}), to={}", new Object[]{StringUtils.byteDesc((long)snapshot.getDataSize()), cacheFlushId, writer.hasGeneralBloom(), writer.getPath()});
        result.add(writer.getPath());
        return result;
    }
}

