/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileCommitter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultStoreFileCommitter
implements StoreFileCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStoreFileCommitter.class);
    private final HStoreContext storeContext;
    private final HRegionFileSystem regionFileSystem;
    private final Path storeDirectory;

    public DefaultStoreFileCommitter(HStoreContext storeContext) {
        this.storeContext = storeContext;
        this.regionFileSystem = storeContext.getRegionFileSystem();
        this.storeDirectory = storeContext.getStoreDirectory();
    }

    private boolean isExpectedPath(Path path) {
        return path.getParent().equals((Object)new Path(this.regionFileSystem.getTempDir(), this.storeContext.getFamily().getNameAsString()));
    }

    private Path preCommitStoreFile(Path buildPath, long seqNum, boolean generateNewName) throws IOException {
        if (!this.regionFileSystem.getFileSystem().exists(buildPath)) {
            throw new FileNotFoundException(buildPath.toString());
        }
        if (!this.regionFileSystem.getFileSystem().exists(this.storeDirectory) && !this.regionFileSystem.createDir(this.storeDirectory)) {
            throw new IOException("Failed creating " + this.storeDirectory);
        }
        String name = buildPath.getName();
        if (generateNewName) {
            name = StoreUtils.generateUniqueName(seqNum < 0L ? null : "_SeqId_" + seqNum + "_");
        }
        Path dstPath = new Path(this.storeDirectory, name);
        LOG.debug("Committing " + buildPath + " as " + dstPath);
        return dstPath;
    }

    @Override
    public Path commitStoreFile(Path buildPath, long seqNum, boolean generateNewName) throws IOException {
        assert (this.isExpectedPath(buildPath)) : "Unexpected storefile path" + buildPath;
        Path dstPath = this.preCommitStoreFile(buildPath, seqNum, generateNewName);
        if (!this.regionFileSystem.rename(buildPath, dstPath)) {
            throw new IOException("Failed rename of " + buildPath + " to " + dstPath);
        }
        return dstPath;
    }
}

