/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemHelper;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemSplitHandler;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DefaultHRegionFileSystemSplitHandler
extends HRegionFileSystemSplitHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHRegionFileSystemSplitHandler.class);

    DefaultHRegionFileSystemSplitHandler(HRegionFileSystemHelper commonHfsHelper) {
        super(commonHfsHelper);
    }

    Path getSplitsDir() {
        return new Path(this.hrfsHelper.getRegionDir(), ".splits");
    }

    @Override
    Path getSplitsDir(RegionInfo hri) {
        return new Path(this.getSplitsDir(), hri.getEncodedName());
    }

    @Override
    void cleanupSplitsDir() throws IOException {
        this.hrfsHelper.deleteDir(this.getSplitsDir());
    }

    @Override
    void cleanupAnySplitDetritus() throws IOException {
        Path splitdir = this.getSplitsDir();
        if (!this.fs.exists(splitdir)) {
            return;
        }
        FileStatus[] daughters = FSUtils.listStatus((FileSystem)this.fs, (Path)splitdir, (PathFilter)new FSUtils.DirFilter(this.fs));
        if (daughters != null) {
            for (FileStatus daughter : daughters) {
                Path daughterDir = new Path(this.hrfsHelper.getTableDir(), daughter.getPath().getName());
                if (!this.fs.exists(daughterDir) || this.hrfsHelper.deleteDir(daughterDir)) continue;
                throw new IOException("Failed delete of " + daughterDir);
            }
        }
        this.cleanupSplitsDir();
        LOG.info("Cleaned up old failed split transaction detritus: " + splitdir);
    }

    @Override
    Path commitDaughterRegion(RegionInfo regionInfo) throws IOException {
        Path regionDir = new Path(this.hrfsHelper.getTableDir(), regionInfo.getEncodedName());
        Path daughterTmpDir = this.getSplitsDir(regionInfo);
        if (this.fs.exists(daughterTmpDir)) {
            Path regionInfoFile = new Path(daughterTmpDir, ".regioninfo");
            byte[] regionInfoContent = HRegionFileSystemHelper.getRegionInfoFileContent(regionInfo);
            HRegionFileSystemHelper.writeRegionInfoFileContent(this.conf, this.fs, regionInfoFile, regionInfoContent);
            if (!this.hrfsHelper.rename(daughterTmpDir, regionDir)) {
                throw new IOException("Unable to rename " + daughterTmpDir + " to " + regionDir);
            }
        }
        return regionDir;
    }

    @Override
    void createSplitsDir(RegionInfo daughterA, RegionInfo daughterB) throws IOException {
        Path splitdir = this.getSplitsDir();
        if (this.fs.exists(splitdir)) {
            LOG.info("The " + splitdir + " directory exists.  Hence deleting it to recreate it");
            if (!this.hrfsHelper.deleteDir(splitdir)) {
                throw new IOException("Failed deletion of " + splitdir + " before creating them again.");
            }
        }
        if (!this.hrfsHelper.createDir(splitdir)) {
            throw new IOException("Failed create of " + splitdir);
        }
        Path daughterATmpDir = this.getSplitsDir(daughterA);
        if (!this.hrfsHelper.createDir(daughterATmpDir)) {
            throw new IOException("Failed create of " + daughterATmpDir);
        }
        Path daughterBTmpDir = this.getSplitsDir(daughterB);
        if (!this.hrfsHelper.createDir(daughterBTmpDir)) {
            throw new IOException("Failed create of " + daughterBTmpDir);
        }
    }

    @Override
    Path writeReferenceFile(Reference r, Path path) throws IOException {
        return r.write(this.fs, path, false);
    }
}

