/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemHelper;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystemMergeHandler;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class DefaultHRegionFileSystemMergeHandler
extends HRegionFileSystemMergeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHRegionFileSystemMergeHandler.class);

    DefaultHRegionFileSystemMergeHandler(HRegionFileSystemHelper hrfsHelper) {
        super(hrfsHelper);
    }

    @Override
    Path getMergesDir() {
        return new Path(this.hrfsHelper.getRegionDir(), ".merges");
    }

    @Override
    void cleanupMergesDir() throws IOException {
        this.hrfsHelper.deleteDir(this.getMergesDir());
    }

    @Override
    void createMergesDir() throws IOException {
        Path mergesdir = this.getMergesDir();
        if (this.fs.exists(mergesdir)) {
            LOG.info("{} directory exists. Deleting it to recreate it anew", (Object)mergesdir);
            if (!this.fs.delete(mergesdir, true)) {
                throw new IOException("Failed deletion of " + mergesdir + " before recreate.");
            }
        }
        if (!HRegionFileSystemHelper.mkdirs(this.fs, this.conf, mergesdir)) {
            throw new IOException("Failed create of " + mergesdir);
        }
    }

    @Override
    void commitMergedRegion(RegionInfo mergedRegionInfo) throws IOException {
        Path mergedRegionDir = new Path(this.hrfsHelper.getTableDir(), mergedRegionInfo.getEncodedName());
        Path mergedRegionTmpDir = this.getMergesDir(mergedRegionInfo);
        if (mergedRegionTmpDir != null && this.fs.exists(mergedRegionTmpDir) && !this.fs.rename(mergedRegionTmpDir, mergedRegionDir)) {
            throw new IOException("Unable to rename " + mergedRegionTmpDir + " to " + mergedRegionDir);
        }
    }
}

