/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.regionserver.HStoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreFileWriterFactory;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
abstract class AbstractStoreFileWriterFactory
implements StoreFileWriterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStoreFileWriterFactory.class);
    protected final HStoreContext storeContext;
    private final Configuration conf;
    private boolean cacheOnWriteLogged;

    AbstractStoreFileWriterFactory(HStoreContext storeContext, Configuration conf) {
        this.storeContext = storeContext;
        this.conf = conf;
        this.cacheOnWriteLogged = false;
    }

    protected abstract Path getWriterPath();

    @Override
    public StoreFileWriter createWriter(long maxKeyCount, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag, boolean shouldDropBehind) throws IOException {
        return this.createWriter(maxKeyCount, isCompaction, includeMVCCReadpoint, includesTag, shouldDropBehind, -1L);
    }

    @Override
    public StoreFileWriter createWriter(long maxKeyCount, boolean isCompaction, boolean includeMVCCReadpoint, boolean includesTag, boolean shouldDropBehind, long totalCompactedFilesSize) throws IOException {
        Compression.Algorithm compression;
        CacheConfig cacheConf = this.storeContext.getCacheConf();
        CacheConfig writerCacheConf = new CacheConfig(cacheConf);
        if (isCompaction) {
            boolean cacheCompactedBlocksOnWrite = cacheConf.shouldCacheCompactedBlocksOnWrite();
            if (cacheCompactedBlocksOnWrite && totalCompactedFilesSize <= cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For Store {} , cacheCompactedBlocksOnWrite is true, hence enabled cacheOnWrite for Data blocks, Index blocks and Bloom filter blocks", (Object)this.storeContext.getFamily().getNameAsString());
                    this.cacheOnWriteLogged = true;
                }
            } else {
                writerCacheConf.setCacheDataOnWrite(false);
                if (totalCompactedFilesSize > cacheConf.getCacheCompactedBlocksOnWriteThreshold()) {
                    LOG.debug("For Store {}, setting cacheCompactedBlocksOnWrite as false as total size of compacted files - {}, is greater than cacheCompactedBlocksOnWriteThreshold - {}", new Object[]{this.storeContext.getFamily().getNameAsString(), totalCompactedFilesSize, cacheConf.getCacheCompactedBlocksOnWriteThreshold()});
                }
            }
            compression = this.storeContext.getFamily().getCompactionCompressionType();
        } else {
            boolean shouldCacheDataOnWrite = cacheConf.shouldCacheDataOnWrite();
            if (shouldCacheDataOnWrite) {
                writerCacheConf.enableCacheOnWrite();
                if (!this.cacheOnWriteLogged) {
                    LOG.info("For Store {} , cacheDataOnWrite is true, hence enabled cacheOnWrite for Index blocks and Bloom filter blocks", (Object)this.storeContext.getFamily().getNameAsString());
                    this.cacheOnWriteLogged = true;
                }
            }
            compression = this.storeContext.getFamily().getCompressionType();
        }
        HFileContext hFileContext = this.createFileContext(compression, includeMVCCReadpoint, includesTag);
        StoreFileWriter.Builder builder = new StoreFileWriter.Builder(this.conf, writerCacheConf, this.storeContext.getRegionFileSystem().getFileSystem()).withOutputDir(this.getWriterPath()).withComparator(this.storeContext.getComparator()).withBloomType(this.storeContext.getBloomFilterType()).withMaxKeyCount(maxKeyCount).withFavoredNodes(this.storeContext.getFavoredNodesSupplier().get()).withFileContext(hFileContext).withShouldDropCacheBehind(shouldDropBehind).withCompactedFilesSupplier(this.storeContext.getCompactedFilesSupplier());
        return builder.build();
    }

    private HFileContext createFileContext(Compression.Algorithm compression, boolean includeMVCCReadpoint, boolean includesTag) {
        if (compression == null) {
            compression = HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        HFileContext fileContext = this.storeContext.getDefaultFileContext();
        fileContext.setIncludesMvcc(includeMVCCReadpoint);
        fileContext.setIncludesTags(includesTag);
        fileContext.setCompression(compression);
        fileContext.setFileCreateTime(EnvironmentEdgeManager.currentTime());
        return fileContext;
    }
}

