/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.StoreFilePathAccessor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractStoreFilePathAccessor
implements StoreFilePathAccessor {
    public static final String STOREFILE_INCLUDED_STR = "included";
    public static final String STOREFILE_EXCLUDED_STR = "excluded";
    protected static final String LIST_SEPARATOR = ";";
    protected final Configuration conf;

    public AbstractStoreFilePathAccessor(Configuration conf) {
        this.conf = conf;
    }

    abstract String getSeparator();

    abstract void writeStoreFilePaths(String var1, String var2, String var3, String var4, List<Path> var5) throws IOException;

    abstract List<Path> getStoreFilePaths(String var1, String var2, String var3, String var4) throws IOException;

    @Override
    public void writeIncludedStoreFilePaths(String tableName, String regionName, String storeName, List<Path> storeFilePaths) throws IOException {
        this.writeStoreFilePaths(tableName, regionName, storeName, STOREFILE_INCLUDED_STR, storeFilePaths);
    }

    @Override
    public void writeExcludedStoreFilePaths(String tableName, String regionName, String storeName, List<Path> storeFilePaths) throws IOException {
        this.writeStoreFilePaths(tableName, regionName, storeName, STOREFILE_EXCLUDED_STR, storeFilePaths);
    }

    @Override
    public List<Path> getIncludedStoreFilePaths(String tableName, String regionName, String storeName) throws IOException {
        return this.getStoreFilePaths(tableName, regionName, storeName, STOREFILE_INCLUDED_STR);
    }

    @Override
    public List<Path> getExcludedStoreFilePaths(String tableName, String regionName, String storeName) throws IOException {
        return this.getStoreFilePaths(tableName, regionName, storeName, STOREFILE_EXCLUDED_STR);
    }

    protected static byte[] storeFileListToByteArray(List<Path> storeFilePaths) {
        return Bytes.toBytes((String)Joiner.on((String)LIST_SEPARATOR).join(storeFilePaths));
    }

    protected static List<Path> byteToStoreFileList(byte[] data) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (data != null && data.length != 0) {
            String[] pathStrings;
            String pathString = Bytes.toString((byte[])data);
            for (String path : pathStrings = pathString.split(LIST_SEPARATOR)) {
                paths.add(new Path(path));
            }
        }
        return paths;
    }

    protected String getFamilyFromKey(String key) {
        return key.split(this.getSeparator())[2];
    }

    protected String getRegionFromKey(String key) {
        return key.split(this.getSeparator())[1];
    }

    protected String getRegionPrefixForKey(String tableName, String regionName) {
        return Joiner.on((String)this.getSeparator()).join(Arrays.asList(tableName, regionName));
    }

    protected String getTablePrefixForKey(String tableName) {
        return Joiner.on((String)this.getSeparator()).join(Arrays.asList(tableName));
    }

    protected String getKey(String tableName, String regionName, String storeName) {
        return Joiner.on((String)this.getSeparator()).join((Object)tableName, (Object)regionName, new Object[]{storeName});
    }

    protected String getKey(String tableName, String regionName, String storeName, String columnName) {
        return Joiner.on((String)this.getSeparator()).join((Object)tableName, (Object)regionName, new Object[]{storeName, columnName});
    }

    protected static void validate(String tableName, String regionName, String storeName, String columnName) {
        AbstractStoreFilePathAccessor.validate(tableName, regionName, storeName);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)columnName), (Object)"column name cannot be null or empty");
    }

    protected static void validate(String tableName, String regionName, String storeName) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tableName), (Object)"table name cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)regionName), (Object)"region name cannot be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)storeName), (Object)"store name cannot be null or empty");
    }
}

