/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.cleaner.BaseHFileCleanerDelegate;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ManualMobMaintHFileCleaner
extends BaseHFileCleanerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(ManualMobMaintHFileCleaner.class);
    private static final ConcurrentMap<TableName, String> MOB_REGIONS = new ConcurrentHashMap<TableName, String>();

    @Override
    public boolean isFileDeletable(FileStatus fStat) {
        try {
            boolean ret;
            if (fStat.isDirectory()) {
                return true;
            }
            Path file = fStat.getPath();
            Path family = file.getParent();
            Path region = family.getParent();
            Path table = region.getParent();
            TableName tableName = FSUtils.getTableName((Path)table);
            String mobRegion = (String)MOB_REGIONS.get(tableName);
            if (mobRegion == null) {
                String tmp = MobUtils.getMobRegionInfo(tableName).getEncodedName();
                if (tmp == null) {
                    LOG.error("couldn't determine mob region for table {} keeping files just in case.", (Object)tableName);
                    return false;
                }
                mobRegion = MOB_REGIONS.putIfAbsent(tableName, tmp);
                if (mobRegion == null) {
                    mobRegion = tmp;
                }
                LOG.debug("Had to calculate name of mob region for table {} and it is {}", (Object)tableName, (Object)mobRegion);
            }
            boolean bl = ret = !mobRegion.equals(region.getName());
            if (LOG.isDebugEnabled() && !ret) {
                LOG.debug("Keeping file '{}' because it is from mob dir", (Object)fStat.getPath());
            }
            return ret;
        }
        catch (RuntimeException e) {
            LOG.error("Failed to determine mob status of '{}', keeping it just in case.", (Object)fStat.getPath(), (Object)e);
            return false;
        }
    }
}

