/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileManager;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DefaultSnapshotFileManager
implements SnapshotFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSnapshotFileManager.class);

    private final boolean isExpectedPath(MasterFileSystem masterFileSystem, Path path, TableName destinationTableName) {
        return path.equals((Object)FSUtils.getTableDir((Path)this.getWorkingCloneRootDirectory(masterFileSystem), (TableName)destinationTableName));
    }

    @Override
    public Path getWorkingCloneRootDirectory(MasterFileSystem masterFileSystem) {
        return masterFileSystem.getTempDir();
    }

    @Override
    public void commitClone(MasterFileSystem masterFileSystem, TableName destinationTableName, Path workingCloneTableDir) throws IOException {
        assert (this.isExpectedPath(masterFileSystem, workingCloneTableDir, destinationTableName)) : "Unexpected directory path " + workingCloneTableDir;
        Path tableDir = FSUtils.getTableDir((Path)masterFileSystem.getRootDir(), (TableName)destinationTableName);
        FileSystem fs = masterFileSystem.getFileSystem();
        if (!fs.delete(tableDir, true) && fs.exists(tableDir)) {
            throw new IOException("Couldn't delete " + tableDir);
        }
        if (!fs.rename(workingCloneTableDir, tableDir)) {
            throw new IOException("Unable to move table from temp=" + workingCloneTableDir + " to table dir=" + tableDir);
        }
        Path tempMobTableDir = MobUtils.getMobTableDir(this.getWorkingCloneRootDirectory(masterFileSystem), destinationTableName);
        if (masterFileSystem.getFileSystem().exists(tempMobTableDir)) {
            this.moveTempMobDirectoryToHBaseRoot(masterFileSystem, destinationTableName, tempMobTableDir);
        }
    }

    private void moveTempMobDirectoryToHBaseRoot(MasterFileSystem mfs, TableName destinationTableName, Path tempMobTableDir) throws IOException {
        Path tableMobDir;
        FileSystem fs = mfs.getFileSystem();
        if (!fs.delete(tableMobDir = MobUtils.getMobTableDir(mfs.getRootDir(), destinationTableName), true) && fs.exists(tableMobDir)) {
            throw new IOException("Couldn't delete mob table " + tableMobDir);
        }
        if (!fs.exists(tableMobDir.getParent())) {
            fs.mkdirs(tableMobDir.getParent());
        }
        if (!fs.rename(tempMobTableDir, tableMobDir)) {
            throw new IOException("Unable to move mob table from temp=" + tempMobTableDir + " to hbase root=" + tableMobDir);
        }
    }

    @Override
    public void commitRestore(String destinationTableName, RestoreSnapshotHelper.RestoreFileChanges fileChanges, RestoreSnapshotHelper.RestoreMetaChanges restoreMetaChanges) throws IOException {
        LOG.info("commitRestore is a no-op for the DefaultSnapshotFileManager");
    }

    @Override
    public void close() throws IOException {
        LOG.info("No-op");
    }
}

