/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MultiHConnection {
    private static final Logger LOG = LoggerFactory.getLogger(MultiHConnection.class);
    private Connection[] connections;
    private final Object connectionsLock = new Object();
    private final int noOfConnections;
    private ExecutorService batchPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiHConnection(Configuration conf, int noOfConnections) throws IOException {
        this.noOfConnections = noOfConnections;
        Object object = this.connectionsLock;
        synchronized (object) {
            this.connections = new Connection[noOfConnections];
            for (int i = 0; i < noOfConnections; ++i) {
                Connection conn;
                this.connections[i] = conn = ConnectionFactory.createConnection((Configuration)conf);
            }
        }
        this.createBatchPool(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.connectionsLock;
        synchronized (object) {
            if (this.connections != null) {
                for (Connection conn : this.connections) {
                    if (conn == null) continue;
                    try {
                        conn.close();
                    }
                    catch (IOException e) {
                        LOG.info("Got exception in closing connection", (Throwable)e);
                    }
                    finally {
                        conn = null;
                    }
                }
                this.connections = null;
            }
        }
        if (this.batchPool != null && !this.batchPool.isShutdown()) {
            this.batchPool.shutdown();
            try {
                if (!this.batchPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.batchPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.batchPool.shutdownNow();
            }
        }
    }

    public <R> void processBatchCallback(List<? extends Row> actions, TableName tableName, Object[] results, Batch.Callback<R> callback) throws IOException {
        ClusterConnection conn = (ClusterConnection)this.connections[ThreadLocalRandom.current().nextInt(this.noOfConnections)];
        HTable.doBatchWithCallback(actions, (Object[])results, callback, (ClusterConnection)conn, (ExecutorService)this.batchPool, (TableName)tableName);
    }

    private void createBatchPool(Configuration conf) {
        int maxThreads = conf.getInt("hbase.multihconnection.threads.max", 256);
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = conf.getLong("hbase.multihconnection.threads.keepalivetime", 60L);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * conf.getInt("hbase.client.max.total.tasks", 100));
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(maxThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)"MultiHConnection-shared-"));
        tpe.allowCoreThreadTimeOut(true);
        this.batchPool = tpe;
    }
}

