/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.nio.ByteBuffer;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.MultiByteBuff;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.BloomFilterChunk;
import org.apache.hadoop.hbase.util.BloomFilterUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Hash;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestBloomFilterChunk
extends TestCase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBloomFilterChunk.class);

    public void testBasicBloom() throws Exception {
        BloomFilterChunk bf1 = new BloomFilterChunk(1000, (double)0.01f, 1, 0);
        BloomFilterChunk bf2 = new BloomFilterChunk(1000, (double)0.01f, 1, 0);
        bf1.allocBloom();
        bf2.allocBloom();
        byte[] key1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] key2 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 7};
        bf1.add(key1, 0, key1.length);
        bf2.add(key2, 0, key2.length);
        TestBloomFilterChunk.assertTrue((boolean)BloomFilterUtil.contains((byte[])key1, (int)0, (int)key1.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bf1.bloom}), (int)0, (int)((int)bf1.byteSize), (Hash)bf1.hash, (int)bf1.hashCount));
        TestBloomFilterChunk.assertFalse((boolean)BloomFilterUtil.contains((byte[])key2, (int)0, (int)key2.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bf1.bloom}), (int)0, (int)((int)bf1.byteSize), (Hash)bf1.hash, (int)bf1.hashCount));
        TestBloomFilterChunk.assertFalse((boolean)BloomFilterUtil.contains((byte[])key1, (int)0, (int)key1.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bf2.bloom}), (int)0, (int)((int)bf2.byteSize), (Hash)bf2.hash, (int)bf2.hashCount));
        TestBloomFilterChunk.assertTrue((boolean)BloomFilterUtil.contains((byte[])key2, (int)0, (int)key2.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bf2.bloom}), (int)0, (int)((int)bf2.byteSize), (Hash)bf2.hash, (int)bf2.hashCount));
        byte[] bkey = new byte[]{1, 2, 3, 4};
        byte[] bval = "this is a much larger byte array".getBytes();
        bf1.add(bkey, 0, bkey.length);
        bf1.add(bval, 1, bval.length - 1);
        TestBloomFilterChunk.assertTrue((boolean)BloomFilterUtil.contains((byte[])bkey, (int)0, (int)bkey.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bf1.bloom}), (int)0, (int)((int)bf1.byteSize), (Hash)bf1.hash, (int)bf1.hashCount));
        TestBloomFilterChunk.assertTrue((boolean)BloomFilterUtil.contains((byte[])bval, (int)1, (int)(bval.length - 1), (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bf1.bloom}), (int)0, (int)((int)bf1.byteSize), (Hash)bf1.hash, (int)bf1.hashCount));
        TestBloomFilterChunk.assertFalse((boolean)BloomFilterUtil.contains((byte[])bval, (int)0, (int)bval.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bf1.bloom}), (int)0, (int)((int)bf1.byteSize), (Hash)bf1.hash, (int)bf1.hashCount));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        bf1.writeBloom((DataOutput)new DataOutputStream(bOut));
        ByteBuffer bb = ByteBuffer.wrap(bOut.toByteArray());
        BloomFilterChunk newBf1 = new BloomFilterChunk(1000, (double)0.01f, 1, 0);
        TestBloomFilterChunk.assertTrue((boolean)BloomFilterUtil.contains((byte[])key1, (int)0, (int)key1.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bb}), (int)0, (int)((int)newBf1.byteSize), (Hash)newBf1.hash, (int)newBf1.hashCount));
        TestBloomFilterChunk.assertFalse((boolean)BloomFilterUtil.contains((byte[])key2, (int)0, (int)key2.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bb}), (int)0, (int)((int)newBf1.byteSize), (Hash)newBf1.hash, (int)newBf1.hashCount));
        TestBloomFilterChunk.assertTrue((boolean)BloomFilterUtil.contains((byte[])bkey, (int)0, (int)bkey.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bb}), (int)0, (int)((int)newBf1.byteSize), (Hash)newBf1.hash, (int)newBf1.hashCount));
        TestBloomFilterChunk.assertTrue((boolean)BloomFilterUtil.contains((byte[])bval, (int)1, (int)(bval.length - 1), (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bb}), (int)0, (int)((int)newBf1.byteSize), (Hash)newBf1.hash, (int)newBf1.hashCount));
        TestBloomFilterChunk.assertFalse((boolean)BloomFilterUtil.contains((byte[])bval, (int)0, (int)bval.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bb}), (int)0, (int)((int)newBf1.byteSize), (Hash)newBf1.hash, (int)newBf1.hashCount));
        TestBloomFilterChunk.assertFalse((boolean)BloomFilterUtil.contains((byte[])bval, (int)0, (int)bval.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{bb}), (int)0, (int)((int)newBf1.byteSize), (Hash)newBf1.hash, (int)newBf1.hashCount));
        System.out.println("Serialized as " + bOut.size() + " bytes");
        TestBloomFilterChunk.assertTrue(((long)bOut.size() - bf1.byteSize < 10L ? 1 : 0) != 0);
    }

    public void testBloomFold() throws Exception {
        BloomFilterChunk b = new BloomFilterChunk(1003, (double)0.01f, 1, 2);
        b.allocBloom();
        long origSize = b.getByteSize();
        TestBloomFilterChunk.assertEquals((long)1204L, (long)origSize);
        for (int i = 0; i < 12; ++i) {
            byte[] ib = Bytes.toBytes((int)i);
            b.add(ib, 0, ib.length);
        }
        b.compactBloom();
        TestBloomFilterChunk.assertEquals((long)(origSize >> 2), (long)b.getByteSize());
        int falsePositives = 0;
        for (int i = 0; i < 25; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            if (BloomFilterUtil.contains((byte[])bytes, (int)0, (int)bytes.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{b.bloom}), (int)0, (int)((int)b.byteSize), (Hash)b.hash, (int)b.hashCount)) {
                if (i < 12) continue;
                ++falsePositives;
                continue;
            }
            TestBloomFilterChunk.assertFalse((i < 12 ? 1 : 0) != 0);
        }
        TestBloomFilterChunk.assertTrue((falsePositives <= 1 ? 1 : 0) != 0);
    }

    public void testBloomPerf() throws Exception {
        float err = 0.01f;
        BloomFilterChunk b = new BloomFilterChunk(10000000, (double)err, 1, 3);
        b.allocBloom();
        long startTime = System.currentTimeMillis();
        long origSize = b.getByteSize();
        for (int i = 0; i < 1000000; ++i) {
            byte[] ib = Bytes.toBytes((int)i);
            b.add(ib, 0, ib.length);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("Total Add time = " + (endTime - startTime) + "ms");
        startTime = System.currentTimeMillis();
        b.compactBloom();
        endTime = System.currentTimeMillis();
        System.out.println("Total Fold time = " + (endTime - startTime) + "ms");
        TestBloomFilterChunk.assertTrue((origSize >= b.getByteSize() << 3 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        int falsePositives = 0;
        for (int i = 0; i < 2000000; ++i) {
            byte[] bytes = Bytes.toBytes((int)i);
            if (BloomFilterUtil.contains((byte[])bytes, (int)0, (int)bytes.length, (ByteBuff)new MultiByteBuff(new ByteBuffer[]{b.bloom}), (int)0, (int)((int)b.byteSize), (Hash)b.hash, (int)b.hashCount)) {
                if (i < 1000000) continue;
                ++falsePositives;
                continue;
            }
            TestBloomFilterChunk.assertFalse((i < 1000000 ? 1 : 0) != 0);
        }
        endTime = System.currentTimeMillis();
        System.out.println("Total Contains time = " + (endTime - startTime) + "ms");
        System.out.println("False Positive = " + falsePositives);
        TestBloomFilterChunk.assertTrue(((float)falsePositives <= 1000000.0f * err ? 1 : 0) != 0);
    }

    public void testSizing() {
        int bitSize = 0x100000;
        double errorRate = 0.025;
        long maxKeys = BloomFilterUtil.idealMaxKeys((long)bitSize, (double)errorRate);
        TestBloomFilterChunk.assertEquals((long)136570L, (long)maxKeys);
        long bitSize2 = BloomFilterUtil.computeBitSize((long)maxKeys, (double)errorRate);
        TestBloomFilterChunk.assertTrue(((double)Math.abs(bitSize2 - (long)bitSize) * 1.0 / (double)bitSize < 1.0E-5 ? 1 : 0) != 0);
    }

    public void testFoldableByteSize() {
        TestBloomFilterChunk.assertEquals((int)128, (int)BloomFilterUtil.computeFoldableByteSize((long)1000L, (int)5));
        TestBloomFilterChunk.assertEquals((int)640, (int)BloomFilterUtil.computeFoldableByteSize((long)5001L, (int)4));
    }
}

