/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.snapshot.MobSnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestRestoreSnapshotHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestMobRestoreSnapshotHelper
extends TestRestoreSnapshotHelper {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMobRestoreSnapshotHelper.class);
    final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @Override
    protected void setupConf(Configuration conf) {
        conf.setInt("hbase.mob.file.cache.size", 0);
    }

    @Override
    protected MobSnapshotTestingUtils.SnapshotMock createSnapshotMock() throws IOException {
        return new MobSnapshotTestingUtils.SnapshotMock(TEST_UTIL.getConfiguration(), this.fs, this.rootDir);
    }

    @Override
    protected void createTableAndSnapshot(TableName tableName, String snapshotName) throws IOException {
        byte[] column = Bytes.toBytes((String)"A");
        Table table = MobSnapshotTestingUtils.createMobTable(TEST_UTIL, tableName, (byte[][])new byte[][]{column});
        TEST_UTIL.loadTable(table, column);
        TEST_UTIL.getAdmin().snapshot(snapshotName, tableName);
    }
}

