/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationSourceDummy;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.regionserver.TestReplicationSourceManager;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationSourceManagerZkImpl
extends TestReplicationSourceManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationSourceManagerZkImpl.class);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = HBaseConfiguration.create();
        conf.set("replication.replicationsource.implementation", ReplicationSourceDummy.class.getCanonicalName());
        conf.setLong("replication.sleep.before.failover", 2000L);
        conf.setInt("replication.source.maxretriesmultiplier", 10);
        utility = new HBaseTestingUtility(conf);
        utility.startMiniZKCluster();
        TestReplicationSourceManagerZkImpl.setupZkAndReplication();
    }

    @Test
    public void testNodeFailoverDeadServerParsing() throws Exception {
        TestReplicationSourceManager.DummyServer server = new TestReplicationSourceManager.DummyServer("ec2-54-234-230-108.compute-1.amazonaws.com");
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)server.getZooKeeper(), (Configuration)conf);
        files.add("log1");
        files.add("log2");
        for (String file : files) {
            queueStorage.addWAL(server.getServerName(), "1", file);
        }
        TestReplicationSourceManager.DummyServer s1 = new TestReplicationSourceManager.DummyServer("ip-10-8-101-114.ec2.internal");
        TestReplicationSourceManager.DummyServer s2 = new TestReplicationSourceManager.DummyServer("ec2-107-20-52-47.compute-1.amazonaws.com");
        TestReplicationSourceManager.DummyServer s3 = new TestReplicationSourceManager.DummyServer("ec2-23-20-187-167.compute-1.amazonaws.com");
        ServerName serverName = server.getServerName();
        List unclaimed = queueStorage.getAllQueues(serverName);
        queueStorage.claimQueue(serverName, (String)unclaimed.get(0), s1.getServerName());
        queueStorage.removeReplicatorIfQueueIsEmpty(serverName);
        serverName = s1.getServerName();
        unclaimed = queueStorage.getAllQueues(serverName);
        queueStorage.claimQueue(serverName, (String)unclaimed.get(0), s2.getServerName());
        queueStorage.removeReplicatorIfQueueIsEmpty(serverName);
        serverName = s2.getServerName();
        unclaimed = queueStorage.getAllQueues(serverName);
        String queue3 = (String)queueStorage.claimQueue(serverName, (String)unclaimed.get(0), s3.getServerName()).getFirst();
        queueStorage.removeReplicatorIfQueueIsEmpty(serverName);
        ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(queue3);
        List result = replicationQueueInfo.getDeadRegionServers();
        Assert.assertTrue((boolean)result.contains(server.getServerName()));
        Assert.assertTrue((boolean)result.contains(s1.getServerName()));
        Assert.assertTrue((boolean)result.contains(s2.getServerName()));
        server.stop("");
    }
}

