/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionServerRegionSpaceUseReport {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerRegionSpaceUseReport.class);

    @Test
    public void testConversion() {
        TableName tn = TableName.valueOf((String)"table1");
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build();
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"b")).setEndKey(Bytes.toBytes((String)"c")).build();
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"c")).setEndKey(Bytes.toBytes((String)"d")).build();
        HashMap<RegionInfo, Long> sizes = new HashMap<RegionInfo, Long>();
        sizes.put(hri1, 0x100000L);
        sizes.put(hri2, 0x800000L);
        sizes.put(hri3, 0x2000000L);
        HRegionServer rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).buildRegionSpaceUseReportRequest((Map)Matchers.any());
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).convertRegionSize((RegionInfo)Matchers.any(), Long.valueOf(Matchers.anyLong()));
        RegionServerStatusProtos.RegionSpaceUseReportRequest requests = rs.buildRegionSpaceUseReportRequest(sizes);
        Assert.assertEquals((long)sizes.size(), (long)requests.getSpaceUseCount());
        for (RegionServerStatusProtos.RegionSpaceUse spaceUse : requests.getSpaceUseList()) {
            RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)spaceUse.getRegionInfo());
            Long expectedSize = (Long)sizes.remove(hri);
            Assert.assertNotNull((String)("Could not find size for HRI: " + hri), (Object)expectedSize);
            Assert.assertEquals((long)expectedSize, (long)spaceUse.getRegionSize());
        }
        Assert.assertTrue((String)("Should not have any space use entries left: " + sizes), (boolean)sizes.isEmpty());
    }

    @Test(expected=NullPointerException.class)
    public void testNullMap() {
        HRegionServer rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).buildRegionSpaceUseReportRequest((Map)Matchers.any());
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).convertRegionSize((RegionInfo)Matchers.any(), Long.valueOf(Matchers.anyLong()));
        rs.buildRegionSpaceUseReportRequest(null);
    }

    @Test(expected=NullPointerException.class)
    public void testMalformedMap() {
        TableName tn = TableName.valueOf((String)"table1");
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build();
        HashMap<RegionInfo, Object> sizes = new HashMap<RegionInfo, Object>();
        sizes.put(hri1, null);
        HRegionServer rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).buildRegionSpaceUseReportRequest((Map)Matchers.any());
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).convertRegionSize((RegionInfo)Matchers.any(), Long.valueOf(Matchers.anyLong()));
        rs.buildRegionSpaceUseReportRequest(sizes);
    }
}

