/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SecureBulkLoadClient;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.ActivePolicyEnforcement;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RegionServerSpaceQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceLimitingException;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicyEnforcement;
import org.apache.hadoop.hbase.quotas.policies.DefaultViolationPolicyEnforcement;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class})
public class TestSpaceQuotas {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSpaceQuotas.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSpaceQuotas.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private static final int NUM_RETRIES = 10;
    @Rule
    public TestName testName = new TestName();
    private SpaceQuotaHelperForTests helper;
    private final TableName NON_EXISTENT_TABLE = TableName.valueOf((String)"NON_EXISTENT_TABLE");

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void removeAllQuotas() throws Exception {
        Connection conn = TEST_UTIL.getConnection();
        if (this.helper == null) {
            this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        }
        if (!conn.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            this.helper.waitForQuotaTable(conn);
        } else {
            this.helper.removeAllQuotas(conn);
            Assert.assertEquals((long)0L, (long)this.helper.listNumDefinedQuotas(conn));
        }
    }

    @Test
    public void testNoInsertsWithPut() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_INSERTS, (Mutation)p);
    }

    @Test
    public void testNoInsertsWithAppend() throws Exception {
        Append a = new Append(Bytes.toBytes((String)"to_reject"));
        a.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_INSERTS, (Mutation)a);
    }

    @Test
    public void testNoInsertsWithIncrement() throws Exception {
        Increment i = new Increment(Bytes.toBytes((String)"to_reject"));
        i.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"count"), 0L);
        this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_INSERTS, (Mutation)i);
    }

    @Test
    public void testDeletesAfterNoInserts() throws Exception {
        TableName tn = this.writeUntilViolation(SpaceViolationPolicy.NO_INSERTS);
        Delete d = new Delete(Bytes.toBytes((String)"should_not_be_rejected"));
        for (int i = 0; i < 10; ++i) {
            try (Table t = TEST_UTIL.getConnection().getTable(tn);){
                t.delete(d);
                continue;
            }
        }
    }

    @Test
    public void testNoWritesWithPut() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)p);
    }

    @Test
    public void testNoWritesWithAppend() throws Exception {
        Append a = new Append(Bytes.toBytes((String)"to_reject"));
        a.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)a);
    }

    @Test
    public void testNoWritesWithIncrement() throws Exception {
        Increment i = new Increment(Bytes.toBytes((String)"to_reject"));
        i.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"count"), 0L);
        this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)i);
    }

    @Test
    public void testNoWritesWithDelete() throws Exception {
        Delete d = new Delete(Bytes.toBytes((String)"to_reject"));
        this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)d);
    }

    @Test
    public void testNoCompactions() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES_COMPACTIONS, (Mutation)p);
        try {
            TEST_UTIL.getAdmin().majorCompact(tn);
            Assert.fail((String)"Expected that invoking the compaction should throw an Exception");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
        try {
            TEST_UTIL.getAdmin().compact(tn);
            Assert.fail((String)"Expected that invoking the compaction should throw an Exception");
        }
        catch (DoNotRetryIOException doNotRetryIOException) {
            // empty catch block
        }
    }

    @Test
    public void testNoEnableAfterDisablePolicy() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.writeUntilViolation(SpaceViolationPolicy.DISABLE);
        Admin admin = TEST_UTIL.getAdmin();
        for (int i = 0; i < 20; ++i) {
            if (!admin.isTableEnabled(tn)) continue;
            LOG.info(tn + " is still enabled, expecting it to be disabled. Will wait and re-check.");
            Thread.sleep(2000L);
        }
        Assert.assertFalse((String)(tn + " is still enabled but it should be disabled"), (boolean)admin.isTableEnabled(tn));
        try {
            admin.enableTable(tn);
        }
        catch (AccessDeniedException e) {
            String exceptionContents = StringUtils.stringifyException((Throwable)e);
            String expectedText = "violated space quota";
            Assert.assertTrue((String)("Expected the exception to contain violated space quota, but was: " + exceptionContents), (boolean)exceptionContents.contains("violated space quota"));
        }
    }

    @Test
    public void testNoBulkLoadsWithNoWrites() throws Exception {
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tableName = this.writeUntilViolationAndVerifyViolation(SpaceViolationPolicy.NO_WRITES, (Mutation)p);
        ClientServiceCallable<Void> callable = this.generateFileToLoad(tableName, 1, 50);
        RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(TEST_UTIL.getConfiguration());
        RpcRetryingCaller caller = factory.newCaller();
        try {
            caller.callWithRetries(callable, Integer.MAX_VALUE);
            Assert.fail((String)"Expected the bulk load call to fail!");
        }
        catch (SpaceLimitingException e) {
            LOG.trace("Caught expected exception", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAtomicBulkLoadUnderQuota() throws Exception {
        FileStatus[] files;
        SpaceQuotaSnapshot snapshot;
        TableName tn = this.helper.createTableWithRegions(10);
        long sizeLimit = 51200L;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)51200L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS);
        TEST_UTIL.getAdmin().setQuota(settings);
        HRegionServer rs = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0);
        RegionServerSpaceQuotaManager spaceQuotaManager = rs.getRegionServerSpaceQuotaManager();
        Map snapshots = spaceQuotaManager.copyQuotaSnapshots();
        Map<RegionInfo, Long> regionSizes = this.getReportedSizesForTable(tn);
        while ((snapshot = (SpaceQuotaSnapshot)snapshots.get(tn)) == null || snapshot.getLimit() <= 0L) {
            LOG.debug("Snapshot does not yet realize quota limit: " + snapshots + ", regionsizes: " + regionSizes);
            Thread.sleep(3000L);
            snapshots = spaceQuotaManager.copyQuotaSnapshots();
            regionSizes = this.getReportedSizesForTable(tn);
        }
        snapshot = (SpaceQuotaSnapshot)snapshots.get(tn);
        Assert.assertEquals((long)0L, (long)snapshot.getUsage());
        Assert.assertEquals((long)51200L, (long)snapshot.getLimit());
        ActivePolicyEnforcement activePolicies = spaceQuotaManager.getActiveEnforcements();
        SpaceViolationPolicyEnforcement enforcement = activePolicies.getPolicyEnforcement(tn);
        Assert.assertTrue((String)("Expected to find Noop policy, but got " + enforcement.getClass().getSimpleName()), (boolean)(enforcement instanceof DefaultViolationPolicyEnforcement));
        ClientServiceCallable<Void> callable = this.generateFileToLoad(tn, 2, 500);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        for (FileStatus file : files = fs.listStatus(new Path(fs.getHomeDirectory(), this.testName.getMethodName() + "_files"))) {
            Assert.assertTrue((String)("Expected the file, " + file.getPath() + ",  length to be larger than 25KB, but was " + file.getLen()), (file.getLen() > 25600L ? 1 : 0) != 0);
            LOG.debug(file.getPath() + " -> " + file.getLen() + "B");
        }
        RpcRetryingCallerFactory factory = new RpcRetryingCallerFactory(TEST_UTIL.getConfiguration());
        RpcRetryingCaller caller = factory.newCaller();
        try {
            caller.callWithRetries(callable, Integer.MAX_VALUE);
            Assert.fail((String)"Expected the bulk load call to fail!");
        }
        catch (SpaceLimitingException e) {
            LOG.trace("Caught expected exception", (Throwable)e);
        }
        Table table = TEST_UTIL.getConnection().getTable(tn);
        try (ResultScanner scanner = table.getScanner(new Scan());){
            Assert.assertNull((String)"Expected no results", (Object)scanner.next());
        }
    }

    @Test
    public void testTableQuotaOverridesNamespaceQuota() throws Exception {
        SpaceViolationPolicy policy = SpaceViolationPolicy.NO_INSERTS;
        TableName tn = this.helper.createTableWithRegions(10);
        long tableLimit = 0x200000L;
        long namespaceLimit = 0x40000000L;
        TEST_UTIL.getAdmin().setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x200000L, (SpaceViolationPolicy)policy));
        TEST_UTIL.getAdmin().setQuota(QuotaSettingsFactory.limitNamespaceSpace((String)tn.getNamespaceAsString(), (long)0x40000000L, (SpaceViolationPolicy)policy));
        this.helper.writeData(tn, 0x300000L);
        Thread.sleep(5000L);
        Put p = new Put(Bytes.toBytes((String)"to_reject"));
        p.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        this.verifyViolation(policy, tn, (Mutation)p);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithNoInserts() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithNoWrite() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithNoWritesCompactions() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenRemoveWithDisable() throws Exception {
        this.setQuotaAndThenRemove(SpaceViolationPolicy.DISABLE);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoInserts() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithNoWrite() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenDropTableeWithNoWritesCompactions() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenDropTableWithDisable() throws Exception {
        this.setQuotaAndThenDropTable(SpaceViolationPolicy.DISABLE);
    }

    @Test
    public void testSetQuotaAndThenIncreaseQuotaWithNoInserts() throws Exception {
        this.setQuotaAndThenIncreaseQuota(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenIncreaseQuotaWithNoWrite() throws Exception {
        this.setQuotaAndThenIncreaseQuota(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenIncreaseQuotaWithNoWritesCompactions() throws Exception {
        this.setQuotaAndThenIncreaseQuota(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithNoInserts() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.NO_INSERTS);
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithNoWrite() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.NO_WRITES);
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithNoWritesCompaction() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.NO_WRITES_COMPACTIONS);
    }

    @Test
    public void testSetQuotaAndThenRemoveInOneWithDisable() throws Exception {
        this.setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy.DISABLE);
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithNoInserts() throws Exception {
        this.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.NO_INSERTS, 2L);
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithNoWrites() throws Exception {
        this.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.NO_WRITES, 2L);
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithNoWritesCompaction() throws Exception {
        this.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.NO_WRITES_COMPACTIONS, 2L);
    }

    @Test
    public void testSetQuotaOnNonExistingTableWithDisable() throws Exception {
        this.setQuotaLimit(this.NON_EXISTENT_TABLE, SpaceViolationPolicy.DISABLE, 2L);
    }

    private void setQuotaAndThenRemove(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        this.removeQuotaFromtable(tn);
        this.verifyNoViolation(policy, tn, (Mutation)put);
    }

    private void setQuotaAndThenDropTable(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        TEST_UTIL.deleteTable(tn);
        LOG.debug("Successfully deleted table ", (Object)tn);
        TEST_UTIL.createTable(tn, Bytes.toBytes((String)"f1"));
        LOG.debug("Successfully re-created table ", (Object)tn);
        this.verifyNoViolation(policy, tn, (Mutation)put);
    }

    private void setQuotaAndThenIncreaseQuota(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn = this.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        this.setQuotaLimit(tn, policy, 4L);
        this.verifyNoViolation(policy, tn, (Mutation)put);
    }

    public void setQuotaAndThenRemoveInOneAmongTwoTables(SpaceViolationPolicy policy) throws Exception {
        Put put = new Put(Bytes.toBytes((String)"to_reject"));
        put.addColumn(Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"));
        TableName tn1 = this.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        TableName tn2 = this.writeUntilViolationAndVerifyViolation(policy, (Mutation)put);
        this.removeQuotaFromtable(tn1);
        this.verifyNoViolation(policy, tn1, (Mutation)put);
        this.verifyViolation(policy, tn2, (Mutation)put);
    }

    private void removeQuotaFromtable(TableName tn) throws Exception {
        QuotaSettings removeQuota = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        TEST_UTIL.getAdmin().setQuota(removeQuota);
        LOG.debug("Space quota settings removed from the table ", (Object)tn);
    }

    private void setQuotaLimit(TableName tn, SpaceViolationPolicy policy, long sizeInMBs) throws Exception {
        long sizeLimit = sizeInMBs * 0x100000L;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)sizeLimit, (SpaceViolationPolicy)policy);
        TEST_UTIL.getAdmin().setQuota(settings);
        LOG.debug("Quota limit set for table = {}, limit = {}", (Object)tn, (Object)sizeLimit);
    }

    private Map<RegionInfo, Long> getReportedSizesForTable(TableName tn) {
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        MasterQuotaManager quotaManager = master.getMasterQuotaManager();
        HashMap<RegionInfo, Long> filteredRegionSizes = new HashMap<RegionInfo, Long>();
        for (Map.Entry entry : quotaManager.snapshotRegionSizes().entrySet()) {
            if (!((RegionInfo)entry.getKey()).getTable().equals((Object)tn)) continue;
            filteredRegionSizes.put((RegionInfo)entry.getKey(), (Long)entry.getValue());
        }
        return filteredRegionSizes;
    }

    private TableName writeUntilViolation(SpaceViolationPolicy policyToViolate) throws Exception {
        TableName tn = this.helper.createTableWithRegions(10);
        this.setQuotaLimit(tn, policyToViolate, 2L);
        this.helper.writeData(tn, 0x300000L);
        Thread.sleep(5000L);
        return tn;
    }

    private TableName writeUntilViolationAndVerifyViolation(SpaceViolationPolicy policyToViolate, Mutation m) throws Exception {
        TableName tn = this.writeUntilViolation(policyToViolate);
        this.verifyViolation(policyToViolate, tn, m);
        return tn;
    }

    private void verifyViolation(SpaceViolationPolicy policyToViolate, TableName tn, Mutation m) throws Exception {
        boolean sawError = false;
        for (int i = 0; i < 10 && !sawError; ++i) {
            try (Table table = TEST_UTIL.getConnection().getTable(tn);){
                if (m instanceof Put) {
                    table.put((Put)m);
                } else if (m instanceof Delete) {
                    table.delete((Delete)m);
                } else if (m instanceof Append) {
                    table.append((Append)m);
                } else if (m instanceof Increment) {
                    table.increment((Increment)m);
                } else {
                    Assert.fail((String)("Failed to apply " + m.getClass().getSimpleName() + " to the table. Programming error"));
                }
                LOG.info("Did not reject the " + m.getClass().getSimpleName() + ", will sleep and retry");
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception e) {
                String msg = StringUtils.stringifyException((Throwable)e);
                if (policyToViolate.equals((Object)SpaceViolationPolicy.DISABLE)) {
                    Assert.assertTrue((boolean)(e instanceof TableNotEnabledException));
                } else {
                    Assert.assertTrue((String)("Expected exception message to contain the word '" + policyToViolate.name() + "', but was " + msg), (boolean)msg.contains(policyToViolate.name()));
                }
                sawError = true;
            }
        }
        if (!sawError) {
            try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaUtil.QUOTA_TABLE_NAME);){
                ResultScanner scanner = quotaTable.getScanner(new Scan());
                Result result = null;
                LOG.info("Dumping contents of hbase:quota table");
                while ((result = scanner.next()) != null) {
                    LOG.info(Bytes.toString((byte[])result.getRow()) + " => " + result.toString());
                }
                scanner.close();
            }
        }
        Assert.assertTrue((String)"Expected to see an exception writing data to a table exceeding its quota", (boolean)sawError);
    }

    private ClientServiceCallable<Void> generateFileToLoad(TableName tn, int numFiles, int numRowsPerFile) throws Exception {
        final Connection conn = TEST_UTIL.getConnection();
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        final Configuration conf = TEST_UTIL.getConfiguration();
        Path baseDir = new Path(fs.getHomeDirectory(), this.testName.getMethodName() + "_files");
        fs.mkdirs(baseDir);
        final ArrayList<Pair> famPaths = new ArrayList<Pair>();
        for (int i = 1; i <= numFiles; ++i) {
            Path hfile = new Path(baseDir, "file" + i);
            TestHRegionServerBulkLoad.createHFile(fs, hfile, Bytes.toBytes((String)"f1"), Bytes.toBytes((String)"to"), Bytes.toBytes((String)"reject"), numRowsPerFile);
            famPaths.add(new Pair((Object)Bytes.toBytes((String)"f1"), (Object)hfile.toString()));
        }
        Table table = conn.getTable(tn);
        final String bulkToken = new SecureBulkLoadClient(conf, table).prepareBulkLoad(conn);
        return new ClientServiceCallable<Void>(conn, tn, Bytes.toBytes((String)"row"), (RpcController)new RpcControllerFactory(conf).newController(), -1){

            public Void rpcCall() throws Exception {
                SecureBulkLoadClient secureClient = null;
                byte[] regionName = this.getLocation().getRegionInfo().getRegionName();
                try (Table table = conn.getTable(this.getTableName());){
                    secureClient = new SecureBulkLoadClient(conf, table);
                    secureClient.secureBulkLoadHFiles((ClientProtos.ClientService.BlockingInterface)this.getStub(), famPaths, regionName, true, null, bulkToken);
                }
                return null;
            }
        };
    }

    private void verifyNoViolation(SpaceViolationPolicy policyToViolate, TableName tn, Mutation m) throws Exception {
        boolean sawSuccess = false;
        for (int i = 0; i < 10 && !sawSuccess; ++i) {
            try (Table table = TEST_UTIL.getConnection().getTable(tn);){
                if (m instanceof Put) {
                    table.put((Put)m);
                } else if (m instanceof Delete) {
                    table.delete((Delete)m);
                } else if (m instanceof Append) {
                    table.append((Append)m);
                } else if (m instanceof Increment) {
                    table.increment((Increment)m);
                } else {
                    Assert.fail((String)("Failed to apply " + m.getClass().getSimpleName() + " to the table. Programming error"));
                }
                sawSuccess = true;
                continue;
            }
            catch (Exception e) {
                LOG.info("Rejected the " + m.getClass().getSimpleName() + ", will sleep and retry");
                Thread.sleep(2000L);
            }
        }
        if (!sawSuccess) {
            try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaUtil.QUOTA_TABLE_NAME);){
                ResultScanner scanner = quotaTable.getScanner(new Scan());
                Result result = null;
                LOG.info("Dumping contents of hbase:quota table");
                while ((result = scanner.next()) != null) {
                    LOG.info(Bytes.toString((byte[])result.getRow()) + " => " + result.toString());
                }
                scanner.close();
            }
        }
        Assert.assertTrue((String)"Expected to succeed in writing data to a table not having quota ", (boolean)sawSuccess);
    }
}

