/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestLogsCleaner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLogsCleaner.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestLogsCleaner.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Path OLD_WALS_DIR = new Path(TEST_UTIL.getDataTestDir(), "oldWALs");
    private static final Path OLD_PROCEDURE_WALS_DIR = new Path(OLD_WALS_DIR, "masterProcedureWALs");
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniDFSCluster(1);
        CleanerChore.initChorePool((Configuration)TEST_UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
        TEST_UTIL.shutdownMiniDFSCluster();
    }

    @Before
    public void beforeTest() throws IOException {
        conf = TEST_UTIL.getConfiguration();
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        fs.delete(OLD_WALS_DIR, true);
        fs.mkdirs(OLD_WALS_DIR);
    }

    @Test
    public void testLogCleaning() throws Exception {
        Path fileName;
        int i;
        long ttlWAL = 2000L;
        long ttlProcedureWAL = 4000L;
        conf.setLong("hbase.master.logcleaner.ttl", ttlWAL);
        conf.setLong("hbase.master.procedurewalcleaner.ttl", ttlProcedureWAL);
        HMaster.decorateMasterConfiguration((Configuration)conf);
        DummyServer server = new DummyServer();
        ReplicationQueueStorage queueStorage = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)server.getZooKeeper(), (Configuration)conf);
        String fakeMachineName = URLEncoder.encode(server.getServerName().toString(), StandardCharsets.UTF_8.name());
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(OLD_PROCEDURE_WALS_DIR);
        long now = System.currentTimeMillis();
        fs.createNewFile(new Path(OLD_WALS_DIR, "a"));
        fs.createNewFile(new Path(OLD_WALS_DIR, fakeMachineName + ".a"));
        for (i = 1; i <= 5; ++i) {
            fileName = new Path(OLD_PROCEDURE_WALS_DIR, String.format("pv2-%020d.log", i));
            fs.createNewFile(fileName);
        }
        Thread.sleep(ttlProcedureWAL - ttlWAL);
        for (i = 1; i <= 30; ++i) {
            fileName = new Path(OLD_WALS_DIR, fakeMachineName + "." + (now - (long)i));
            fs.createNewFile(fileName);
            if (i % 10 != 0) continue;
            queueStorage.addWAL(server.getServerName(), fakeMachineName, fileName.getName());
            LOG.info("Replication log file: " + fileName);
        }
        for (i = 6; i <= 10; ++i) {
            fileName = new Path(OLD_PROCEDURE_WALS_DIR, String.format("pv2-%020d.log", i));
            fs.createNewFile(fileName);
        }
        Thread.sleep(ttlWAL);
        fs.createNewFile(new Path(OLD_WALS_DIR, fakeMachineName + "." + now));
        fs.createNewFile(new Path(OLD_WALS_DIR, fakeMachineName + "." + (now + ttlWAL)));
        Object[] status = fs.listStatus(OLD_WALS_DIR);
        LOG.info("File status: {}", (Object)Arrays.toString(status));
        Assert.assertEquals((long)35L, (long)fs.listStatus(OLD_WALS_DIR).length);
        Assert.assertEquals((long)10L, (long)fs.listStatus(OLD_PROCEDURE_WALS_DIR).length);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, OLD_WALS_DIR);
        cleaner.chore();
        TEST_UTIL.waitFor(1000L, () -> 6 == fs.listStatus(OLD_WALS_DIR).length);
        TEST_UTIL.waitFor(1000L, () -> 5 == fs.listStatus(OLD_PROCEDURE_WALS_DIR).length);
        if (LOG.isDebugEnabled()) {
            Object[] statusOldWALs = fs.listStatus(OLD_WALS_DIR);
            Object[] statusProcedureWALs = fs.listStatus(OLD_PROCEDURE_WALS_DIR);
            LOG.debug("Kept log file for oldWALs: {}", (Object)Arrays.toString(statusOldWALs));
            LOG.debug("Kept log file for masterProcedureWALs: {}", (Object)Arrays.toString(statusProcedureWALs));
        }
    }

    @Test
    public void testZooKeeperAbort() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        List<FileStatus> dummyFiles = Arrays.asList(new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log2")));
        try (FaultyZooKeeperWatcher faultyZK = new FaultyZooKeeperWatcher(conf, "testZooKeeperAbort-faulty", null);){
            faultyZK.init();
            cleaner.setConf(conf, (ZKWatcher)faultyZK);
            cleaner.preClean();
            Iterable toDelete = cleaner.getDeletableFiles(dummyFiles);
            Assert.assertFalse((boolean)toDelete.iterator().hasNext());
            Assert.assertFalse((boolean)cleaner.isStopped());
        }
        cleaner = new ReplicationLogCleaner();
        var5_5 = null;
        try (ZKWatcher zkw = new ZKWatcher(conf, "testZooKeeperAbort-normal", null);){
            cleaner.setConf(conf, zkw);
            cleaner.preClean();
            Iterable filesToDelete = cleaner.getDeletableFiles(dummyFiles);
            Iterator iter = filesToDelete.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log1"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log2"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertFalse((boolean)iter.hasNext());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZooKeeperNormal() throws Exception {
        ReplicationLogCleaner cleaner = new ReplicationLogCleaner();
        List<FileStatus> dummyFiles = Arrays.asList(new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log1")), new FileStatus(100L, false, 3, 100L, System.currentTimeMillis(), new Path("log2")));
        try (ZKWatcher zkw = new ZKWatcher(conf, "testZooKeeperAbort-normal", null);){
            cleaner.setConf(conf, zkw);
            cleaner.preClean();
            Iterable filesToDelete = cleaner.getDeletableFiles(dummyFiles);
            Iterator iter = filesToDelete.iterator();
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log1"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertTrue((boolean)iter.hasNext());
            Assert.assertEquals((Object)new Path("log2"), (Object)((FileStatus)iter.next()).getPath());
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    public void testOnConfigurationChange() throws Exception {
        DummyServer server = new DummyServer();
        DistributedFileSystem fs = TEST_UTIL.getDFSCluster().getFileSystem();
        LogCleaner cleaner = new LogCleaner(3000, (Stoppable)server, conf, (FileSystem)fs, OLD_WALS_DIR);
        Assert.assertEquals((long)2L, (long)cleaner.getSizeOfCleaners());
        Assert.assertEquals((long)60000L, (long)cleaner.getCleanerThreadTimeoutMsec());
        int numOfFiles = 10;
        this.createFiles((FileSystem)fs, OLD_WALS_DIR, numOfFiles);
        FileStatus[] status = fs.listStatus(OLD_WALS_DIR);
        Assert.assertEquals((long)numOfFiles, (long)status.length);
        Thread thread = new Thread(() -> cleaner.chore());
        thread.setDaemon(true);
        thread.start();
        int sizeToChange = 4;
        long threadTimeoutToChange = 30000L;
        conf.setInt("hbase.oldwals.cleaner.thread.size", sizeToChange);
        conf.setLong("hbase.oldwals.cleaner.thread.timeout.msec", threadTimeoutToChange);
        cleaner.onConfigurationChange(conf);
        Assert.assertEquals((long)sizeToChange, (long)cleaner.getSizeOfCleaners());
        Assert.assertEquals((long)threadTimeoutToChange, (long)cleaner.getCleanerThreadTimeoutMsec());
        thread.join();
        status = fs.listStatus(OLD_WALS_DIR);
        Assert.assertEquals((long)0L, (long)status.length);
    }

    private void createFiles(FileSystem fs, Path parentDir, int numOfFiles) throws IOException {
        for (int i = 0; i < numOfFiles; ++i) {
            int xMega = 1 + ThreadLocalRandom.current().nextInt(1, 4);
            try (FSDataOutputStream fsdos = fs.create(new Path(parentDir, "file-" + i));){
                byte[] M = RandomUtils.nextBytes((int)Math.toIntExact(0x100000L * (long)xMega));
                fsdos.write(M);
                continue;
            }
        }
    }

    static class FaultyZooKeeperWatcher
    extends ZKWatcher {
        private RecoverableZooKeeper zk;

        public FaultyZooKeeperWatcher(Configuration conf, String identifier, Abortable abortable) throws ZooKeeperConnectionException, IOException {
            super(conf, identifier, abortable);
        }

        public void init() throws Exception {
            this.zk = (RecoverableZooKeeper)Mockito.spy((Object)super.getRecoverableZooKeeper());
            ((RecoverableZooKeeper)Mockito.doThrow((Throwable[])new Throwable[]{new KeeperException.ConnectionLossException()}).when((Object)this.zk)).getChildren("/hbase/replication/rs", null);
        }

        public RecoverableZooKeeper getRecoverableZooKeeper() {
            return this.zk;
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        public ZKWatcher getZooKeeper() {
            try {
                return new ZKWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)"regionserver,60020,000000");
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }

        public Connection createConnection(Configuration conf) throws IOException {
            return null;
        }
    }
}

