/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, LargeTests.class})
public class TestRegionReplicaSplit {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionReplicaSplit.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionReplicaSplit.class);
    private static final int NB_SERVERS = 4;
    private static Table table;
    private static final HBaseTestingUtility HTU;
    private static final byte[] f;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        HTU.getConfiguration().setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        HTU.startMiniCluster(4);
        TableName tableName = TableName.valueOf((String)TestRegionReplicaSplit.class.getSimpleName());
        TestRegionReplicaSplit.createTable(tableName);
    }

    private static void createTable(TableName tableName) throws IOException {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setRegionReplication(3);
        table = HTU.createTable(builder.build(), (byte[][])new byte[][]{f}, TestRegionReplicaSplit.getSplits(2), new Configuration(HTU.getConfiguration()));
    }

    private static byte[][] getSplits(int numRegions) {
        RegionSplitter.UniformSplit split = new RegionSplitter.UniformSplit();
        split.setFirstRow(Bytes.toBytes((long)0L));
        split.setLastRow(Bytes.toBytes((long)Long.MAX_VALUE));
        return split.split(numRegions);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        HRegionServer.TEST_SKIP_REPORTING_TRANSITION = false;
        table.close();
        HTU.shutdownMiniCluster();
    }

    @Test
    public void testRegionReplicaSplitRegionAssignment() throws Exception {
        HTU.loadNumericRows(table, f, 0, 3);
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>();
        for (JVMClusterUtil.RegionServerThread regionServerThread : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
            for (Object r : regionServerThread.getRegionServer().getRegions(table.getName())) {
                System.out.println("the region before split is is " + r.getRegionInfo() + regionServerThread.getRegionServer().getServerName());
                regions.add(r.getRegionInfo());
            }
        }
        HTU.getAdmin().split(table.getName(), Bytes.toBytes((int)1));
        int count = 0;
        while (true) {
            for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
                for (Region r : rs.getRegionServer().getRegions(table.getName())) {
                    ++count;
                }
            }
            if (count >= 9) break;
            count = 0;
        }
        ArrayList<ServerName> arrayList = new ArrayList<ServerName>();
        for (JVMClusterUtil.RegionServerThread rs : HTU.getMiniHBaseCluster().getRegionServerThreads()) {
            RegionInfo prevInfo = null;
            for (Region r : rs.getRegionServer().getRegions(table.getName())) {
                if (regions.contains(r.getRegionInfo()) || RegionReplicaUtil.isDefaultReplica((RegionInfo)r.getRegionInfo())) continue;
                LOG.info("The region is " + r.getRegionInfo() + " the location is " + rs.getRegionServer().getServerName());
                if (!RegionReplicaUtil.isDefaultReplica((RegionInfo)r.getRegionInfo()) && arrayList.contains(rs.getRegionServer().getServerName()) && prevInfo != null && Bytes.equals((byte[])prevInfo.getStartKey(), (byte[])r.getRegionInfo().getStartKey()) && Bytes.equals((byte[])prevInfo.getEndKey(), (byte[])r.getRegionInfo().getEndKey())) {
                    Assert.fail((String)"Splitted regions should not be assigned to same region server");
                    continue;
                }
                prevInfo = r.getRegionInfo();
                if (RegionReplicaUtil.isDefaultReplica((RegionInfo)r.getRegionInfo()) || arrayList.contains(rs.getRegionServer().getServerName())) continue;
                arrayList.add(rs.getRegionServer().getServerName());
            }
        }
        Assert.assertEquals((String)"The new regions should be assigned to 3 unique servers ", (long)3L, (long)arrayList.size());
    }

    static {
        HTU = new HBaseTestingUtility();
        f = HConstants.CATALOG_FAMILY;
    }
}

