/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.AbstractTestRestartCluster;
import org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.hadoop.hbase.master.assignment.ServerStateNode;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestClusterRestartFailover
extends AbstractTestRestartCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClusterRestartFailover.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestClusterRestartFailover.class);

    @Override
    protected boolean splitWALCoordinatedByZk() {
        return true;
    }

    private ServerStateNode getServerStateNode(ServerName serverName) {
        return this.UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getServerNode(serverName);
    }

    @Test
    public void test() throws Exception {
        this.UTIL.startMiniCluster(3);
        this.UTIL.waitFor(60000L, () -> this.UTIL.getMiniHBaseCluster().getMaster().isInitialized());
        this.UTIL.waitFor(60000L, () -> this.UTIL.getHBaseCluster().getMaster().getProcedures().stream().noneMatch(p -> p instanceof ServerCrashProcedure));
        TableName tableName = TABLES[0];
        ServerName testServer = this.UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        this.UTIL.waitFor(30000L, () -> this.getServerStateNode(testServer) != null);
        ServerStateNode serverNode = this.getServerStateNode(testServer);
        Assert.assertNotNull((Object)serverNode);
        Assert.assertTrue((String)"serverNode should be ONLINE when cluster runs normally", (boolean)serverNode.isInState(new ServerState[]{ServerState.ONLINE}));
        this.UTIL.createMultiRegionTable(tableName, FAMILY);
        this.UTIL.waitTableEnabled(tableName);
        Table table = this.UTIL.getConnection().getTable(tableName);
        for (int i = 0; i < 100; ++i) {
            this.UTIL.loadTable(table, FAMILY);
        }
        List<Integer> ports = this.UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServersList().stream().map(serverName -> serverName.getPort()).collect(Collectors.toList());
        LOG.info("Shutting down cluster");
        this.UTIL.getHBaseCluster().killAll();
        this.UTIL.getHBaseCluster().waitUntilShutDown();
        LOG.info("Starting cluster the second time");
        this.UTIL.restartHBaseCluster(3, ports);
        this.UTIL.waitFor(30000L, () -> this.UTIL.getHBaseCluster().getMaster().isInitialized());
        serverNode = this.UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getServerNode(testServer);
        Assert.assertNotNull((String)"serverNode should not be null when restart whole cluster", (Object)serverNode);
        Assert.assertFalse((boolean)serverNode.isInState(new ServerState[]{ServerState.ONLINE}));
        LOG.info("start to find the procedure of SCP for the severName we choose");
        this.UTIL.waitFor(60000L, () -> this.UTIL.getHBaseCluster().getMaster().getProcedures().stream().anyMatch(procedure -> procedure instanceof ServerCrashProcedure && ((ServerCrashProcedure)procedure).getServerName().equals((Object)testServer)));
        Assert.assertFalse((String)"serverNode should not be ONLINE during SCP processing", (boolean)serverNode.isInState(new ServerState[]{ServerState.ONLINE}));
        LOG.info("start to submit the SCP for the same serverName {} which should fail", (Object)testServer);
        Assert.assertFalse((boolean)this.UTIL.getHBaseCluster().getMaster().getServerManager().expireServer(testServer));
        Procedure procedure = this.UTIL.getHBaseCluster().getMaster().getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure && ((ServerCrashProcedure)p).getServerName().equals((Object)testServer)).findAny().get();
        this.UTIL.waitFor(60000L, () -> procedure.isFinished());
        LOG.info("even when the SCP is finished, the duplicate SCP should not be scheduled for {}", (Object)testServer);
        Assert.assertFalse((boolean)this.UTIL.getHBaseCluster().getMaster().getServerManager().expireServer(testServer));
        serverNode = this.UTIL.getHBaseCluster().getMaster().getAssignmentManager().getRegionStates().getServerNode(testServer);
        Assert.assertNull((String)"serverNode should be deleted after SCP finished", (Object)serverNode);
    }
}

