/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.constraint.ConstraintException;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={LargeTests.class, ClientTests.class})
public class TestAdmin2 {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAdmin2.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestAdmin2.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Admin admin;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 30);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.handler.count", 30);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getHBaseAdmin();
    }

    @After
    public void tearDown() throws Exception {
        for (HTableDescriptor htd : this.admin.listTables()) {
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    @Test
    public void testCreateBadTables() throws IOException {
        int i;
        String msg = null;
        try {
            this.admin.createTable((TableDescriptor)new HTableDescriptor(TableName.META_TABLE_NAME));
        }
        catch (TableExistsException e) {
            msg = e.toString();
        }
        Assert.assertTrue((String)("Unexcepted exception message " + msg), (msg != null && msg.startsWith(TableExistsException.class.getName()) && msg.contains(TableName.META_TABLE_NAME.getNameAsString()) ? 1 : 0) != 0);
        final HTableDescriptor threadDesc = new HTableDescriptor(TableName.valueOf((String)this.name.getMethodName()));
        threadDesc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        int count = 10;
        Thread[] threads = new Thread[count];
        final AtomicInteger successes = new AtomicInteger(0);
        final AtomicInteger failures = new AtomicInteger(0);
        final Admin localAdmin = this.admin;
        for (i = 0; i < count; ++i) {
            threads[i] = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    try {
                        localAdmin.createTable((TableDescriptor)threadDesc);
                        successes.incrementAndGet();
                    }
                    catch (TableExistsException e) {
                        failures.incrementAndGet();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed threaded create" + this.getName(), e);
                    }
                }
            };
        }
        for (i = 0; i < count; ++i) {
            threads[i].start();
        }
        for (i = 0; i < count; ++i) {
            while (threads[i].isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Assert.assertEquals((long)1L, (long)successes.get());
        Assert.assertEquals((long)(count - 1), (long)failures.get());
    }

    @Test
    public void testTableNameClash() throws Exception {
        String name = this.name.getMethodName();
        HTableDescriptor htd1 = new HTableDescriptor(TableName.valueOf((String)(name + "SOMEUPPERCASE")));
        HTableDescriptor htd2 = new HTableDescriptor(TableName.valueOf((String)name));
        htd1.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        htd2.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)htd1);
        this.admin.createTable((TableDescriptor)htd2);
        TEST_UTIL.getConnection().getTable(htd2.getTableName()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTableRPCTimeOut() throws Exception {
        String name = this.name.getMethodName();
        int oldTimeout = TEST_UTIL.getConfiguration().getInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 1500);
        try {
            int expectedRegions = 100;
            byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
            byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
            HBaseAdmin hbaseadmin = TEST_UTIL.getHBaseAdmin();
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)name));
            htd.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
            hbaseadmin.createTable((TableDescriptor)htd, startKey, endKey, expectedRegions);
        }
        finally {
            TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", oldTimeout);
        }
    }

    @Test
    public void testReadOnlyTable() throws Exception {
        TableName name = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
        byte[] value = Bytes.toBytes((String)"somedata");
        Put put = new Put(value);
        put.addColumn(HConstants.CATALOG_FAMILY, HConstants.CATALOG_FAMILY, value);
        table.put(put);
        table.close();
    }

    @Test
    public void testTableNames() throws IOException {
        byte[][] illegalNames;
        for (byte[] illegalName : illegalNames = new byte[][]{Bytes.toBytes((String)"-bad"), Bytes.toBytes((String)".bad")}) {
            try {
                new HTableDescriptor(TableName.valueOf((byte[])illegalName));
                throw new IOException("Did not detect '" + Bytes.toString((byte[])illegalName) + "' as an illegal user table name");
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        byte[] legalName = Bytes.toBytes((String)"g-oo.d");
        try {
            new HTableDescriptor(TableName.valueOf((byte[])legalName));
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Legal user table name: '" + Bytes.toString((byte[])legalName) + "' caused IllegalArgumentException: " + e.getMessage());
        }
    }

    @Test(expected=TableExistsException.class)
    public void testTableExistsExceptionWithATable() throws IOException {
        TableName name = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);
    }

    @Test(expected=TableNotEnabledException.class)
    public void testTableNotEnabledExceptionWithATable() throws IOException {
        TableName name = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY).close();
        this.admin.disableTable(name);
        this.admin.disableTable(name);
    }

    @Test(expected=TableNotDisabledException.class)
    public void testTableNotDisabledExceptionWithATable() throws IOException {
        TableName name = TableName.valueOf((String)this.name.getMethodName());
        try (Table t = TEST_UTIL.createTable(name, HConstants.CATALOG_FAMILY);){
            this.admin.enableTable(name);
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testTableNotFoundExceptionWithoutAnyTables() throws IOException {
        TableName tableName = TableName.valueOf((String)"testTableNotFoundExceptionWithoutAnyTables");
        Table ht = TEST_UTIL.getConnection().getTable(tableName);
        ht.get(new Get(Bytes.toBytes((String)"e")));
    }

    @Test
    public void testShouldUnassignTheRegion() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithDefaultConf(tableName);
        RegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        for (RegionInfo regionInfo : onlineRegions) {
            if (regionInfo.getTable().isSystemTable()) continue;
            info = regionInfo;
            this.admin.unassign(regionInfo.getRegionName(), true);
        }
        boolean isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout && isInList) {
            Thread.sleep(100L);
            isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        }
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)isInList);
    }

    @Test
    public void testCloseRegionIfInvalidRegionNameIsPassed() throws Exception {
        String name = this.name.getMethodName();
        byte[] tableName = Bytes.toBytes((String)name);
        this.createTableWithDefaultConf(tableName);
        RegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(TableName.valueOf((byte[])tableName));
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        for (RegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaRegion() || !regionInfo.getRegionNameAsString().contains(name)) continue;
            info = regionInfo;
            try {
                this.admin.unassign(Bytes.toBytes((String)"sample"), true);
            }
            catch (UnknownRegionException unknownRegionException) {}
        }
        onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        Assert.assertTrue((String)"The region should be present in online regions list.", (boolean)onlineRegions.contains(info));
    }

    @Test
    public void testCloseRegionThatFetchesTheHRIFromMeta() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.createTableWithDefaultConf(tableName);
        RegionInfo info = null;
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        List onlineRegions = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices());
        for (RegionInfo regionInfo : onlineRegions) {
            if (regionInfo.isMetaRegion() || !regionInfo.getRegionNameAsString().contains("TestHBACloseRegion2")) continue;
            info = regionInfo;
            this.admin.unassign(regionInfo.getRegionName(), true);
        }
        boolean isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        long timeout = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < timeout && isInList) {
            Thread.sleep(100L);
            isInList = ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)rs.getRSRpcServices()).contains(info);
        }
        Assert.assertFalse((String)"The region should not be present in online regions list.", (boolean)isInList);
    }

    private HBaseAdmin createTable(TableName tableName) throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable((TableDescriptor)htd, (byte[][])null);
        return admin;
    }

    private void createTableWithDefaultConf(byte[] TABLENAME) throws IOException {
        this.createTableWithDefaultConf(TableName.valueOf((byte[])TABLENAME));
    }

    private void createTableWithDefaultConf(TableName TABLENAME) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TABLENAME);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        this.admin.createTable((TableDescriptor)htd, (byte[][])null);
    }

    @Test
    public void testGetTableRegions() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        int expectedRegions = 10;
        byte[] startKey = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        byte[] endKey = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc, startKey, endKey, expectedRegions);
        List RegionInfos = this.admin.getRegions(tableName);
        Assert.assertEquals((String)("Tried to create " + expectedRegions + " regions but only found " + RegionInfos.size()), (long)expectedRegions, (long)RegionInfos.size());
    }

    @Test
    public void testMoveToPreviouslyAssignedRS() throws IOException, InterruptedException {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster master = cluster.getMaster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        HBaseAdmin localAdmin = this.createTable(tableName);
        List tableRegions = localAdmin.getRegions(tableName);
        RegionInfo hri = (RegionInfo)tableRegions.get(0);
        AssignmentManager am = master.getAssignmentManager();
        ServerName server = am.getRegionStates().getRegionServerOfRegion(hri);
        localAdmin.move(hri.getEncodedNameAsBytes(), server);
        Assert.assertEquals((String)"Current region server and region server before move should be same.", (Object)server, (Object)am.getRegionStates().getRegionServerOfRegion(hri));
    }

    @Test
    public void testWALRollWriting() throws Exception {
        this.setUpforLogRolling();
        String className = this.getClass().getName();
        StringBuilder v = new StringBuilder(className);
        while (v.length() < 1000) {
            v.append(className);
        }
        byte[] value = Bytes.toBytes((String)v.toString());
        HRegionServer regionServer = this.startAndWriteData(TableName.valueOf((String)this.name.getMethodName()), value);
        LOG.info("after writing there are " + AbstractFSWALProvider.getNumRolledLogFiles((WAL)regionServer.getWAL(null)) + " log files");
        for (HRegion r : regionServer.getOnlineRegionsLocalContext()) {
            r.flush(true);
        }
        this.admin.rollWALWriter(regionServer.getServerName());
        int count = AbstractFSWALProvider.getNumRolledLogFiles((WAL)regionServer.getWAL(null));
        LOG.info("after flushing all regions and rolling logs there are " + count + " log files");
        Assert.assertTrue((String)("actual count: " + count), (count <= 2 ? 1 : 0) != 0);
    }

    private void setUpforLogRolling() {
        TEST_UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 786432L);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.maxlogentries", 32);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.logroll.errors.tolerated", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 10000);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.optionalflushcount", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.hregion.memstore.flush.size", 8192);
        TEST_UTIL.getConfiguration().setLong("hbase.client.pause", 10000L);
        TEST_UTIL.getConfiguration().setInt("hbase.server.thread.wakefrequency", 2000);
        TEST_UTIL.getConfiguration().setInt("dfs.namenode.heartbeat.recheck-interval", 5000);
        TEST_UTIL.getConfiguration().setInt("dfs.heartbeat.interval", 1);
        TEST_UTIL.getConfiguration().setInt("dfs.client.block.write.retries", 30);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.tolerable.lowreplication", 2);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.hlog.lowreplication.rolllimit", 3);
    }

    private HRegionServer startAndWriteData(TableName tableName, byte[] value) throws IOException, InterruptedException {
        TEST_UTIL.getConnection().getTable(TableName.META_TABLE_NAME).close();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addFamily(new HColumnDescriptor(HConstants.CATALOG_FAMILY));
        this.admin.createTable((TableDescriptor)desc);
        Table table = TEST_UTIL.getConnection().getTable(tableName);
        HRegionServer regionServer = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        for (int i = 1; i <= 256; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + String.format("%1$04d", i))));
            put.addColumn(HConstants.CATALOG_FAMILY, null, value);
            table.put(put);
            if (i % 32 != 0) continue;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        table.close();
        return regionServer;
    }

    @Test
    public void testCheckHBaseAvailableWithoutCluster() {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.zookeeper.property.clientPort", conf.getInt("hbase.zookeeper.property.clientPort", 9999) + 10);
        long start = System.currentTimeMillis();
        try {
            HBaseAdmin.available((Configuration)conf);
            Assert.assertTrue((boolean)false);
        }
        catch (ZooKeeperConnectionException zooKeeperConnectionException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        long end = System.currentTimeMillis();
        LOG.info("It took " + (end - start) + " ms to find out that HBase was not available");
    }

    @Test
    public void testDisableCatalogTable() throws Exception {
        try {
            this.admin.disableTable(TableName.META_TABLE_NAME);
            Assert.fail((String)"Expected to throw ConstraintException");
        }
        catch (ConstraintException constraintException) {
            // empty catch block
        }
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])Bytes.toBytes((String)this.name.getMethodName())));
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toBytes((String)"cf1"));
        htd.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable((TableDescriptor)htd);
    }

    @Test
    public void testIsEnabledOrDisabledOnUnknownTable() throws Exception {
        try {
            this.admin.isTableEnabled(TableName.valueOf((String)this.name.getMethodName()));
            Assert.fail((String)"Test should fail if isTableEnabled called on unknown table.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.admin.isTableDisabled(TableName.valueOf((String)this.name.getMethodName()));
            Assert.fail((String)"Test should fail if isTableDisabled called on unknown table.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRegion() throws Exception {
        HBaseAdmin rawAdmin = TEST_UTIL.getHBaseAdmin();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        LOG.info("Started " + tableName);
        Table t = TEST_UTIL.createMultiRegionTable(tableName, HConstants.CATALOG_FAMILY);
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(tableName);){
            HRegionLocation regionLocation = locator.getRegionLocation(Bytes.toBytes((String)"mmm"));
            HRegionInfo region = regionLocation.getRegionInfo();
            byte[] regionName = region.getRegionName();
            Pair pair = rawAdmin.getRegion(regionName);
            Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])((RegionInfo)pair.getFirst()).getRegionName()));
            pair = rawAdmin.getRegion(region.getEncodedNameAsBytes());
            Assert.assertTrue((boolean)Bytes.equals((byte[])regionName, (byte[])((RegionInfo)pair.getFirst()).getRegionName()));
        }
    }

    @Test
    public void testBalancer() throws Exception {
        boolean initialState = this.admin.isBalancerEnabled();
        boolean prevState = this.admin.setBalancerRunning(!initialState, true);
        Assert.assertEquals((Object)initialState, (Object)prevState);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)this.admin.isBalancerEnabled());
        prevState = this.admin.setBalancerRunning(initialState, true);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)prevState);
        Assert.assertEquals((Object)initialState, (Object)this.admin.isBalancerEnabled());
    }

    @Test
    public void testRegionNormalizer() throws Exception {
        boolean initialState = this.admin.isNormalizerEnabled();
        boolean prevState = this.admin.setNormalizerRunning(!initialState);
        Assert.assertEquals((Object)initialState, (Object)prevState);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)this.admin.isNormalizerEnabled());
        prevState = this.admin.setNormalizerRunning(initialState);
        Assert.assertEquals((Object)(!initialState ? 1 : 0), (Object)prevState);
        Assert.assertEquals((Object)initialState, (Object)this.admin.isNormalizerEnabled());
    }

    @Test
    public void testAbortProcedureFail() throws Exception {
        Random randomGenerator = new Random();
        long procId = randomGenerator.nextLong();
        boolean abortResult = this.admin.abortProcedure(procId, true);
        Assert.assertFalse((boolean)abortResult);
    }

    @Test
    public void testGetProcedures() throws Exception {
        String procList = this.admin.getProcedures();
        Assert.assertTrue((boolean)procList.startsWith("["));
    }

    @Test
    public void testGetLocks() throws Exception {
        String lockList = this.admin.getLocks();
        Assert.assertTrue((boolean)lockList.startsWith("["));
    }

    @Test
    public void testDecommissionRegionServers() throws Exception {
        int i;
        List decommissionedRegionServers = this.admin.listDecommissionedRegionServers();
        Assert.assertTrue((boolean)decommissionedRegionServers.isEmpty());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createMultiRegionTable(tableName, Bytes.toBytes((String)"f"), 6);
        ArrayList clusterRegionServers = new ArrayList(this.admin.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLiveServerMetrics().keySet());
        Assert.assertEquals((long)3L, (long)clusterRegionServers.size());
        HashMap serversToDecommssion = new HashMap();
        for (i = 0; i < clusterRegionServers.size(); ++i) {
            List regionsOnServer = this.admin.getRegions((ServerName)clusterRegionServers.get(i));
            if (!this.admin.getRegions((ServerName)clusterRegionServers.get(i)).stream().anyMatch(p -> p.isMetaRegion())) continue;
            serversToDecommssion.put(clusterRegionServers.get(i), regionsOnServer);
            break;
        }
        clusterRegionServers.remove(i);
        serversToDecommssion.put(clusterRegionServers.get(0), this.admin.getRegions((ServerName)clusterRegionServers.get(0)));
        ServerName remainingServer = (ServerName)clusterRegionServers.get(1);
        this.admin.decommissionRegionServers(new ArrayList(serversToDecommssion.keySet()), true);
        Assert.assertEquals((long)2L, (long)this.admin.listDecommissionedRegionServers().size());
        for (ServerName server : serversToDecommssion.keySet()) {
            for (RegionInfo region2 : (List)serversToDecommssion.get(server)) {
                TEST_UTIL.assertRegionOnServer(region2, remainingServer, 10000L);
            }
        }
        for (ServerName server : serversToDecommssion.keySet()) {
            List encodedRegionNames = ((List)serversToDecommssion.get(server)).stream().map(region -> region.getEncodedNameAsBytes()).collect(Collectors.toList());
            this.admin.recommissionRegionServer(server, encodedRegionNames);
        }
        Assert.assertTrue((boolean)this.admin.listDecommissionedRegionServers().isEmpty());
        for (ServerName server : serversToDecommssion.keySet()) {
            for (RegionInfo region2 : (List)serversToDecommssion.get(server)) {
                TEST_UTIL.assertRegionOnServer(region2, server, 10000L);
            }
        }
    }

    @Test
    public void testGetRegionInfo() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        Table table = TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"));
        for (int i = 0; i < 100; ++i) {
            table.put(new Put(Bytes.toBytes((int)i)).addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"q"), Bytes.toBytes((int)i)));
        }
        this.admin.flush(tableName);
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(table.getName());
        List regions = rs.getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegion region = (HRegion)regions.get(0);
        byte[] regionName = region.getRegionInfo().getRegionName();
        HStore store = region.getStore(Bytes.toBytes((String)"f"));
        long expectedStoreFilesSize = store.getStorefilesSize();
        Assert.assertNotNull((Object)store);
        Assert.assertEquals((long)expectedStoreFilesSize, (long)store.getSize());
        ClusterConnection conn = (ClusterConnection)this.admin.getConnection();
        HBaseRpcController controller = conn.getRpcControllerFactory().newController();
        for (int i = 0; i < 10; ++i) {
            RegionInfo ri = ProtobufUtil.getRegionInfo((RpcController)controller, (AdminProtos.AdminService.BlockingInterface)conn.getAdmin(rs.getServerName()), (byte[])regionName);
            Assert.assertEquals((Object)region.getRegionInfo(), (Object)ri);
            Assert.assertEquals((long)expectedStoreFilesSize, (long)store.getSize());
        }
    }

    @Test
    public void testTableSplitFollowedByModify() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, Bytes.toBytes((String)"f"));
        List regions = this.admin.getRegions(tableName);
        final int originalCount = regions.size();
        Assert.assertEquals((long)1L, (long)originalCount);
        this.admin.split(tableName, Bytes.toBytes((int)3));
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestAdmin2.this.admin.getRegions(tableName).size() > originalCount;
            }
        });
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)this.admin.getDescriptor(tableName)).setMaxFileSize(11111111L).build();
        this.admin.modifyTable(tableDesc);
        Assert.assertEquals((long)11111111L, (long)this.admin.getDescriptor(tableName).getMaxFileSize());
    }

    @Test
    public void testTableMergeFollowedByModify() throws Exception {
        final TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TEST_UTIL.createTable(tableName, (byte[][])new byte[][]{Bytes.toBytes((String)"f")}, (byte[][])new byte[][]{Bytes.toBytes((int)3)});
        List regions = this.admin.getRegions(tableName);
        final int originalCount = regions.size();
        Assert.assertTrue((originalCount >= 2 ? 1 : 0) != 0);
        byte[] nameOfRegionA = ((RegionInfo)regions.get(0)).getEncodedNameAsBytes();
        byte[] nameOfRegionB = ((RegionInfo)regions.get(1)).getEncodedNameAsBytes();
        this.admin.mergeRegionsAsync(nameOfRegionA, nameOfRegionB, true);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestAdmin2.this.admin.getRegions(tableName).size() < originalCount;
            }
        });
        TableDescriptor tableDesc = TableDescriptorBuilder.newBuilder((TableDescriptor)this.admin.getDescriptor(tableName)).setMaxFileSize(11111111L).build();
        this.admin.modifyTable(tableDesc);
        Assert.assertEquals((long)11111111L, (long)this.admin.getDescriptor(tableName).getMaxFileSize());
    }
}

