/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FSVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(FSVisitor.class);

    private FSVisitor() {
    }

    public static void visitTableStoreFiles(FileSystem fs, Path tableDir, StoreFileVisitor visitor) throws IOException {
        List<FileStatus> regions = FSUtils.listStatusWithStatusFilter(fs, tableDir, new FSUtils.RegionDirFilter(fs));
        if (regions == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No regions under directory:" + tableDir);
            }
            return;
        }
        for (FileStatus region : regions) {
            FSVisitor.visitRegionStoreFiles(fs, region.getPath(), visitor);
        }
    }

    public static void visitRegionStoreFiles(FileSystem fs, Path regionDir, StoreFileVisitor visitor) throws IOException {
        List<FileStatus> families = FSUtils.listStatusWithStatusFilter(fs, regionDir, new FSUtils.FamilyDirFilter(fs));
        if (families == null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No families under region directory:" + regionDir);
            }
            return;
        }
        FSUtils.FileFilter fileFilter = new FSUtils.FileFilter(fs);
        for (FileStatus family : families) {
            Path familyDir = family.getPath();
            String familyName = familyDir.getName();
            FileStatus[] storeFiles = FSUtils.listStatus((FileSystem)fs, (Path)familyDir, (PathFilter)fileFilter);
            if (storeFiles == null) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("No hfiles found for family: " + familyDir + ", skipping.");
                continue;
            }
            for (FileStatus hfile : storeFiles) {
                Path hfilePath = hfile.getPath();
                visitor.storeFile(regionDir.getName(), familyName, hfilePath.getName());
            }
        }
    }

    public static interface StoreFileVisitor {
        public void storeFile(String var1, String var2, String var3) throws IOException;
    }
}

