/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.authorize.ServiceAuthorizationManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HBasePolicyProvider
extends PolicyProvider {
    protected static final Service[] services = new Service[]{new Service("security.client.protocol.acl", ClientProtos.ClientService.BlockingInterface.class), new Service("security.client.protocol.acl", AdminProtos.AdminService.BlockingInterface.class), new Service("security.admin.protocol.acl", MasterProtos.MasterService.BlockingInterface.class), new Service("security.masterregion.protocol.acl", RegionServerStatusProtos.RegionServerStatusService.BlockingInterface.class)};

    public Service[] getServices() {
        return services;
    }

    public static void init(Configuration conf, ServiceAuthorizationManager authManager) {
        System.setProperty("hadoop.policy.file", "hbase-policy.xml");
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            authManager.refresh(conf, (PolicyProvider)new HBasePolicyProvider());
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        }
    }
}

