/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.procedure2.LockStatus;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;
import org.apache.hadoop.hbase.util.AvlUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class Queue<TKey extends Comparable<TKey>>
extends AvlUtil.AvlLinkedNode<Queue<TKey>> {
    private final TKey key;
    private final int priority;
    private final ProcedureDeque runnables = new ProcedureDeque();
    private final LockStatus lockStatus;

    abstract boolean requireExclusiveLock(Procedure<?> var1);

    protected Queue(TKey key, LockStatus lockStatus) {
        this(key, 1, lockStatus);
    }

    protected Queue(TKey key, int priority, LockStatus lockStatus) {
        assert (priority >= 1) : "priority must be greater than or equal to 1";
        this.key = key;
        this.priority = priority;
        this.lockStatus = lockStatus;
    }

    protected TKey getKey() {
        return this.key;
    }

    public int getPriority() {
        return this.priority;
    }

    protected LockStatus getLockStatus() {
        return this.lockStatus;
    }

    public boolean isAvailable() {
        return !this.lockStatus.hasExclusiveLock() && !this.isEmpty();
    }

    public void add(Procedure<?> proc, boolean addToFront) {
        if (addToFront) {
            this.runnables.addFirst(proc);
        } else {
            this.runnables.addLast(proc);
        }
    }

    public Procedure<?> peek() {
        return (Procedure)this.runnables.peek();
    }

    public Procedure<?> poll() {
        return (Procedure)this.runnables.poll();
    }

    public boolean isEmpty() {
        return this.runnables.isEmpty();
    }

    public int size() {
        return this.runnables.size();
    }

    public int compareKey(TKey cmpKey) {
        return this.key.compareTo(cmpKey);
    }

    public int compareTo(Queue<TKey> other) {
        return this.compareKey(other.key);
    }

    public String toString() {
        return String.format("%s(%s, xlock=%s sharedLock=%s size=%s)", ((Object)((Object)this)).getClass().getSimpleName(), this.key, this.lockStatus.hasExclusiveLock() ? "true (" + this.lockStatus.getExclusiveLockProcIdOwner() + ")" : "false", this.lockStatus.getSharedLockCount(), this.size());
    }
}

