/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.RegionTransitionProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RegionStates {
    private static final Logger LOG = LoggerFactory.getLogger(RegionStates.class);
    protected static final RegionState.State[] STATES_EXPECTED_ON_OPEN = new RegionState.State[]{RegionState.State.OPEN, RegionState.State.OFFLINE, RegionState.State.CLOSED, RegionState.State.SPLITTING, RegionState.State.SPLIT, RegionState.State.OPENING, RegionState.State.FAILED_OPEN};
    protected static final RegionState.State[] STATES_EXPECTED_ON_CLOSE = new RegionState.State[]{RegionState.State.SPLITTING, RegionState.State.SPLIT, RegionState.State.MERGING, RegionState.State.OPEN, RegionState.State.CLOSING};
    public static final RegionStateStampComparator REGION_STATE_STAMP_COMPARATOR = new RegionStateStampComparator();
    private final ConcurrentSkipListMap<byte[], RegionStateNode> regionsMap = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private final ConcurrentSkipListMap<RegionInfo, RegionStateNode> regionInTransition = new ConcurrentSkipListMap(RegionInfo.COMPARATOR);
    private final ConcurrentSkipListMap<RegionInfo, RegionStateNode> regionOffline = new ConcurrentSkipListMap();
    private final ConcurrentSkipListMap<byte[], RegionFailedOpen> regionFailedOpen = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    private final ConcurrentHashMap<ServerName, ServerStateNode> serverMap = new ConcurrentHashMap();

    public void clear() {
        this.regionsMap.clear();
        this.regionInTransition.clear();
        this.regionOffline.clear();
        this.serverMap.clear();
    }

    @VisibleForTesting
    public boolean isRegionInRegionStates(RegionInfo hri) {
        return this.regionsMap.containsKey(hri.getRegionName()) || this.regionInTransition.containsKey(hri) || this.regionOffline.containsKey(hri);
    }

    protected RegionStateNode createRegionStateNode(RegionInfo regionInfo) {
        RegionStateNode newNode = new RegionStateNode(regionInfo);
        RegionStateNode oldNode = this.regionsMap.putIfAbsent(regionInfo.getRegionName(), newNode);
        return oldNode != null ? oldNode : newNode;
    }

    protected RegionStateNode getOrCreateRegionStateNode(RegionInfo regionInfo) {
        RegionStateNode node = this.regionsMap.get(regionInfo.getRegionName());
        return node != null ? node : this.createRegionStateNode(regionInfo);
    }

    RegionStateNode getRegionStateNodeFromName(byte[] regionName) {
        return this.regionsMap.get(regionName);
    }

    protected RegionStateNode getRegionStateNode(RegionInfo regionInfo) {
        return this.getRegionStateNodeFromName(regionInfo.getRegionName());
    }

    public void deleteRegion(RegionInfo regionInfo) {
        this.regionsMap.remove(regionInfo.getRegionName());
        if (this.regionOffline.containsKey(regionInfo)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Removing from regionOffline Map: " + regionInfo);
            }
            this.regionOffline.remove(regionInfo);
        }
    }

    ArrayList<RegionStateNode> getTableRegionStateNodes(TableName tableName) {
        RegionStateNode node;
        ArrayList<RegionStateNode> regions = new ArrayList<RegionStateNode>();
        Iterator iterator = this.regionsMap.tailMap((Object)tableName.getName()).values().iterator();
        while (iterator.hasNext() && (node = (RegionStateNode)iterator.next()).getTable().equals((Object)tableName)) {
            regions.add(node);
        }
        return regions;
    }

    ArrayList<RegionState> getTableRegionStates(TableName tableName) {
        RegionStateNode node;
        ArrayList<RegionState> regions = new ArrayList<RegionState>();
        Iterator iterator = this.regionsMap.tailMap((Object)tableName.getName()).values().iterator();
        while (iterator.hasNext() && (node = (RegionStateNode)iterator.next()).getTable().equals((Object)tableName)) {
            regions.add(node.toRegionState());
        }
        return regions;
    }

    ArrayList<RegionInfo> getTableRegionsInfo(TableName tableName) {
        RegionStateNode node;
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>();
        Iterator iterator = this.regionsMap.tailMap((Object)tableName.getName()).values().iterator();
        while (iterator.hasNext() && (node = (RegionStateNode)iterator.next()).getTable().equals((Object)tableName)) {
            regions.add(node.getRegionInfo());
        }
        return regions;
    }

    Collection<RegionStateNode> getRegionStateNodes() {
        return this.regionsMap.values();
    }

    public ArrayList<RegionState> getRegionStates() {
        ArrayList<RegionState> regions = new ArrayList<RegionState>(this.regionsMap.size());
        for (RegionStateNode node : this.regionsMap.values()) {
            regions.add(node.toRegionState());
        }
        return regions;
    }

    public RegionState getRegionState(RegionInfo regionInfo) {
        RegionStateNode regionStateNode = this.getRegionStateNode(regionInfo);
        return regionStateNode == null ? null : regionStateNode.toRegionState();
    }

    public RegionState getRegionState(String encodedRegionName) {
        for (RegionStateNode node : this.regionsMap.values()) {
            if (!node.getRegionInfo().getEncodedName().equals(encodedRegionName)) continue;
            return node.toRegionState();
        }
        return null;
    }

    public boolean hasTableRegionStates(TableName tableName) {
        return !this.getTableRegionStates(tableName).isEmpty();
    }

    public List<RegionInfo> getRegionsOfTable(TableName table) {
        return this.getRegionsOfTable(table, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRegionLocation createRegionForReopen(RegionStateNode node) {
        RegionStateNode regionStateNode = node;
        synchronized (regionStateNode) {
            if (!this.include(node, false)) {
                return null;
            }
            if (node.isInState(RegionState.State.OPEN)) {
                return new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), node.getOpenSeqNum());
            }
            if (node.isInState(RegionState.State.OPENING)) {
                return new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), -1L);
            }
            return null;
        }
    }

    public List<HRegionLocation> getRegionsOfTableForReopen(TableName tableName) {
        return this.getTableRegionStateNodes(tableName).stream().map(this::createRegionForReopen).filter(r -> r != null).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HRegionLocation checkReopened(HRegionLocation oldLoc) {
        RegionStateNode node;
        RegionStateNode regionStateNode = node = this.getRegionStateNode(oldLoc.getRegion());
        synchronized (regionStateNode) {
            if (oldLoc.getSeqNum() >= 0L) {
                if (node.isInState(RegionState.State.OPEN)) {
                    if (node.getOpenSeqNum() > oldLoc.getSeqNum()) {
                        return null;
                    }
                    return new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), node.getOpenSeqNum());
                }
                return null;
            }
            if (!node.isInState(RegionState.State.OPEN, RegionState.State.OPENING)) {
                return null;
            }
            if (!node.getRegionLocation().equals((Object)oldLoc.getServerName())) {
                return null;
            }
            long openSeqNum = node.isInState(RegionState.State.OPEN) ? node.getOpenSeqNum() : -1L;
            return new HRegionLocation(node.getRegionInfo(), node.getRegionLocation(), openSeqNum);
        }
    }

    public List<RegionInfo> getRegionsOfTable(TableName table, boolean offline) {
        return this.getRegionsOfTable(table, state -> this.include((RegionStateNode)state, offline));
    }

    private List<RegionInfo> getRegionsOfTable(TableName table, Predicate<RegionStateNode> filter) {
        return this.getTableRegionStateNodes(table).stream().filter(filter).map(n -> n.getRegionInfo()).collect(Collectors.toList());
    }

    boolean include(RegionStateNode node, boolean offline) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("WORKING ON " + node + " " + node.getRegionInfo());
        }
        if (node.isInState(RegionState.State.SPLIT)) {
            return false;
        }
        if (node.isInState(RegionState.State.OFFLINE) && !offline) {
            return false;
        }
        RegionInfo hri = node.getRegionInfo();
        return !hri.isOffline() && !hri.isSplit() || (hri.isOffline() || hri.isSplit()) && offline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RegionInfo> getServerRegionInfoSet(ServerName serverName) {
        ServerStateNode serverInfo = this.getServerNode(serverName);
        if (serverInfo == null) {
            return Collections.emptyList();
        }
        ServerStateNode serverStateNode = serverInfo;
        synchronized (serverStateNode) {
            return serverInfo.getRegionInfoList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerState(ServerName serverName, ServerState state) {
        ServerStateNode serverNode;
        ServerStateNode serverStateNode = serverNode = this.getOrCreateServer(serverName);
        synchronized (serverStateNode) {
            serverNode.setState(state);
        }
    }

    public void metaLogSplitting(ServerName serverName) {
        this.setServerState(serverName, ServerState.SPLITTING_META);
    }

    public void metaLogSplit(ServerName serverName) {
        this.setServerState(serverName, ServerState.SPLITTING_META_DONE);
    }

    public void logSplitting(ServerName serverName) {
        this.setServerState(serverName, ServerState.SPLITTING);
    }

    public void logSplit(ServerName serverName) {
        this.setServerState(serverName, ServerState.OFFLINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void updateRegionState(RegionInfo regionInfo, RegionState.State state) {
        RegionStateNode regionNode;
        RegionStateNode regionStateNode = regionNode = this.getOrCreateRegionStateNode(regionInfo);
        synchronized (regionStateNode) {
            regionNode.setState(state, new RegionState.State[0]);
        }
    }

    public List<RegionInfo> getAssignedRegions() {
        ArrayList<RegionInfo> result = new ArrayList<RegionInfo>();
        for (RegionStateNode node : this.regionsMap.values()) {
            if (node.isInTransition()) continue;
            result.add(node.getRegionInfo());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegionInState(RegionInfo regionInfo, RegionState.State ... state) {
        RegionStateNode region = this.getRegionStateNode(regionInfo);
        if (region != null) {
            RegionStateNode regionStateNode = region;
            synchronized (regionStateNode) {
                return region.isInState(state);
            }
        }
        return false;
    }

    public boolean isRegionOnline(RegionInfo regionInfo) {
        return this.isRegionInState(regionInfo, RegionState.State.OPEN);
    }

    public boolean isRegionOffline(RegionInfo regionInfo) {
        return this.isRegionInState(regionInfo, RegionState.State.OFFLINE, RegionState.State.CLOSED);
    }

    public Map<ServerName, List<RegionInfo>> getSnapShotOfAssignment(Collection<RegionInfo> regions) {
        HashMap<ServerName, List<RegionInfo>> result = new HashMap<ServerName, List<RegionInfo>>();
        for (RegionInfo hri : regions) {
            ServerName serverName;
            RegionStateNode node = this.getRegionStateNode(hri);
            if (node == null || (serverName = node.getRegionLocation()) == null) continue;
            ArrayList<RegionInfo> serverRegions = (ArrayList<RegionInfo>)result.get(serverName);
            if (serverRegions == null) {
                serverRegions = new ArrayList<RegionInfo>();
                result.put(serverName, serverRegions);
            }
            serverRegions.add(node.getRegionInfo());
        }
        return result;
    }

    public Map<RegionInfo, ServerName> getRegionAssignments() {
        HashMap<RegionInfo, ServerName> assignments = new HashMap<RegionInfo, ServerName>();
        for (RegionStateNode node : this.regionsMap.values()) {
            assignments.put(node.getRegionInfo(), node.getRegionLocation());
        }
        return assignments;
    }

    public Map<RegionState.State, List<RegionInfo>> getRegionByStateOfTable(TableName tableName) {
        RegionState.State[] states = RegionState.State.values();
        HashMap<RegionState.State, List<RegionInfo>> tableRegions = new HashMap<RegionState.State, List<RegionInfo>>(states.length);
        for (int i = 0; i < states.length; ++i) {
            tableRegions.put(states[i], new ArrayList());
        }
        for (RegionStateNode node : this.regionsMap.values()) {
            if (!node.getTable().equals((Object)tableName)) continue;
            ((List)tableRegions.get(node.getState())).add(node.getRegionInfo());
        }
        return tableRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerName getRegionServerOfRegion(RegionInfo regionInfo) {
        RegionStateNode region = this.getRegionStateNode(regionInfo);
        if (region != null) {
            RegionStateNode regionStateNode = region;
            synchronized (regionStateNode) {
                ServerName server = region.getRegionLocation();
                return server != null ? server : region.getLastHost();
            }
        }
        return null;
    }

    public Map<TableName, Map<ServerName, List<RegionInfo>>> getAssignmentsByTable(boolean forceByCluster) {
        if (!forceByCluster) {
            return this.getAssignmentsByTable();
        }
        HashMap<ServerName, ArrayList<RegionInfo>> ensemble = new HashMap<ServerName, ArrayList<RegionInfo>>(this.serverMap.size());
        for (ServerStateNode serverNode : this.serverMap.values()) {
            ensemble.put(serverNode.getServerName(), serverNode.getRegionInfoList());
        }
        HashMap<TableName, Map<ServerName, List<RegionInfo>>> result = new HashMap<TableName, Map<ServerName, List<RegionInfo>>>(1);
        result.put(HConstants.ENSEMBLE_TABLE_NAME, ensemble);
        return result;
    }

    public Map<TableName, Map<ServerName, List<RegionInfo>>> getAssignmentsByTable() {
        HashMap<TableName, Map<ServerName, List<RegionInfo>>> result = new HashMap<TableName, Map<ServerName, List<RegionInfo>>>();
        for (RegionStateNode node : this.regionsMap.values()) {
            ServerName serverName;
            HashMap<ServerName, ArrayList<RegionInfo>> tableResult = (HashMap<ServerName, ArrayList<RegionInfo>>)result.get(node.getTable());
            if (tableResult == null) {
                tableResult = new HashMap<ServerName, ArrayList<RegionInfo>>();
                result.put(node.getTable(), tableResult);
            }
            if ((serverName = node.getRegionLocation()) == null) {
                LOG.info("Skipping, no server for " + node);
                continue;
            }
            ArrayList<RegionInfo> serverResult = (ArrayList<RegionInfo>)tableResult.get(serverName);
            if (serverResult == null) {
                serverResult = new ArrayList<RegionInfo>();
                tableResult.put(serverName, serverResult);
            }
            serverResult.add(node.getRegionInfo());
        }
        for (Map table : result.values()) {
            for (ServerName svr : this.serverMap.keySet()) {
                if (table.containsKey(svr)) continue;
                table.put(svr, new ArrayList());
            }
        }
        return result;
    }

    protected boolean addRegionInTransition(RegionStateNode regionNode, RegionTransitionProcedure procedure) {
        if (procedure != null && !regionNode.setProcedure(procedure)) {
            return false;
        }
        this.regionInTransition.put(regionNode.getRegionInfo(), regionNode);
        return true;
    }

    protected void removeRegionInTransition(RegionStateNode regionNode, RegionTransitionProcedure procedure) {
        this.regionInTransition.remove(regionNode.getRegionInfo());
        regionNode.unsetProcedure(procedure);
    }

    public boolean hasRegionsInTransition() {
        return !this.regionInTransition.isEmpty();
    }

    public boolean isRegionInTransition(RegionInfo regionInfo) {
        RegionStateNode node = this.regionInTransition.get(regionInfo);
        return node != null ? node.isInTransition() : false;
    }

    public RegionTransitionProcedure getRegionTransitionProcedure(RegionInfo hri) {
        RegionStateNode node = this.regionInTransition.get(hri);
        if (node == null) {
            return null;
        }
        return node.getProcedure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionState getRegionTransitionState(RegionInfo hri) {
        RegionStateNode node = this.regionInTransition.get(hri);
        if (node == null) {
            return null;
        }
        RegionStateNode regionStateNode = node;
        synchronized (regionStateNode) {
            return node.isInTransition() ? node.toRegionState() : null;
        }
    }

    public List<RegionStateNode> getRegionsInTransition() {
        return new ArrayList<RegionStateNode>(this.regionInTransition.values());
    }

    public int getRegionsInTransitionCount() {
        return this.regionInTransition.size();
    }

    public List<RegionState> getRegionsStateInTransition() {
        ArrayList<RegionState> rit = new ArrayList<RegionState>(this.regionInTransition.size());
        for (RegionStateNode node : this.regionInTransition.values()) {
            rit.add(node.toRegionState());
        }
        return rit;
    }

    public SortedSet<RegionState> getRegionsInTransitionOrderedByTimestamp() {
        TreeSet<RegionState> rit = new TreeSet<RegionState>(REGION_STATE_STAMP_COMPARATOR);
        for (RegionStateNode node : this.regionInTransition.values()) {
            rit.add(node.toRegionState());
        }
        return rit;
    }

    public void addToOfflineRegions(RegionStateNode regionNode) {
        LOG.info("Added to offline, CURRENTLY NEVER CLEARED!!! " + regionNode);
        this.regionOffline.put(regionNode.getRegionInfo(), regionNode);
    }

    public void removeFromOfflineRegions(RegionInfo regionInfo) {
        this.regionOffline.remove(regionInfo);
    }

    public RegionFailedOpen addToFailedOpen(RegionStateNode regionNode) {
        byte[] key = regionNode.getRegionInfo().getRegionName();
        RegionFailedOpen node = this.regionFailedOpen.get(key);
        if (node == null) {
            RegionFailedOpen newNode = new RegionFailedOpen(regionNode);
            RegionFailedOpen oldNode = this.regionFailedOpen.putIfAbsent(key, newNode);
            node = oldNode != null ? oldNode : newNode;
        }
        return node;
    }

    public RegionFailedOpen getFailedOpen(RegionInfo regionInfo) {
        return this.regionFailedOpen.get(regionInfo.getRegionName());
    }

    public void removeFromFailedOpen(RegionInfo regionInfo) {
        this.regionFailedOpen.remove(regionInfo.getRegionName());
    }

    public List<RegionState> getRegionFailedOpen() {
        if (this.regionFailedOpen.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RegionState> regions = new ArrayList<RegionState>(this.regionFailedOpen.size());
        for (RegionFailedOpen r : this.regionFailedOpen.values()) {
            regions.add(r.getRegionStateNode().toRegionState());
        }
        return regions;
    }

    public ServerStateNode getOrCreateServer(ServerName serverName) {
        ServerStateNode node = this.serverMap.get(serverName);
        if (node == null) {
            node = new ServerStateNode(serverName);
            ServerStateNode oldNode = this.serverMap.putIfAbsent(serverName, node);
            node = oldNode != null ? oldNode : node;
        }
        return node;
    }

    public void removeServer(ServerName serverName) {
        this.serverMap.remove(serverName);
    }

    protected ServerStateNode getServerNode(ServerName serverName) {
        return this.serverMap.get(serverName);
    }

    public double getAverageLoad() {
        int numServers = 0;
        int totalLoad = 0;
        for (ServerStateNode node : this.serverMap.values()) {
            totalLoad += node.getRegionCount();
            ++numServers;
        }
        return numServers == 0 ? 0.0 : (double)totalLoad / (double)numServers;
    }

    public ServerStateNode addRegionToServer(RegionStateNode regionNode) {
        ServerStateNode serverNode = this.getOrCreateServer(regionNode.getRegionLocation());
        serverNode.addRegion(regionNode);
        return serverNode;
    }

    public ServerStateNode removeRegionFromServer(ServerName serverName, RegionStateNode regionNode) {
        ServerStateNode serverNode = this.getOrCreateServer(serverName);
        serverNode.removeRegion(regionNode);
        return serverNode;
    }

    public static String regionNamesToString(Collection<byte[]> regions) {
        StringBuilder sb = new StringBuilder();
        Iterator<byte[]> it = regions.iterator();
        sb.append("[");
        if (it.hasNext()) {
            sb.append(Bytes.toStringBinary((byte[])it.next()));
            while (it.hasNext()) {
                sb.append(", ");
                sb.append(Bytes.toStringBinary((byte[])it.next()));
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static final class RegionFailedOpen {
        private final RegionStateNode regionNode;
        private volatile Exception exception = null;
        private AtomicInteger retries = new AtomicInteger();

        public RegionFailedOpen(RegionStateNode regionNode) {
            this.regionNode = regionNode;
        }

        public RegionStateNode getRegionStateNode() {
            return this.regionNode;
        }

        public RegionInfo getRegionInfo() {
            return this.regionNode.getRegionInfo();
        }

        public int incrementAndGetRetries() {
            return this.retries.incrementAndGet();
        }

        public int getRetries() {
            return this.retries.get();
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public static class ServerStateNode
    implements Comparable<ServerStateNode> {
        private final ServerReportEvent reportEvent;
        private final Set<RegionStateNode> regions;
        private final ServerName serverName;
        private volatile ServerState state = ServerState.ONLINE;

        public ServerStateNode(ServerName serverName) {
            this.serverName = serverName;
            this.regions = ConcurrentHashMap.newKeySet();
            this.reportEvent = new ServerReportEvent(serverName);
        }

        public ServerName getServerName() {
            return this.serverName;
        }

        public ServerState getState() {
            return this.state;
        }

        public ProcedureEvent<?> getReportEvent() {
            return this.reportEvent;
        }

        public boolean isInState(ServerState ... expected) {
            boolean expectedState = false;
            if (expected != null) {
                for (int i = 0; i < expected.length; ++i) {
                    expectedState |= this.state == expected[i];
                }
            }
            return expectedState;
        }

        private void setState(ServerState state) {
            this.state = state;
        }

        public Set<RegionStateNode> getRegions() {
            return this.regions;
        }

        public int getRegionCount() {
            return this.regions.size();
        }

        public ArrayList<RegionInfo> getRegionInfoList() {
            ArrayList<RegionInfo> hris = new ArrayList<RegionInfo>(this.regions.size());
            for (RegionStateNode region : this.regions) {
                hris.add(region.getRegionInfo());
            }
            return hris;
        }

        public void addRegion(RegionStateNode regionNode) {
            this.regions.add(regionNode);
        }

        public void removeRegion(RegionStateNode regionNode) {
            this.regions.remove(regionNode);
        }

        @Override
        public int compareTo(ServerStateNode other) {
            return this.getServerName().compareTo(other.getServerName());
        }

        public int hashCode() {
            return this.getServerName().hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerStateNode)) {
                return false;
            }
            return this.compareTo((ServerStateNode)other) == 0;
        }

        public String toString() {
            return String.format("ServerStateNode(%s)", this.getServerName());
        }
    }

    public static enum ServerState {
        ONLINE,
        SPLITTING_META,
        SPLITTING_META_DONE,
        SPLITTING,
        OFFLINE;

    }

    private static class RegionStateStampComparator
    implements Comparator<RegionState> {
        private RegionStateStampComparator() {
        }

        @Override
        public int compare(RegionState l, RegionState r) {
            int stampCmp = Long.compare(l.getStamp(), r.getStamp());
            return stampCmp != 0 ? stampCmp : RegionInfo.COMPARATOR.compare(l.getRegion(), r.getRegion());
        }
    }

    public static class RegionStateNode
    implements Comparable<RegionStateNode> {
        private final RegionInfo regionInfo;
        private final ProcedureEvent<?> event;
        private volatile RegionTransitionProcedure procedure = null;
        private volatile ServerName regionLocation = null;
        private volatile ServerName lastHost = null;
        private volatile RegionState.State state = RegionState.State.OFFLINE;
        private volatile long lastUpdate = 0L;
        private volatile long openSeqNum = -1L;

        public RegionStateNode(RegionInfo regionInfo) {
            this.regionInfo = regionInfo;
            this.event = new AssignmentProcedureEvent(regionInfo);
        }

        public boolean setState(RegionState.State update, RegionState.State ... expected) {
            if (!this.isInState(expected)) {
                return false;
            }
            this.state = update;
            this.lastUpdate = EnvironmentEdgeManager.currentTime();
            return true;
        }

        public ServerName offline() {
            this.setState(RegionState.State.OFFLINE, new RegionState.State[0]);
            return this.setRegionLocation(null);
        }

        public void transitionState(RegionState.State update, RegionState.State ... expected) throws UnexpectedStateException {
            if (!this.setState(update, expected)) {
                throw new UnexpectedStateException("Expected " + Arrays.toString(expected) + " so could move to " + update + " but current state=" + this.getState());
            }
        }

        public boolean isInState(RegionState.State ... expected) {
            if (expected != null && expected.length > 0) {
                boolean expectedState = false;
                for (int i = 0; i < expected.length; ++i) {
                    expectedState |= this.getState() == expected[i];
                }
                return expectedState;
            }
            return true;
        }

        public boolean isStuck() {
            return this.isInState(RegionState.State.FAILED_OPEN) && this.getProcedure() != null;
        }

        public boolean isInTransition() {
            return this.getProcedure() != null;
        }

        public long getLastUpdate() {
            return this.procedure != null ? this.procedure.getLastUpdate() : this.lastUpdate;
        }

        public void setLastHost(ServerName serverName) {
            this.lastHost = serverName;
        }

        public void setOpenSeqNum(long seqId) {
            this.openSeqNum = seqId;
        }

        public ServerName setRegionLocation(ServerName serverName) {
            ServerName lastRegionLocation = this.regionLocation;
            if (LOG.isTraceEnabled() && serverName == null) {
                LOG.trace("Tracking when we are set to null " + this, new Throwable("TRACE"));
            }
            this.regionLocation = serverName;
            this.lastUpdate = EnvironmentEdgeManager.currentTime();
            return lastRegionLocation;
        }

        public boolean setProcedure(RegionTransitionProcedure proc) {
            if (this.procedure != null && this.procedure != proc) {
                return false;
            }
            this.procedure = proc;
            return true;
        }

        public boolean unsetProcedure(RegionTransitionProcedure proc) {
            if (this.procedure != null && this.procedure != proc) {
                return false;
            }
            this.procedure = null;
            return true;
        }

        public RegionTransitionProcedure getProcedure() {
            return this.procedure;
        }

        public ProcedureEvent<?> getProcedureEvent() {
            return this.event;
        }

        public RegionInfo getRegionInfo() {
            return this.regionInfo;
        }

        public TableName getTable() {
            return this.getRegionInfo().getTable();
        }

        public boolean isSystemTable() {
            return this.getTable().isSystemTable();
        }

        public ServerName getLastHost() {
            return this.lastHost;
        }

        public ServerName getRegionLocation() {
            return this.regionLocation;
        }

        public RegionState.State getState() {
            return this.state;
        }

        public long getOpenSeqNum() {
            return this.openSeqNum;
        }

        public int getFormatVersion() {
            return 0;
        }

        public RegionState toRegionState() {
            return new RegionState(this.getRegionInfo(), this.getState(), this.getLastUpdate(), this.getRegionLocation());
        }

        @Override
        public int compareTo(RegionStateNode other) {
            return RegionInfo.COMPARATOR.compare(this.getRegionInfo(), other.getRegionInfo());
        }

        public int hashCode() {
            return this.getRegionInfo().hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegionStateNode)) {
                return false;
            }
            return this.compareTo((RegionStateNode)other) == 0;
        }

        public String toString() {
            return this.toDescriptiveString();
        }

        public String toShortString() {
            return String.format("rit=%s, location=%s", this.getState(), this.getRegionLocation());
        }

        public String toDescriptiveString() {
            return String.format("%s, table=%s, region=%s", this.toShortString(), this.getTable(), this.getRegionInfo().getEncodedName());
        }
    }

    private static class ServerReportEvent
    extends ProcedureEvent<ServerName> {
        public ServerReportEvent(ServerName serverName) {
            super((Object)serverName);
        }
    }

    private static class AssignmentProcedureEvent
    extends ProcedureEvent<RegionInfo> {
        public AssignmentProcedureEvent(RegionInfo regionInfo) {
            super((Object)regionInfo);
        }
    }
}

