/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class ZKServerTool {
    public static ServerName[] readZKNodes(Configuration conf) {
        String[] values;
        LinkedList<ServerName> hosts = new LinkedList<ServerName>();
        String quorum = conf.get("hbase.zookeeper.quorum", "localhost");
        for (String value : values = quorum.split(",")) {
            String[] parts = value.split(":");
            String host = parts[0];
            int port = 2181;
            if (parts.length > 1) {
                port = Integer.parseInt(parts[1]);
            }
            hosts.add(ServerName.valueOf((String)host, (int)port, (long)-1L));
        }
        return hosts.toArray(new ServerName[hosts.size()]);
    }

    public static void main(String[] args) {
        for (ServerName server : ZKServerTool.readZKNodes(HBaseConfiguration.create())) {
            System.out.println("ZK host: " + server.getHostname());
        }
    }
}

