/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Stable
public abstract class JvmVersion {
    private static Set<String> BAD_JVM_VERSIONS = new HashSet<String>();

    public static boolean isBadJvmVersion() {
        String version = System.getProperty("java.version");
        return version != null && BAD_JVM_VERSIONS.contains(version);
    }

    public static String getVersion() {
        return System.getProperty("java.vm.vendor", "UNKNOWN_VM_VENDOR") + ' ' + System.getProperty("java.version", "UNKNOWN_JAVA_VERSION") + '-' + System.getProperty("java.vm.version", "UNKNOWN_VM_VERSION");
    }

    static {
        BAD_JVM_VERSIONS.add("1.6.0_18");
    }
}

