/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.AbstractMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.StripeMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.StripeStoreFileManager;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.regionserver.compactions.StripeCompactionPolicy;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;

@InterfaceAudience.Private
public class StripeStoreFlusher
extends StoreFlusher {
    private static final Log LOG = LogFactory.getLog(StripeStoreFlusher.class);
    private final Object flushLock = new Object();
    private final StripeCompactionPolicy policy;
    private final StripeCompactionPolicy.StripeInformationProvider stripes;

    public StripeStoreFlusher(Configuration conf, Store store, StripeCompactionPolicy policy, StripeStoreFileManager stripes) {
        super(conf, store);
        this.policy = policy;
        this.stripes = stripes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Path> flushSnapshot(MemStoreSnapshot snapshot, long cacheFlushSeqNum, MonitoredTask status, ThroughputController throughputController) throws IOException {
        List<Path> result = new ArrayList<Path>();
        int cellsCount = snapshot.getCellsCount();
        if (cellsCount == 0) {
            return result;
        }
        long smallestReadPoint = this.store.getSmallestReadPoint();
        InternalScanner scanner = this.createScanner(snapshot.getScanner(), smallestReadPoint);
        if (scanner == null) {
            return result;
        }
        StripeFlushRequest req = this.policy.selectFlush(this.store.getComparator(), this.stripes, cellsCount);
        boolean success = false;
        StripeMultiFileWriter mw = null;
        try {
            mw = req.createWriter();
            AbstractMultiFileWriter.WriterFactory factory = this.createWriterFactory(snapshot.getTimeRangeTracker(), cellsCount);
            StoreScanner storeScanner = scanner instanceof StoreScanner ? (StoreScanner)scanner : null;
            mw.init(storeScanner, factory);
            Object object = this.flushLock;
            synchronized (object) {
                this.performFlush(scanner, mw, smallestReadPoint, throughputController);
                result = mw.commitWriters(cacheFlushSeqNum, false);
                success = true;
            }
        }
        finally {
            if (!success && mw != null) {
                for (Path leftoverFile : mw.abortWriters()) {
                    try {
                        this.store.getFileSystem().delete(leftoverFile, false);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to delete a file after failed flush: " + e));
                    }
                }
            }
            try {
                scanner.close();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Failed to close flush scanner, ignoring", (Throwable)ex);
            }
        }
        return result;
    }

    private AbstractMultiFileWriter.WriterFactory createWriterFactory(final TimeRangeTracker tracker, final long kvCount) {
        return new AbstractMultiFileWriter.WriterFactory(){

            @Override
            public StoreFile.Writer createWriter() throws IOException {
                StoreFile.Writer writer = StripeStoreFlusher.this.store.createWriterInTmp(kvCount, StripeStoreFlusher.this.store.getFamily().getCompression(), false, true, true, false, tracker, -1L);
                return writer;
            }
        };
    }

    public static class SizeStripeFlushRequest
    extends StripeFlushRequest {
        private final int targetCount;
        private final long targetKvs;

        public SizeStripeFlushRequest(KeyValue.KVComparator comparator, int targetCount, long targetKvs) {
            super(comparator);
            this.targetCount = targetCount;
            this.targetKvs = targetKvs;
        }

        @Override
        public StripeMultiFileWriter createWriter() throws IOException {
            return new StripeMultiFileWriter.SizeMultiWriter(this.comparator, this.targetCount, this.targetKvs, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
        }
    }

    public static class BoundaryStripeFlushRequest
    extends StripeFlushRequest {
        private final List<byte[]> targetBoundaries;

        public BoundaryStripeFlushRequest(KeyValue.KVComparator comparator, List<byte[]> targetBoundaries) {
            super(comparator);
            this.targetBoundaries = targetBoundaries;
        }

        @Override
        public StripeMultiFileWriter createWriter() throws IOException {
            return new StripeMultiFileWriter.BoundaryMultiWriter(this.comparator, this.targetBoundaries, null, null);
        }
    }

    public static class StripeFlushRequest {
        protected final KeyValue.KVComparator comparator;

        public StripeFlushRequest(KeyValue.KVComparator comparator) {
            this.comparator = comparator;
        }

        public StripeMultiFileWriter createWriter() throws IOException {
            StripeMultiFileWriter.SizeMultiWriter writer = new StripeMultiFileWriter.SizeMultiWriter(this.comparator, 1, Long.MAX_VALUE, StripeStoreFileManager.OPEN_KEY, StripeStoreFileManager.OPEN_KEY);
            writer.setNoStripeMetadata();
            return writer;
        }
    }
}

