/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namequeues.impl;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.SlowLogParams;
import org.apache.hadoop.hbase.namequeues.LogHandlerUtils;
import org.apache.hadoop.hbase.namequeues.NamedQueuePayload;
import org.apache.hadoop.hbase.namequeues.NamedQueueService;
import org.apache.hadoop.hbase.namequeues.RpcLogDetails;
import org.apache.hadoop.hbase.namequeues.SlowLogPersistentService;
import org.apache.hadoop.hbase.namequeues.queue.EvictingQueue;
import org.apache.hadoop.hbase.namequeues.request.NamedQueueGetRequest;
import org.apache.hadoop.hbase.namequeues.response.NamedQueueGetResponse;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.TooSlowLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowLogQueueService
implements NamedQueueService {
    private static final Logger LOG = LoggerFactory.getLogger(SlowLogQueueService.class);
    private static final String SLOW_LOG_RING_BUFFER_SIZE = "hbase.regionserver.slowlog.ringbuffer.size";
    private final boolean isOnlineLogProviderEnabled;
    private final boolean isSlowLogTableEnabled;
    private final SlowLogPersistentService slowLogPersistentService;
    private final EvictingQueue<TooSlowLog.SlowLogPayload> slowLogQueue;

    public SlowLogQueueService(Configuration conf) {
        this.isOnlineLogProviderEnabled = conf.getBoolean("hbase.regionserver.slowlog.buffer.enabled", false);
        if (!this.isOnlineLogProviderEnabled) {
            this.isSlowLogTableEnabled = false;
            this.slowLogPersistentService = null;
            this.slowLogQueue = null;
            return;
        }
        int slowLogQueueSize = conf.getInt(SLOW_LOG_RING_BUFFER_SIZE, 256);
        this.slowLogQueue = EvictingQueue.create(slowLogQueueSize);
        this.isSlowLogTableEnabled = conf.getBoolean("hbase.regionserver.slowlog.systable.enabled", false);
        this.slowLogPersistentService = this.isSlowLogTableEnabled ? new SlowLogPersistentService(conf) : null;
    }

    @Override
    public NamedQueuePayload.NamedQueueEvent getEvent() {
        return NamedQueuePayload.NamedQueueEvent.SLOW_LOG;
    }

    @Override
    public void consumeEventFromDisruptor(NamedQueuePayload namedQueuePayload) {
        if (!this.isOnlineLogProviderEnabled) {
            return;
        }
        if (!(namedQueuePayload instanceof RpcLogDetails)) {
            LOG.warn("SlowLogQueueService: NamedQueuePayload is not of type RpcLogDetails.");
            return;
        }
        RpcLogDetails rpcLogDetails = (RpcLogDetails)namedQueuePayload;
        Descriptors.MethodDescriptor methodDescriptor = rpcLogDetails.getMethodDescriptor();
        String clientAddress = rpcLogDetails.getClientAddress();
        long responseSize = rpcLogDetails.getResponseSize();
        String className = rpcLogDetails.getClassName();
        TooSlowLog.SlowLogPayload.Type type = this.getLogType(rpcLogDetails);
        if (type == null) {
            return;
        }
        Message param = rpcLogDetails.getParam();
        long receiveTime = rpcLogDetails.getReceiveTime();
        long startTime = rpcLogDetails.getStartTime();
        long endTime = System.currentTimeMillis();
        int processingTime = (int)(endTime - startTime);
        int qTime = (int)(startTime - receiveTime);
        SlowLogParams slowLogParams = ProtobufUtil.getSlowLogParams((Message)param);
        int numGets = 0;
        int numMutations = 0;
        int numServiceCalls = 0;
        if (param instanceof ClientProtos.MultiRequest) {
            ClientProtos.MultiRequest multi = (ClientProtos.MultiRequest)param;
            for (ClientProtos.RegionAction regionAction : multi.getRegionActionList()) {
                for (ClientProtos.Action action : regionAction.getActionList()) {
                    if (action.hasMutation()) {
                        ++numMutations;
                    }
                    if (action.hasGet()) {
                        ++numGets;
                    }
                    if (!action.hasServiceCall()) continue;
                    ++numServiceCalls;
                }
            }
        }
        String userName = rpcLogDetails.getUserName() != null ? rpcLogDetails.getUserName() : "";
        String methodDescriptorName = methodDescriptor != null ? methodDescriptor.getName() : "";
        TooSlowLog.SlowLogPayload slowLogPayload = TooSlowLog.SlowLogPayload.newBuilder().setCallDetails(methodDescriptorName + "(" + param.getClass().getName() + ")").setClientAddress(clientAddress).setMethodName(methodDescriptorName).setMultiGets(numGets).setMultiMutations(numMutations).setMultiServiceCalls(numServiceCalls).setParam(slowLogParams != null ? slowLogParams.getParams() : "").setProcessingTime(processingTime).setQueueTime(qTime).setRegionName(slowLogParams != null ? slowLogParams.getRegionName() : "").setResponseSize(responseSize).setServerClass(className).setStartTime(startTime).setType(type).setUserName(userName).build();
        this.slowLogQueue.add(slowLogPayload);
        if (this.isSlowLogTableEnabled && !slowLogPayload.getRegionName().startsWith("hbase:slowlog")) {
            this.slowLogPersistentService.addToQueueForSysTable(slowLogPayload);
        }
    }

    @Override
    public boolean clearNamedQueue() {
        if (!this.isOnlineLogProviderEnabled) {
            return false;
        }
        LOG.debug("Received request to clean up online slowlog buffer.");
        this.slowLogQueue.clear();
        return true;
    }

    @Override
    public NamedQueueGetResponse getNamedQueueRecords(NamedQueueGetRequest request) {
        if (!this.isOnlineLogProviderEnabled) {
            return null;
        }
        AdminProtos.SlowLogResponseRequest slowLogResponseRequest = request.getSlowLogResponseRequest();
        List<TooSlowLog.SlowLogPayload> slowLogPayloads = AdminProtos.SlowLogResponseRequest.LogType.LARGE_LOG.equals((Object)slowLogResponseRequest.getLogType()) ? this.getLargeLogPayloads(slowLogResponseRequest) : this.getSlowLogPayloads(slowLogResponseRequest);
        NamedQueueGetResponse response = new NamedQueueGetResponse();
        response.setNamedQueueEvent(0);
        response.setSlowLogPayloads(slowLogPayloads);
        return response;
    }

    private TooSlowLog.SlowLogPayload.Type getLogType(RpcLogDetails rpcCallDetails) {
        boolean isSlowLog = rpcCallDetails.isSlowLog();
        boolean isLargeLog = rpcCallDetails.isLargeLog();
        if (!isSlowLog && !isLargeLog) {
            LOG.error("slowLog and largeLog both are false. Ignoring the event. rpcCallDetails: {}", (Object)rpcCallDetails);
            return null;
        }
        TooSlowLog.SlowLogPayload.Type type = isSlowLog && isLargeLog ? TooSlowLog.SlowLogPayload.Type.ALL : (isSlowLog ? TooSlowLog.SlowLogPayload.Type.SLOW_LOG : TooSlowLog.SlowLogPayload.Type.LARGE_LOG);
        return type;
    }

    @Override
    public void persistAll() {
        if (!this.isOnlineLogProviderEnabled) {
            return;
        }
        if (this.slowLogPersistentService != null) {
            this.slowLogPersistentService.addAllLogsToSysTable();
        }
    }

    private List<TooSlowLog.SlowLogPayload> getSlowLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        TooSlowLog.SlowLogPayload[] slowLogPayloads = this.slowLogQueue.toArray(new TooSlowLog.SlowLogPayload[0]);
        ArrayList<TooSlowLog.SlowLogPayload> slowLogPayloadList = new ArrayList<TooSlowLog.SlowLogPayload>();
        for (TooSlowLog.SlowLogPayload slowLogPayload : slowLogPayloads) {
            if (slowLogPayload.getType() != TooSlowLog.SlowLogPayload.Type.ALL && slowLogPayload.getType() != TooSlowLog.SlowLogPayload.Type.SLOW_LOG) continue;
            slowLogPayloadList.add(slowLogPayload);
        }
        Collections.reverse(slowLogPayloadList);
        return LogHandlerUtils.getFilteredLogs(request, slowLogPayloadList);
    }

    private List<TooSlowLog.SlowLogPayload> getLargeLogPayloads(AdminProtos.SlowLogResponseRequest request) {
        TooSlowLog.SlowLogPayload[] slowLogPayloads = this.slowLogQueue.toArray(new TooSlowLog.SlowLogPayload[0]);
        ArrayList<TooSlowLog.SlowLogPayload> slowLogPayloadList = new ArrayList<TooSlowLog.SlowLogPayload>();
        for (TooSlowLog.SlowLogPayload slowLogPayload : slowLogPayloads) {
            if (slowLogPayload.getType() != TooSlowLog.SlowLogPayload.Type.ALL && slowLogPayload.getType() != TooSlowLog.SlowLogPayload.Type.LARGE_LOG) continue;
            slowLogPayloadList.add(slowLogPayload);
        }
        Collections.reverse(slowLogPayloadList);
        return LogHandlerUtils.getFilteredLogs(request, slowLogPayloadList);
    }
}

