/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.slowlog;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.slowlog.SlowLogTableAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SlowLogMasterService {
    private static final Logger LOG = LoggerFactory.getLogger(SlowLogMasterService.class);
    private final boolean slowlogTableEnabled;
    private final MasterServices masterServices;
    private static final HTableDescriptor TABLE_DESCRIPTOR_BUILDER = new HTableDescriptor(SlowLogTableAccessor.SLOW_LOG_TABLE_NAME).setRegionReplication(1);

    public SlowLogMasterService(Configuration configuration, MasterServices masterServices) {
        this.slowlogTableEnabled = configuration.getBoolean("hbase.regionserver.slowlog.systable.enabled", false);
        this.masterServices = masterServices;
    }

    public void init() throws IOException {
        if (!this.slowlogTableEnabled) {
            LOG.info("Slow/Large requests logging to system table hbase:slowlog is disabled. Quitting.");
            return;
        }
        if (!MetaTableAccessor.tableExists((Connection)this.masterServices.getConnection(), (TableName)SlowLogTableAccessor.SLOW_LOG_TABLE_NAME)) {
            LOG.info("slowlog table not found. Creating.");
            this.masterServices.createSystemTable(TABLE_DESCRIPTOR_BUILDER);
        }
    }

    static {
        TABLE_DESCRIPTOR_BUILDER.addFamily(new HColumnDescriptor(HConstants.SLOWLOG_INFO_FAMILY).setScope(0).setBlockCacheEnabled(false).setMaxVersions(1));
    }
}

