/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.cleaner;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.master.cleaner.CleanerChore;

@InterfaceAudience.Private
public class DirScanPool
implements ConfigurationObserver {
    private static final Log LOG = LogFactory.getLog(DirScanPool.class);
    private volatile int size;
    private final ThreadPoolExecutor pool;
    private int cleanerLatch;
    private boolean reconfigNotification;

    public DirScanPool(Configuration conf) {
        String poolSize = conf.get("hbase.cleaner.scan.dir.concurrent.size", "0.25");
        this.size = CleanerChore.calculatePoolSize(poolSize);
        this.size = this.size == 0 ? CleanerChore.calculatePoolSize("0.25") : this.size;
        this.pool = DirScanPool.initializePool(this.size);
        LOG.info((Object)("Cleaner pool size is " + this.size));
        this.cleanerLatch = 0;
    }

    private static ThreadPoolExecutor initializePool(int size) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(size, size, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("dir-scan-pool"));
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public synchronized void onConfigurationChange(Configuration conf) {
        int newSize = CleanerChore.calculatePoolSize(conf.get("hbase.cleaner.scan.dir.concurrent.size", "0.25"));
        if (newSize == this.size) {
            LOG.trace((Object)("Size from configuration is same as previous=" + newSize + ", no need to update."));
            return;
        }
        this.size = newSize;
        this.reconfigNotification = true;
    }

    synchronized void latchCountUp() {
        ++this.cleanerLatch;
    }

    synchronized void latchCountDown() {
        --this.cleanerLatch;
        this.notifyAll();
    }

    synchronized void execute(Runnable runnable) {
        this.pool.execute(runnable);
    }

    public synchronized void shutdownNow() {
        if (this.pool == null || this.pool.isShutdown()) {
            return;
        }
        this.pool.shutdownNow();
    }

    synchronized void tryUpdatePoolSize(long timeout) {
        if (!this.reconfigNotification) {
            return;
        }
        this.reconfigNotification = false;
        long stopTime = System.currentTimeMillis() + timeout;
        while (this.cleanerLatch != 0 && timeout > 0L) {
            try {
                this.wait(timeout);
                timeout = stopTime - System.currentTimeMillis();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        LOG.info((Object)("Update chore's pool size from " + this.pool.getPoolSize() + " to " + this.size));
        this.pool.setCorePoolSize(this.size);
    }

    public int getSize() {
        return this.size;
    }
}

